/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.util.i18n.StringManager;

public class ResourceDeployEvent
extends BaseDeployEvent
implements Cloneable {
    public static final String RES_TYPE_CUSTOM = "custom";
    public static final String RES_TYPE_EXTERNAL_JNDI = "external-jndi";
    public static final String RES_TYPE_JDBC = "jdbc";
    public static final String RES_TYPE_MAIL = "mail";
    public static final String RES_TYPE_JMS = "jms";
    public static final String RES_TYPE_PMF = "pmf";
    public static final String RES_TYPE_JCP = "jcp";
    public static final String RES_TYPE_AOR = "aor";
    public static final String RES_TYPE_CCP = "ccp";
    public static final String RES_TYPE_CR = "cr";
    public static final String RES_TYPE_RAC = "rac";
    static final String eventType = ResourceDeployEvent.class.getName();
    private String resourceType;
    private boolean resourceExists = true;
    private boolean noOp = false;
    private static StringManager localStrings = StringManager.getManager(ResourceDeployEvent.class);

    public ResourceDeployEvent(String instance, String resourceName, String resourceType, String actionCode) {
        super(eventType, instance, "resource", resourceName, actionCode);
        if (resourceType != null) {
            this.setResourceType(resourceType);
        }
        if ("deploy".equals(actionCode)) {
            this.resourceExists = false;
        }
    }

    private ResourceDeployEvent(String type, Object source, long seqNumber, long time) {
        super(type, source, seqNumber, time);
        this.setResourceType(type);
        this.j2eeComponentType = "resource";
    }

    public String getResourceName() {
        return this.getJ2EEComponentName();
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resType) {
        boolean valid = false;
        if (RES_TYPE_CUSTOM.equals(resType) || RES_TYPE_EXTERNAL_JNDI.equals(resType) || RES_TYPE_JDBC.equals(resType) || RES_TYPE_MAIL.equals(resType) || RES_TYPE_JMS.equals(resType) || RES_TYPE_PMF.equals(resType) || RES_TYPE_JCP.equals(resType) || RES_TYPE_AOR.equals(resType) || RES_TYPE_CCP.equals(resType) || RES_TYPE_CR.equals(resType) || RES_TYPE_RAC.equals(resType)) {
            valid = true;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_resource_type", resType);
            throw new IllegalArgumentException(msg);
        }
        this.resourceType = resType;
    }

    private void setActionForAdd() {
        if (this.resourceExists) {
            String currentAction = this.getAction();
            if ("undeploy".equals(currentAction)) {
                this.setAction("redeploy");
            }
        } else if (this.noOp) {
            this.setAction("deploy");
            this.noOp = false;
        }
    }

    private void setActionForUpdate() {
    }

    private void setActionForDelete() {
        if (this.resourceExists) {
            String currentAction = this.getAction();
            if (!"undeploy".equals(currentAction)) {
                this.setAction("undeploy");
            }
        } else if (!this.noOp) {
            this.noOp = true;
        }
    }

    void setNewAction(String newAction) {
        if ("deploy".equals(newAction)) {
            this.setActionForAdd();
        } else if ("redeploy".equals(newAction)) {
            this.setActionForUpdate();
        } else if ("undeploy".equals(newAction)) {
            this.setActionForDelete();
        } else {
            String msg = localStrings.getString("admin.event.illegal_new_action", newAction);
            throw new IllegalArgumentException(msg);
        }
    }

    boolean isNoOp() {
        return this.noOp;
    }

    public String toString() {
        return "ResourceDeployEvent -- " + this.getAction() + " " + this.resourceType + "/" + this.getJ2EEComponentName();
    }

    public Object clone() throws CloneNotSupportedException {
        ResourceDeployEvent re = (ResourceDeployEvent)super.clone();
        return re;
    }
}

