/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.util.i18n.StringManager;

public class UserMgmtEvent
extends AdminEvent {
    public static final int ACTION_USERADD = 1;
    public static final int ACTION_USERUPDATE = 2;
    public static final int ACTION_USERREMOVE = 3;
    static final String eventType = UserMgmtEvent.class.getName();
    private int actionType;
    private String realmName;
    private String userName;
    private String[] groupList;
    private static StringManager localStrings = StringManager.getManager(UserMgmtEvent.class);

    public UserMgmtEvent(String instance, String realm, int action, String user, String[] groups) {
        this(eventType, instance, realm, action, user, groups);
    }

    public UserMgmtEvent(String type, String instance, String realm, int action, String user, String[] groups) {
        super(type, instance);
        this.realmName = realm;
        this.userName = user;
        this.groupList = groups;
        this.setAction(action);
    }

    public String getAuthRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String[] getGroupList() {
        return this.groupList;
    }

    public int getActionType() {
        return this.actionType;
    }

    private void setAction(int action) {
        boolean valid = false;
        if (action == 1 || action == 2 || action == 3) {
            valid = true;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_action", "" + action);
            throw new IllegalArgumentException(msg);
        }
        this.actionType = action;
    }
}

