/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.UserMgmtEvent;
import com.sun.enterprise.admin.mbeanapi.IAuthRealmMBean;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.management.modelmbean.ModelMBeanInfo;

public class AuthRealmMBean
extends BaseConfigMBean
implements IAuthRealmMBean {
    static final String FILE_NAME_PROPERTY = "file";
    private static final StringManager localStrings = StringManager.getManager(AuthRealmMBean.class);

    public String[] getUserNames() throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getUserNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getGroupNames() throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getGroupNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getUserGroupNames(String userName) throws MBeanConfigException {
        if (userName == null) {
            return this.getGroupNames();
        }
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getGroupNames(userName));
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
    }

    public void addUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.addUser(userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (IASSecurityException ise) {
            throw new MBeanConfigException(ise.getMessage());
        }
        this.EmitUserMgmtEvent(1, userName, groupList);
    }

    public void removeUser(String userName) throws MBeanConfigException {
        this.checkFileTypeRealm();
        if (this.isLastAdminUser(userName)) {
            String msg = localStrings.getString("authRealmMBean.removeLastAdminUser", "asadmin");
            throw new MBeanConfigException(msg);
        }
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.removeUser(userName);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
        this.EmitUserMgmtEvent(3, userName, null);
    }

    public void updateUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        this.checkFileTypeRealm();
        if (!this.isBelogsTo(groupList, (Object)"asadmin") && this.isLastAdminUser(userName)) {
            String msg = localStrings.getString("authRealmMBean.removeLastAdminUser", "asadmin");
            throw new MBeanConfigException(msg);
        }
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.updateUser(userName, userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
        catch (IASSecurityException ise) {
            throw new MBeanConfigException(ise.getMessage());
        }
        this.EmitUserMgmtEvent(2, userName, groupList);
    }

    private String getRealmKeyFileName() {
        return this.getProperty(FILE_NAME_PROPERTY);
    }

    private FileRealm getRealmKeyFile() throws MBeanConfigException {
        try {
            return new FileRealm(this.getRealmKeyFileName());
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    private void saveInstanceRealmKeyFile(FileRealm realm) throws MBeanConfigException {
        try {
            String filePath = this.getRealmKeyFileName();
            _sLogger.log(Level.INFO, "filerealm.write", filePath);
            realm.writeKeyFile(filePath);
        }
        catch (IOException ioe) {
            _sLogger.log(Level.WARNING, "filerealm.writeerror", ioe);
            throw new MBeanConfigException(ioe.getMessage());
        }
    }

    private String[] convertEnumerationToStringArray(Enumeration ee) {
        ArrayList list = new ArrayList();
        while (ee.hasMoreElements()) {
            list.add(ee.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    private void checkFileTypeRealm() throws MBeanConfigException {
        String className = null;
        try {
            className = (String)this.getAttribute("classname");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (className == null || !className.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            String msg = localStrings.getString("authRealmMBean.unsupported_type");
            throw new MBeanConfigException(msg);
        }
    }

    private String getProperty(String name) {
        try {
            String unresolved = (String)this.invoke("getPropertyValue", new Object[]{name}, new String[]{"java.lang.String"});
            String instanceName = MBeanRegistryFactory.getAdminContext().getServerName();
            String resolved = new PropertyResolver(this.getConfigContext(), instanceName).resolve(unresolved);
            return resolved;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void EmitUserMgmtEvent(int action, String user, String[] groups) throws MBeanConfigException {
        try {
            AdminContext adminContext = MBeanRegistryFactory.getAdminContext();
            String instanceName = adminContext.getServerName();
            String name = (String)this.getAttribute("name");
            UserMgmtEvent event = new UserMgmtEvent(instanceName, name, action, user, groups);
            event.setTargetDestination(this.getParentConfigName());
            EventContext.addEvent(event);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    private boolean isSystemAdminRealm() throws MBeanConfigException {
        try {
            Server das = ServerHelper.getDAS(this.getConfigContext());
            String dasConfigName = das.getConfigRef();
            if (!this.getParentConfigName().equals(dasConfigName)) {
                return false;
            }
            JmxConnector jmxc = ServerHelper.getServerSystemConnector(this.getConfigContext(), das.getName());
            return jmxc.getAuthRealmName().equals(this.getName());
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    private String getParentConfigName() throws Exception {
        return MBeanHelper.getLocation((ModelMBeanInfo)((Object)this.getMBeanInfo()))[1];
    }

    private String getName() throws Exception {
        return (String)this.getAttribute("name");
    }

    private boolean isBelogsTo(Enumeration ee, Object objectToCheck) {
        while (ee.hasMoreElements()) {
            if (!ee.nextElement().equals(objectToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean isBelogsTo(Object[] arr, Object objectToCheck) {
        for (int i = 0; i < arr.length; ++i) {
            if (!objectToCheck.equals(arr[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUserLastInGroup(String userName, String groupName) throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            if (!this.isBelogsTo(realm.getGroupNames(userName), (Object)groupName)) {
                return false;
            }
            Enumeration users = realm.getUserNames();
            while (users.hasMoreElements()) {
                String user = (String)users.nextElement();
                if (userName.equals(user) || !this.isBelogsTo(realm.getGroupNames(user), (Object)groupName)) continue;
                return false;
            }
        }
        catch (Exception nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
        return true;
    }

    private boolean isLastAdminUser(String userName) throws MBeanConfigException {
        return this.isSystemAdminRealm() && this.isUserLastInGroup(userName, "asadmin");
    }
}

