/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta.naming;

import com.sun.enterprise.admin.meta.naming.MBeanNamingDescriptor;
import com.sun.enterprise.admin.meta.naming.MBeanNamingException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNamingInfo {
    String[] m_ids = null;
    MBeanNamingDescriptor m_descr = null;

    public MBeanNamingInfo(MBeanNamingDescriptor descr, String type, String[] params) throws MBeanNamingException {
        this(descr, type, params, true);
    }

    public MBeanNamingInfo(MBeanNamingDescriptor descr, String type, String[] params, boolean bTestParamSize) throws MBeanNamingException {
        this.m_descr = descr;
        if (this.m_descr == null) {
            String msg = "admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_type" + type;
            throw new MBeanNamingException(msg);
        }
        if (bTestParamSize) {
            int parmSize;
            int n = parmSize = params == null ? 0 : params.length;
            if (this.m_descr.getParmListSize() > parmSize) {
                String msg = "admin.server.core.mbean.config.naming.wrong_parameters_array_size" + type;
                throw new MBeanNamingException(msg);
            }
        }
        this.m_ids = new String[this.m_descr.getParmListSize()];
        for (int i = 0; i < this.m_ids.length; ++i) {
            this.m_ids[i] = params[i];
        }
    }

    public MBeanNamingInfo(MBeanNamingDescriptor descr, String dottedName) throws MBeanNamingException, MalformedObjectNameException {
        this.m_descr = descr;
        if (this.m_descr == null) {
            String msg = "admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_dotted_name" + dottedName;
            throw new MBeanNamingException(msg);
        }
        this.m_ids = this.m_descr.extractParmList(dottedName);
    }

    public MBeanNamingInfo(MBeanNamingDescriptor descr, ObjectName objectName) throws MBeanNamingException {
        this.m_descr = descr;
        if (this.m_descr == null) {
            String msg = "admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_object_name" + objectName;
            throw new MBeanNamingException(msg);
        }
        this.m_ids = this.m_descr.extractParmList(objectName);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.m_descr.createObjectName(this.m_ids);
    }

    private String escapeString(String str) {
        if (str == null) {
            return null;
        }
        return str.replace('.', '`').replaceAll("`", "\\\\.");
    }

    private String[] escapeStrings(String[] arr) {
        if (arr == null) {
            return null;
        }
        String[] ret = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = this.escapeString(arr[i]);
        }
        return ret;
    }

    public String[] getDottedNames() throws MalformedObjectNameException {
        return this.m_descr.createDottedNames(this.escapeStrings(this.m_ids));
    }

    public String[] getLocationParams() {
        return this.m_ids;
    }

    public String getXPath() {
        return this.m_descr.createXPath(this.m_ids);
    }

    public String getType() {
        return this.m_descr.getType();
    }

    public int getMode() {
        return this.m_descr.getMode();
    }

    public boolean isModeConfig() {
        int mode = this.m_descr.getMode();
        return (mode & 1) != 0;
    }

    public boolean isModeMonitorable() {
        int mode = this.m_descr.getMode();
        return (mode & 2) != 0;
    }

    public String getServerInstanceName() throws MBeanNamingException {
        if (this.m_ids == null || this.m_ids.length == 0) {
            String msg = "admin.server.core.mbean.config.naming.wrong_parameters_array_size" + this.m_descr.getType();
            throw new MBeanNamingException(msg);
        }
        return this.m_ids[0];
    }
}

