/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.LogEventFilter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class LogEvent
implements Event {
    private static StringManager sm = StringManager.getManager(LogEvent.class);
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static ObjectName objName = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.log_event_description");
    private static String description = null;
    private LogEventFilter notificationFilter = null;

    public LogEvent(LogEventFilter filter, String description) {
        this.notificationFilter = filter;
        if (description != null) {
            LogEvent.description = description;
        } else {
            description = defaultDescription;
        }
    }

    public ObjectName getObjectName() {
        return LogEvent.getLogObjectName();
    }

    public String getType() {
        return "log";
    }

    public NotificationFilter getNotificationFilter() {
        return this.notificationFilter;
    }

    public String getDescription() {
        return description;
    }

    public void destroy() {
    }

    static ObjectName getLogObjectName() {
        if (objName != null) {
            return objName;
        }
        try {
            objName = new ObjectName("amx:j2eeType=X-Logging,name=" + System.getProperty("com.sun.aas.instanceName") + ",X-ServerRootMonitor=" + System.getProperty("com.sun.aas.instanceName"));
            MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
            if (mbeanServer.isRegistered(objName)) {
                return objName;
            }
            _logger.log(Level.WARNING, "smgt.internal_error", new Object[]{sm.getString("selfmgmt_event.log_mbean_is_not_available")});
        }
        catch (MalformedObjectNameException mex) {
            _logger.log(Level.WARNING, "smgt.internal_error", mex);
        }
        return objName;
    }
}

