/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.DynamicReconfigEvent;
import com.sun.enterprise.admin.event.MBeanElementChangeEvent;
import com.sun.enterprise.admin.event.MBeanElementChangeEventListener;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.monitor.GenericMonitorMBean;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.AgentAdapter;
import com.sun.enterprise.admin.server.core.AdminChannelLifecycle;
import com.sun.enterprise.admin.server.core.AdminContextImpl;
import com.sun.enterprise.admin.server.core.CustomMBeanRegistrationHelper;
import com.sun.enterprise.admin.server.core.ManualChangeTracker;
import com.sun.enterprise.admin.server.core.channel.DynamicReconfigEventListenerImpl;
import com.sun.enterprise.admin.server.core.channel.RRStateFactory;
import com.sun.enterprise.admin.server.core.jmx.AppServerMBeanServerFactory;
import com.sun.enterprise.admin.server.core.jmx.SunoneInterceptor;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.autodeploy.AutoDeployController;
import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerFactroyImpl;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.server.logging.LogLevelChangeEventListenerImpl;
import com.sun.enterprise.server.logging.LogMBean;
import com.sun.enterprise.transaction.TransactionsRecoveryEventListenerImpl;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminService {
    public static final String TYPE_DASD = "das-and-server";
    public static final String TYPE_DAS = "das";
    public static final String TYPE_SERVER = "server";
    public static final boolean ENABLE_PERFORMANCE_THREAD = true;
    public static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager localStrings = StringManager.getManager(AdminService.class);
    private static AdminService adminService = null;
    private static final String ADMIN_DOMAIN_NAME_PREFIX = "com.sun.appserv.";
    private static final String DEF_ADMIN_DOMAIN_NAME = "com.sun.appserv.server";
    private static String kTempDirNamePrefix = "s1astemp";
    private static String kGUITempDirName = "gui";
    private static String kTempDirNameSuffix = "" + (System.getProperty("com.sun.aas.instanceRoot") != null ? System.getProperty("com.sun.aas.instanceRoot").hashCode() : 0);
    private static int sMBeanServerID;
    public static final int kDefaultImpl = 0;
    private static final String SS_MBEAN_CLASS = "com.sun.enterprise.admin.mbeans.SystemServicesMBean";
    private String adminServiceType;
    private ServerContext context;
    private AdminContext adminContext;
    private ServerLifecycle adminChannel;
    private String mTempDirPath;
    private String mGUITempDirPath;
    private AutoDeployController autoDeployController;
    public static final String PRIVATE_MBEAN_DOMAIN_NAME = "com.sun.appserv";
    public static final String DAS_DIAGNOSTIC_MBEAN_CLASS_NAME = "com.sun.enterprise.admin.mbeans.DomainDiagnostics";
    private static final String ADMIN_JAVAROOT = "com.sun.aas.javaRoot";
    private static final String PLUGIN_JAVAROOT = "JAVA_HOME";
    private static final String AMX_DAS_LOADER_CLASSNAME = "com.sun.enterprise.management.support.Loader";
    private static final String AMX_NON_DAS_LOADER_CLASSNAME = "com.sun.enterprise.management.support.NonDASLoader";
    public static final String AMX_LOADER_DEFAULT_OBJECTNAME = "amx-support:name=mbean-loader";
    private ObjectName mAMXLoaderObjectName = null;

    private AdminService() {
        sMBeanServerID = 0;
    }

    static AdminService createAdminService(ServerContext sc) {
        Object as;
        System.setProperty("com.sun.aas.admin.logger.name", "javax.enterprise.system.tools.admin");
        String type = TYPE_SERVER;
        if ("admin-server".equals(sc.getInstanceName())) {
            type = TYPE_DAS;
        }
        ConfigContext cc = sc.getConfigContext();
        try {
            as = ServerBeansFactory.getConfigBean(cc).getAdminService();
            if (as != null) {
                type = ((com.sun.enterprise.config.serverbeans.AdminService)as).getType();
            }
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            sLogger.log(Level.WARNING, "core.admin_service_default_config", type);
        }
        as = AdminService.instantiateAdminService(type);
        ((AdminService)as).setContext(sc);
        AdminContext ac = sc.getPluggableFeatureFactory().getAdminContext();
        if (ac instanceof AdminContextImpl) {
            ((AdminContextImpl)ac).setServerContext((ServerContextImpl)sc);
        }
        ((AdminService)as).setAdminContext(ac);
        AdminService.setAdminService((AdminService)as);
        return as;
    }

    private static AdminService instantiateAdminService(String type) {
        AdminService as = null;
        if (!(TYPE_DASD.equals(type) || TYPE_DAS.equals(type) || TYPE_SERVER.equals(type))) {
            throw new RuntimeException(localStrings.getString("admin.server.core.unknown_admin_service_type", type));
        }
        as = new AdminService();
        as.setType(type);
        return as;
    }

    private static void setAdminService(AdminService srv) {
        adminService = srv;
    }

    public static AdminService getAdminService() {
        return adminService;
    }

    void init() throws ServerLifecycleException {
        if (this.isDas()) {
            RRStateFactory.removeStateFile();
        }
        this.adminChannel = new AdminChannelLifecycle();
        this.adminChannel.onInitialization(this.context);
        MBeanServer mbs = null;
        try {
            if (sMBeanServerID != 0) {
                throw new RuntimeException(localStrings.getString("admin.server.core.mbs_init_error"));
            }
            SunoneInterceptor.setAdminContext(this.adminContext);
            mbs = SunoneInterceptor.getMBeanServerInstance();
            MBeanServerFactory.initialize(this, mbs);
            if (this.adminContext != null) {
                this.adminContext.setMBeanServer(mbs);
            }
            sLogger.log(Level.INFO, "core.mbs_init_ok");
            this.initCallFlow();
        }
        catch (Throwable t) {
            sLogger.log(Level.FINEST, t.getMessage(), t);
            if (this.isDas()) {
                sLogger.log(Level.SEVERE, "core.mbs_init_exception", t);
            } else {
                sLogger.log(Level.WARNING, "core.mbs_init_exception", t);
            }
            throw new ServerLifecycleException(t.getMessage());
        }
    }

    private void initCallFlow() {
        try {
            Class<?> cl = Class.forName("com.sun.enterprise.admin.monitor.callflow.AgentImpl");
            Agent agent = (Agent)cl.newInstance();
            Switch.getSwitch().setCallFlowAgent(agent);
        }
        catch (Throwable t) {
            sLogger.log(Level.SEVERE, "core.callflow_agent_init_failed", t);
            Switch.getSwitch().setCallFlowAgent(new AgentAdapter());
        }
    }

    void start() throws ServerLifecycleException {
        ManagementObjectManager mgmtObjManager = Switch.getSwitch().getManagementObjectManager();
        if (this.isDas()) {
            this.startAdminInstance();
            mgmtObjManager.registerJ2EEDomain();
        }
        this.initializeAMXMBeans(this.isDas());
        mgmtObjManager.registerJVM();
        mgmtObjManager.registerJ2EEServer();
        if (this.isDas()) {
            mgmtObjManager.registerDasJ2EEServers();
            mgmtObjManager.registerAllJ2EEClusters();
        }
        if (this.canRunUserApps()) {
            this.startNormalInstance();
        }
        this.initializePerInstanceSystemService();
        this.initializeDottedNames();
        this.registerTransactionsRecoveryEventMBean();
        mgmtObjManager.registerTransactionService();
        WsUtil.start();
        this.createDASDiagnosticMBean();
    }

    void ready() throws ServerLifecycleException {
        if (this.isDas()) {
            this.startAutoDeployService();
        }
        if (this.adminChannel != null) {
            this.adminChannel.onReady(this.context);
        }
        this.initiateCustomMBeanLoading();
        this.registerJVMMonitoringMBeans();
        this.notifyAMXThatAdminServiceIsReady();
    }

    void stop() throws ServerLifecycleException {
        if (this.adminChannel != null) {
            this.adminChannel.onShutdown();
        }
        ManagementObjectManager mgmtObjManager = Switch.getSwitch().getManagementObjectManager();
        if (this.isDas()) {
            ManualChangeTracker.stop();
            this.stopAdminInstance();
        }
        if (this.canRunUserApps()) {
            this.stopAutoDeployService();
            this.stopNormalInstance();
        }
    }

    void destroy() throws ServerLifecycleException {
    }

    public ServerContext getContext() {
        return adminService == null ? null : AdminService.adminService.context;
    }

    void setContext(ServerContext ctx) {
        this.context = ctx;
    }

    public AdminContext getAdminContext() {
        return this.adminContext;
    }

    public String getAdministrativeDomainName() throws ConfigException {
        String serverName = this.adminContext.getServerName();
        ConfigContext ctx = this.adminContext.getAdminConfigContext();
        String aDomainName = ServerHelper.getAdministrativeDomainName(ctx, serverName);
        if (aDomainName == null || "".equals(aDomainName)) {
            return DEF_ADMIN_DOMAIN_NAME;
        }
        return ADMIN_DOMAIN_NAME_PREFIX + aDomainName;
    }

    protected void setAdminContext(AdminContext ctx) {
        this.adminContext = ctx;
    }

    public String getInstanceName() {
        return this.context == null ? null : this.context.getInstanceName();
    }

    public GenericMonitorMBean getRootMonitorMBean() {
        return GenericMonitorMBean.getRoot();
    }

    private void startAdminInstance() throws ServerLifecycleException {
        this.setAdminInstanceProperties();
        this.createTempDir();
    }

    private void stopAdminInstance() throws ServerLifecycleException {
        this.deleteTempDir();
    }

    private void startNormalInstance() throws ServerLifecycleException {
        this.initLogManagerReconfigSupport();
        this.registerTransactionsRecoveryEventListener();
    }

    private void stopNormalInstance() throws ServerLifecycleException {
    }

    public boolean isAdminInstance() {
        return "admin-server".equals(this.context.getInstanceName());
    }

    public boolean isDas() {
        return TYPE_DASD.equals(this.adminServiceType) || TYPE_DAS.equals(this.adminServiceType);
    }

    public boolean canRunUserApps() {
        return !TYPE_DAS.equals(this.adminServiceType);
    }

    public String getType() {
        return this.adminServiceType;
    }

    private void setType(String type) {
        this.adminServiceType = type;
    }

    private void createTimeStampFilesForInstances() {
        String[] instanceIds = ServerManager.instance().getInstanceNames(true);
        for (int i = 0; i < instanceIds.length; ++i) {
            try {
                String instanceId = instanceIds[i];
                InstanceEnvironment ie = new InstanceEnvironment(instanceId);
                ie.createTimeStampFiles();
                sLogger.log(Level.FINE, "core.ts_files_ok", instanceId);
                continue;
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "core.ts_files_failed", e);
            }
        }
    }

    public String getTempDirPath() {
        if (this.mTempDirPath == null) {
            this.createTempDir();
        }
        return this.mTempDirPath;
    }

    public String getGUITempDirPath() {
        if (this.mGUITempDirPath == null) {
            this.createTempDir();
        } else {
            boolean s;
            File gd = new File(this.mGUITempDirPath);
            if (!gd.exists() && !(s = gd.mkdirs())) {
                String msg = localStrings.getString("admin.server.core.gui_dir_failure", this.mGUITempDirPath);
                throw new RuntimeException(msg);
            }
        }
        return this.mGUITempDirPath;
    }

    private void createTempDir() {
        try {
            String domainName = ServerManager.instance().getDomainName();
            String localTmpDir = System.getProperty("java.io.tmpdir");
            String asTempDirName = kTempDirNamePrefix + domainName + this.context.getInstanceName() + kTempDirNameSuffix;
            File tempFolder = new File(localTmpDir, asTempDirName);
            this.mTempDirPath = tempFolder.getCanonicalPath();
            File guiTempFolder = new File(this.mTempDirPath, kGUITempDirName);
            this.mGUITempDirPath = guiTempFolder.getCanonicalPath();
            if (tempFolder.exists()) {
                sLogger.log(Level.FINEST, "core.tmp_folder_exists", this.mTempDirPath);
                return;
            }
            boolean couldCreate = tempFolder.mkdirs();
            if (!couldCreate) {
                sLogger.log(Level.WARNING, "core.tmp_folder_creation_failed", this.mTempDirPath);
            } else {
                sLogger.log(Level.FINEST, "core.tmp_folder_created_ok", this.mTempDirPath);
            }
            couldCreate = guiTempFolder.mkdirs();
            if (!couldCreate) {
                sLogger.log(Level.WARNING, "core.gui_tmp_folder_creation_failed", this.mGUITempDirPath);
            } else {
                sLogger.log(Level.FINEST, "core.gui_tmp_folder_created_ok", this.mGUITempDirPath);
            }
        }
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "core.tmp_folder_creation_failed", t);
        }
    }

    private void deleteTempDir() {
        try {
            FileUtils.whack(new File(this.mTempDirPath));
            sLogger.log(Level.FINEST, "core.tmp_folder_deleted_ok", this.mTempDirPath);
        }
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "core.tmp_folder_deletion_failed", this.mTempDirPath);
        }
    }

    private void setAdminInstanceProperties() {
        try {
            String adminJavaRoot = System.getProperty(ADMIN_JAVAROOT);
            String pluginJavaRoot = System.getProperty(PLUGIN_JAVAROOT);
            if (adminJavaRoot == null) {
                if (pluginJavaRoot != null) {
                    System.setProperty(ADMIN_JAVAROOT, pluginJavaRoot);
                } else {
                    sLogger.log(Level.WARNING, "core.no_java_home");
                }
            }
        }
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "core.set_admin_property_failed");
            sLogger.log(Level.FINE, "general.unexpected_exception", t);
        }
    }

    private void startAutoDeployService() {
        try {
            AutoDeployControllerFactroyImpl controllerFactory = new AutoDeployControllerFactroyImpl();
            this.autoDeployController = controllerFactory.createAutoDeployController(this.context);
            if (this.autoDeployController != null) {
                this.autoDeployController.enableAutoDeploy();
            }
        }
        catch (Throwable tw) {
            sLogger.log(Level.FINE, "general.unexpected_exception", tw);
        }
    }

    private void stopAutoDeployService() {
        try {
            if (this.autoDeployController != null) {
                this.autoDeployController.disableAutoDeploy();
                this.autoDeployController = null;
            }
        }
        catch (Throwable tw) {
            sLogger.log(Level.FINE, "general.unexpected_exception", tw);
        }
    }

    private void initializeDottedNames() {
        try {
            MBeanRegistry mr = MBeanRegistryFactory.getAdminMBeanRegistry();
            mr.generateAndRegisterAllDottedNames(this.context.getConfigContext(), this.context.getDefaultDomainName());
        }
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "admin.dotted_names_init_exception", t);
        }
    }

    private void registerTransactionsRecoveryEventListener() {
        try {
            AdminEventListenerRegistry.addEventListener(TransactionsRecoveryEvent.eventType, new TransactionsRecoveryEventListenerImpl());
        }
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "admin.transactions_recovery_listener_registration_exception", t);
        }
    }

    private void registerTransactionsRecoveryEventMBean() {
        try {
            MBeanRegistryFactory.getAdminMBeanRegistry().instantiateMBean("transactions-recovery", new String[]{this.adminContext.getDomainName()}, null, null, true);
        }
        catch (Throwable t) {
            sLogger.log(Level.FINE, "core.transactions_recovery_mbean_register_error", t);
        }
    }

    private void initLogManagerReconfigSupport() {
        this.registerLogManagerMBean();
        this.registerLogManagerEventListener();
        this.registerDynamicReconfigEventListener();
    }

    private void registerLogManagerMBean() {
        MBeanServer mbs = this.adminContext.getMBeanServer();
        try {
            LogMBean mbean = LogMBean.getInstance();
            mbs.registerMBean(mbean, this.getLogManagerMBeanName());
        }
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "core.logmgr_mbean_not_registered");
            sLogger.log(Level.FINE, "core.logmgr_mbean_register_error", t);
        }
    }

    private ObjectName getLogManagerMBeanName() throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(TYPE_SERVER, this.adminContext.getServerName());
        props.put("category", "runtime");
        props.put("name", "logmanager");
        ObjectName on = new ObjectName(this.adminContext.getDomainName(), props);
        return on;
    }

    private void registerLogManagerEventListener() {
        AdminEventListenerRegistry.addLogLevelChangeEventListener(new LogLevelChangeEventListenerImpl());
    }

    private void registerDynamicReconfigEventListener() {
        AdminEventListenerRegistry.addEventListener(DynamicReconfigEvent.eventType, new DynamicReconfigEventListenerImpl());
    }

    private void initializePerInstanceSystemService() throws ServerLifecycleException {
        ObjectName on = null;
        try {
            MBeanServer mbs = this.getMBeanServer();
            on = ObjectNames.getPerInstanceSystemServicesObjectName(this.getInstanceName());
            Object impl = Class.forName(SS_MBEAN_CLASS).newInstance();
            mbs.registerMBean(impl, on);
            sLogger.finer("Admin Message: System Services MBean Registered with on: " + on.toString());
            if (this.isDas()) {
                mbs.registerMBean(impl, new ObjectName("ias:type=system-services"));
                sLogger.finer("Admin Message: System Services MBean Registered with sibling name: " + on.toString());
            }
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    private void initializeAMXMBeans(boolean isDAS) {
        try {
            String loaderClassname = isDAS ? AMX_DAS_LOADER_CLASSNAME : AMX_NON_DAS_LOADER_CLASSNAME;
            Class<?> loaderClass = Class.forName(loaderClassname);
            Object loader = loaderClass.newInstance();
            ObjectName tempObjectName = new ObjectName(AMX_LOADER_DEFAULT_OBJECTNAME);
            this.mAMXLoaderObjectName = this.getMBeanServer().registerMBean(loader, tempObjectName).getObjectName();
            sLogger.log(Level.INFO, "mbean.init_amx_success");
        }
        catch (Exception e) {
            sLogger.log(Level.SEVERE, "mbean.init_amx_failed", e);
            throw new Error(e);
        }
    }

    private MBeanServer getMBeanServer() {
        try {
            return AppServerMBeanServerFactory.getMBeanServerInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyAMXThatAdminServiceIsReady() {
        try {
            this.getMBeanServer().invoke(this.mAMXLoaderObjectName, "adminServiceReady", null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initiateCustomMBeanLoading() throws ServerLifecycleException {
        try {
            MBeanServer mbs = this.adminContext.getMBeanServer();
            ConfigContext cc = this.context.getConfigContext();
            new CustomMBeanRegistrationHelper(mbs, cc).registerMBeans();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServerLifecycleException(e);
        }
        this.initializeMBeanEventListeners();
    }

    private void registerJVMMonitoringMBeans() {
        try {
            ObjectName dummy1 = new ObjectName("foo:bar=bar1");
            ObjectName dummy2 = new ObjectName("foo:bar=bar2");
            if (this.isDas()) {
                Object jvmic = Class.forName("com.sun.enterprise.admin.mbeans.jvm.JVMInformationCollector").newInstance();
                MBeanServerFactory.getMBeanServer().registerMBean(jvmic, dummy1);
            }
            Object jvmi = Class.forName("com.sun.enterprise.admin.mbeans.jvm.JVMInformation").newInstance();
            MBeanServerFactory.getMBeanServer().registerMBean(jvmi, dummy2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createDASDiagnosticMBean() {
        try {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName on = new ObjectName("com.sun.appserv:type=DomainDiagnostics,name=" + this.getInstanceName() + ",category=monitor");
            Class<?> cl = Class.forName(DAS_DIAGNOSTIC_MBEAN_CLASS_NAME);
            mbs.registerMBean(cl.newInstance(), on);
        }
        catch (Throwable t) {
            t.printStackTrace();
            sLogger.log(Level.INFO, "core.das_diag__mbean_not_registered", t.getMessage());
        }
    }

    private void initializeMBeanEventListeners() {
        try {
            Class<?> c = null;
            c = this.isDas() ? Class.forName("com.sun.enterprise.admin.mbeans.custom.InProcessMBeanElementChangeEventListenerImpl") : Class.forName("com.sun.enterprise.ee.admin.mbeans.RemoteMBeanElementChangeEventListenerImpl");
            Object o = c.newInstance();
            AdminEventListenerRegistry.addEventListener(MBeanElementChangeEvent.EVENT_TYPE, (MBeanElementChangeEventListener)o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

