/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.enterprise.admin.server.core.jmx.InitException;
import com.sun.enterprise.admin.server.core.jmx.SunoneInterceptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

public class AppServerMBeanServerBuilder
extends MBeanServerBuilder {
    private static final MBeanServerBuilder defaultBuilder = new MBeanServerBuilder();
    protected static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static boolean createAppServerMBeanServer = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        Class<AppServerMBeanServerBuilder> clazz = AppServerMBeanServerBuilder.class;
        synchronized (AppServerMBeanServerBuilder.class) {
            if (!createAppServerMBeanServer) {
                _logger.log(Level.FINE, "Creating default JMX MBeanServer in AppServerMBeanServerBuilder");
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return defaultBuilder.newMBeanServer(defaultDomain, outer, delegate);
            }
            _logger.log(Level.FINEST, "Creating MBeanServer with appserver interceptors in AppServerMBeanServerBuilder");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.newAppServerMBeanServer(defaultDomain, delegate);
        }
    }

    protected MBeanServer newAppServerMBeanServer(String defaultDomain, MBeanServerDelegate delegate) {
        try {
            SunoneInterceptor appserverMBS = new SunoneInterceptor();
            MBeanServer newAppserverMBS = this.addInterceptor(appserverMBS);
            MBeanServer jmxMBS = defaultBuilder.newMBeanServer(defaultDomain, newAppserverMBS, delegate);
            appserverMBS.setJmxMBeanServer(jmxMBS);
            _logger.log(Level.FINEST, "Created MBeanServer in AppServerMBeanServerBuilder");
            return newAppserverMBS;
        }
        catch (InitException e) {
            _logger.log(Level.FINE, "InitException while creating MBeanServer", e);
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    protected MBeanServer addInterceptor(MBeanServer mbs) {
        _logger.log(Level.FINEST, "No additional interceptors added inaddInterceptor() in AppServerMBeanServerBuilder");
        return mbs;
    }

    public MBeanServerDelegate newMBeanServerDelegate() {
        return defaultBuilder.newMBeanServerDelegate();
    }

    static void enableAppServerMBeanServer(boolean flag) {
        createAppServerMBeanServer = flag;
    }

    protected static boolean createAppServerMBeanServer() {
        return createAppServerMBeanServer;
    }

    protected static MBeanServerBuilder getDefaultBuilder() {
        return defaultBuilder;
    }
}

