/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.servlet;

import com.sun.enterprise.admin.common.AdminRequest;
import com.sun.enterprise.admin.common.AdminRequestConfigurator;
import com.sun.enterprise.admin.common.AdminResponse;
import com.sun.enterprise.admin.common.AdminResponseConfigurator;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.AFRuntimeException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminAPIEntryServlet
extends HttpServlet {
    private static StringManager localStrings = StringManager.getManager(AdminAPIEntryServlet.class);
    private MBeanServer mMBeanServer = null;
    private Logger mLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private final int SUPPORTED_CLIENT_MAJOR_VERSION = 2;
    private final int SUPPORTED_CLIENT_MINOR_VERSION = 0;

    public void init() throws ServletException {
        super.init();
        this.mMBeanServer = MBeanServerFactory.getMBeanServer();
        this.mLogger.log(Level.FINE, "comm.init_ok");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object resultObject = "TEST";
        try {
            this.mLogger.log(Level.FINE, "comm.recd_request");
            ObjectInputStream inpStream = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
            Object obj = inpStream.readObject();
            AdminRequest adminRequest = (AdminRequest)obj;
            resultObject = this.clientVersionCheck(adminRequest);
            if (resultObject == null) {
                resultObject = this.callMBean(adminRequest);
            }
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
            response.setHeader("Content-type", "application/octet-stream");
            int contentLength = this.getContentLength((Serializable)resultObject);
            response.setContentLength(contentLength);
            response.setStatus(200);
            oos.writeObject(resultObject);
            oos.flush();
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    private AdminResponse clientVersionCheck(AdminRequest req) {
        AdminRequestConfigurator requestConfig = new AdminRequestConfigurator(req);
        String clientVersion = null;
        try {
            clientVersion = requestConfig.getClientVersion();
            int dotIdx = clientVersion.indexOf(46);
            int majorVersion = Integer.valueOf(clientVersion.substring(0, dotIdx));
            int minorVersion = Integer.valueOf(clientVersion.substring(dotIdx + 1));
            if (majorVersion == 2 && minorVersion <= 0) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AdminResponse response = new AdminResponse();
        AdminResponseConfigurator config = new AdminResponseConfigurator(response);
        String msg = clientVersion == null ? localStrings.getString("admin.server.core.servlet.no_client_version") : localStrings.getString("admin.server.core.servlet.nonsupported_client_version", clientVersion);
        config.setException(new AFRuntimeException(msg));
        return response;
    }

    private synchronized AdminResponse callMBean(AdminRequest req) {
        String type = req.getRequestType();
        AdminResponse response = null;
        if (type.equals("invoke")) {
            response = this.callInvoke(req);
        } else if (type.equals("getAttribute")) {
            response = this.callGetAttribute(req);
        } else if (type.equals("setAttribute")) {
            response = this.callSetAttribute(req);
        } else if (type.equals("getAttributes")) {
            response = this.callGetAttributes(req);
        } else if (type.equals("setAttributes")) {
            response = this.callSetAttributes(req);
        } else {
            response = new AdminResponse();
            AdminResponseConfigurator config = new AdminResponseConfigurator(response);
            config.setException(new Exception("No Such Type"));
        }
        return response;
    }

    private synchronized AdminResponse callInvoke(AdminRequest req) {
        Object invokeResult = null;
        AdminResponse response = new AdminResponse();
        AdminResponseConfigurator responseConfig = new AdminResponseConfigurator(response);
        AdminRequestConfigurator requestConfig = new AdminRequestConfigurator(req);
        ObjectName objName = requestConfig.getObjectName();
        String oprName = requestConfig.getOperationName();
        Object[] params = requestConfig.getOperationParams();
        String[] signature = requestConfig.getOperationSignature();
        try {
            invokeResult = this.mMBeanServer.invoke(objName, oprName, params, signature);
            responseConfig.setReturnValue((Serializable)invokeResult);
            this.mLogger.log(Level.FINE, "comm.remote_invoke_ok", objName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "comm.remote_invoke_failed", this.unwrapMBeanException(e));
            responseConfig.setException(e);
        }
        return response;
    }

    private synchronized AdminResponse callGetAttribute(AdminRequest req) {
        Object invokeResult = null;
        AdminResponse response = new AdminResponse();
        AdminResponseConfigurator responseConfig = new AdminResponseConfigurator(response);
        AdminRequestConfigurator requestConfig = new AdminRequestConfigurator(req);
        ObjectName objName = requestConfig.getObjectName();
        String attrName = requestConfig.getAttributeName();
        try {
            invokeResult = this.mMBeanServer.getAttribute(objName, attrName);
            responseConfig.setReturnValue((Serializable)invokeResult);
            this.mLogger.log(Level.FINE, "comm.get_attr_ok", objName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "comm.get_attr_failed", this.unwrapMBeanException(e));
            responseConfig.setException(e);
        }
        return response;
    }

    private synchronized AdminResponse callSetAttribute(AdminRequest req) {
        Object invokeResult = null;
        AdminResponse response = new AdminResponse();
        AdminResponseConfigurator responseConfig = new AdminResponseConfigurator(response);
        AdminRequestConfigurator requestConfig = new AdminRequestConfigurator(req);
        ObjectName objName = requestConfig.getObjectName();
        Attribute attribute = requestConfig.getAttribute();
        try {
            this.mMBeanServer.setAttribute(objName, attribute);
            String setValue = "value set: " + attribute.getValue();
            responseConfig.setReturnValue((Serializable)((Object)setValue));
            this.mLogger.log(Level.FINE, "comm.set_attr_ok", objName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "comm.set_attr_failed", this.unwrapMBeanException(e));
            responseConfig.setException(e);
        }
        return response;
    }

    private synchronized AdminResponse callGetAttributes(AdminRequest req) {
        Object invokeResult = null;
        AdminResponse response = new AdminResponse();
        AdminResponseConfigurator responseConfig = new AdminResponseConfigurator(response);
        AdminRequestConfigurator requestConfig = new AdminRequestConfigurator(req);
        ObjectName mbeanName = requestConfig.getObjectName();
        String[] attributes = requestConfig.getAttributeNames();
        try {
            AttributeList values = this.mMBeanServer.getAttributes(mbeanName, attributes);
            responseConfig.setReturnValue(values);
            this.mLogger.log(Level.FINE, "comm.get_attrs_ok", mbeanName);
        }
        catch (Exception t) {
            this.mLogger.log(Level.WARNING, "comm.get_attrs_failed", this.unwrapMBeanException(t));
            responseConfig.setException(t);
        }
        return response;
    }

    private synchronized AdminResponse callSetAttributes(AdminRequest req) {
        Object invokeResult = null;
        AdminResponse response = new AdminResponse();
        AdminResponseConfigurator responseConfig = new AdminResponseConfigurator(response);
        AdminRequestConfigurator requestConfig = new AdminRequestConfigurator(req);
        ObjectName mbeanName = requestConfig.getObjectName();
        AttributeList attributes = requestConfig.getAttributeList();
        try {
            AttributeList values = this.mMBeanServer.setAttributes(mbeanName, attributes);
            responseConfig.setReturnValue(values);
            this.mLogger.log(Level.FINE, "comm.set_attrs_ok", mbeanName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "comm.set_attrs_failed", this.unwrapMBeanException(e));
            responseConfig.setException(e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getContentLength(Serializable serObject) {
        int size = 0;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(serObject);
            size = baos.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return size;
    }

    private Exception unwrapMBeanException(Exception e) {
        while (e instanceof MBeanException) {
            e = ((MBeanException)e).getTargetException();
        }
        return e;
    }
}

