/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class ConfigBeansFactory {
    public static ConfigBean getConfigBeanByXPath(ConfigContext ctx, String xpath) throws ConfigException {
        ConfigBean cb = ctx.getRootConfigBean();
        if (cb == null) {
            throw new ConfigException("getConfigBeanByXPath: null context");
        }
        cb.setConfigContext(ctx);
        return ConfigBeansFactory.getConfigBeanByXPath(cb, xpath);
    }

    public static String getConfigBeanNameByXPath(String xpath) {
        XpathSupport xp = new XpathSupport(xpath);
        ArrayList arr = xp.getClassNameArray();
        if (arr.size() == 0) {
            return null;
        }
        return (String)arr.get(arr.size() - 1);
    }

    public static ConfigBean getConfigBeanByXPath(ConfigBean server, String xpath) throws ConfigException {
        Object ret = server;
        try {
            XpathSupport xp = new XpathSupport(xpath);
            ArrayList arr = xp.getMethodArray();
            if (arr.size() == 0 || arr.size() == 1) {
                ((ConfigBean)ret).setXPath(xpath);
                return ret;
            }
            for (int i = 1; i < arr.size(); ++i) {
                MethodCaller methodCaller = (MethodCaller)arr.get(i);
                Method m = ret.getClass().getMethod(methodCaller.getMethodName(), methodCaller.getParamClasses());
                ret = m.invoke(ret, methodCaller.getParams());
            }
            ((ConfigBean)ret).setConfigContext(server.getConfigContext());
            ((ConfigBean)ret).setXPath(xpath);
            return ret;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String convertName(String name) {
        StringBuffer n = new StringBuffer();
        boolean up = true;
        boolean keepCase = false;
        if (name.equals("property")) {
            name = "element-property";
        }
        StringCharacterIterator ci = new StringCharacterIterator(name);
        char c = ci.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                keepCase = true;
                break;
            }
            c = ci.next();
        }
        c = ci.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_') {
                up = true;
            } else {
                if (up) {
                    c = Character.toUpperCase(c);
                } else if (!keepCase) {
                    c = Character.toLowerCase(c);
                }
                n.append(c);
                up = false;
            }
            c = ci.next();
        }
        return n.toString();
    }

    private static class MethodCaller {
        private String methodName;
        private Class[] c;
        private Object[] o;

        private MethodCaller() {
        }

        public String toString() {
            return "MethodCaller: " + this.methodName + ",o=" + this.o;
        }

        void setMethodName(String m) {
            this.methodName = m;
        }

        String getMethodName() {
            return this.methodName;
        }

        void setParamClasses(Class[] cl) {
            this.c = cl;
        }

        Class[] getParamClasses() {
            return this.c;
        }

        void setParams(Object[] ob) {
            this.o = ob;
        }

        Object[] getParams() {
            return this.o;
        }
    }

    private static class XpathSupport {
        private String xpath;
        private ArrayList arr = new ArrayList();
        private ArrayList nameArr = new ArrayList();
        private static char SEPARATOR_CHAR = (char)47;
        private static char OPENBRACKET_CHAR = (char)91;
        private static char CLOSEBRACKET_CHAR = (char)93;
        private static char ESCAPE_CHAR = (char)92;

        XpathSupport(String xpath) {
            this.xpath = xpath;
            this.process();
        }

        ArrayList getMethodArray() {
            return this.arr;
        }

        ArrayList getClassNameArray() {
            return this.nameArr;
        }

        private static String[] getListOfNodes(String xpath) {
            ArrayList<String> arr = new ArrayList<String>();
            boolean insideBracket = false;
            StringBuffer sb = new StringBuffer();
            if (xpath == null) {
                return new String[0];
            }
            for (int i = 0; i < xpath.length(); ++i) {
                char ch = xpath.charAt(i);
                if (ch == SEPARATOR_CHAR && !insideBracket) {
                    if (sb.length() <= 0) continue;
                    arr.add(sb.toString());
                    sb = new StringBuffer();
                    continue;
                }
                if (ch == SEPARATOR_CHAR && insideBracket) {
                    sb.append(ch);
                    continue;
                }
                if (ch == OPENBRACKET_CHAR) {
                    sb.append(ch);
                    insideBracket = true;
                    continue;
                }
                if (ch == CLOSEBRACKET_CHAR) {
                    sb.append(ch);
                    insideBracket = false;
                    continue;
                }
                sb.append(ch);
            }
            if (sb.length() > 0) {
                arr.add(sb.toString());
            }
            String[] ret = new String[arr.size()];
            for (int j = 0; j < arr.size(); ++j) {
                ret[j] = (String)arr.get(j);
            }
            return ret;
        }

        private static String getTagName(String node) {
            int n = node.indexOf(91);
            if (n == -1) {
                n = node.length();
            }
            String tag = node.substring(0, n);
            return tag;
        }

        private static String getParamName(String node) {
            int n = node.indexOf(91);
            if (n == -1) {
                return null;
            }
            String p = node.substring(n + 2);
            int eq = p.indexOf("=");
            String ret = p.substring(0, eq);
            return ret;
        }

        private static String getParamValue(String node) {
            int n = node.indexOf(91);
            if (n == -1) {
                return null;
            }
            String p = node.substring(n + 2);
            int eq = p.indexOf("=");
            String ret = p.substring(eq + 2, p.length() - 2);
            return ret;
        }

        void process() {
            String[] n = XpathSupport.getListOfNodes(this.xpath);
            for (int i = 0; i < n.length; ++i) {
                String node = n[i];
                MethodCaller mc = new MethodCaller();
                String tagName = XpathSupport.getTagName(node);
                String methodName = "get" + ConfigBeansFactory.convertName(tagName);
                String paramName = XpathSupport.getParamName(node);
                String paramValue = XpathSupport.getParamValue(node);
                if (paramName != null && !paramName.equals("")) {
                    methodName = methodName + "By" + ConfigBeansFactory.convertName(paramName);
                    mc.setMethodName(methodName);
                    mc.setParamClasses(new Class[]{String.class});
                    mc.setParams(new Object[]{paramValue});
                } else {
                    mc.setMethodName(methodName);
                    mc.setParamClasses(new Class[0]);
                    mc.setParams(new Object[0]);
                }
                this.arr.add(mc);
                this.nameArr.add(ConfigBeansFactory.convertName(tagName));
            }
        }
    }
}

