/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.impl;

import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigChangeFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigRuntimeException;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.impl.DefaultConstants;
import com.sun.enterprise.config.pluggable.ConfigBeanInterceptor;
import com.sun.enterprise.config.pluggable.ConfigEnvironment;
import com.sun.enterprise.config.pluggable.EnvironmentFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigContextImpl
implements ConfigContext,
DefaultConstants,
Serializable,
Cloneable {
    protected transient Vector listeners = null;
    private ConfigBean server;
    protected String xmlUrl;
    private transient long lastModified = 0L;
    private boolean readOnly = false;
    private boolean autoCommit = false;
    private Class rootClass;
    private boolean isAdministered = false;
    private DefaultHandler defaultHandler = null;
    private boolean resolvePath = true;
    private transient ConfigBeanInterceptor configBeanInterceptor = EnvironmentFactory.getEnvironmentFactory().getConfigEnvironment().getConfigBeanInterceptor();
    private transient boolean _lastModifiedCheck = false;
    private transient ArrayList configChangeList = new ArrayList();
    private static final String PRE_CHANGE = "PRE_CHANGE";
    private static final String POST_CHANGE = "POST_CHANGE";

    public ArrayList getConfigChangeList() {
        return this.configChangeList;
    }

    public boolean isAdministered() {
        return this.isAdministered;
    }

    public void setIsAdministered(boolean value) {
        this.isAdministered = value;
    }

    public synchronized void resetConfigChangeList() {
        this.configChangeList = new ArrayList();
        this.clearPersistentConfigChanges();
        this.isAdministered = true;
    }

    public synchronized ConfigChange addToConfigChangeList(String xpath, String attrName, String oldValue, String newValue) {
        if (!this.isAdministered) {
            return null;
        }
        ConfigUpdate cChange = null;
        try {
            if (oldValue == null && newValue == null) {
                return null;
            }
            if (oldValue != null && oldValue.equals(newValue)) {
                return null;
            }
            boolean found = false;
            for (int i = 0; i < this.configChangeList.size(); ++i) {
                if (!((ConfigChange)this.configChangeList.get(i)).getConfigChangeType().equals("update") || !((ConfigUpdate)this.configChangeList.get(i)).getXPath().equals(xpath)) continue;
                ((ConfigUpdate)this.configChangeList.get(i)).addChangedAttribute(attrName, oldValue, newValue);
                this.persistConfigChanges();
                found = true;
                break;
            }
            if (!found) {
                cChange = ConfigChangeFactory.createConfigUpdate(xpath, attrName, oldValue, newValue);
                this.configChangeList.add(cChange);
                this.persistConfigChanges();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return cChange;
    }

    public ConfigContextImpl(String xmlUrl, boolean readOnly, boolean autoCommit, Class rootClass, DefaultHandler dh) {
        this.xmlUrl = xmlUrl;
        this.readOnly = readOnly;
        this.autoCommit = autoCommit;
        this.rootClass = rootClass;
        this.defaultHandler = dh;
    }

    public ConfigContextImpl(String xmlUrl, boolean readOnly, boolean autoCommit, Class rootClass, DefaultHandler dh, boolean resolvePath) {
        this.xmlUrl = xmlUrl;
        this.readOnly = readOnly;
        this.autoCommit = autoCommit;
        this.rootClass = rootClass;
        this.defaultHandler = dh;
        this.resolvePath = resolvePath;
    }

    public ConfigContextImpl(ConfigEnvironment ce) {
        try {
            this.xmlUrl = ce.getUrl();
            this.readOnly = ce.isReadOnly();
            this.autoCommit = ce.isAutoCommitOn();
            this.rootClass = Class.forName(ce.getRootClass());
            this.defaultHandler = (DefaultHandler)Class.forName(ce.getHandler()).newInstance();
            this.configBeanInterceptor = ce.getConfigBeanInterceptor();
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("err_creating_ctx", e);
        }
    }

    public synchronized ConfigBean getRootConfigBean() throws ConfigException {
        if (this.server == null) {
            this.refresh();
        }
        return this.server;
    }

    String getXmlUrl() {
        return this.xmlUrl;
    }

    public ConfigBean exactLookup(String xpath) throws ConfigException {
        if (this.server == null) {
            this.refresh();
        }
        return ConfigBeansFactory.getConfigBeanByXPath(this, xpath);
    }

    public ConfigBean[] lookup(String xpath) throws ConfigException {
        return null;
    }

    private void assertReadOnly() throws ConfigException {
        if (this.readOnly) {
            throw new ConfigException("Read only: you cannot write " + this.toString());
        }
    }

    public synchronized void flush(boolean overwrite) throws ConfigException {
        if (!overwrite && this.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigContext Flush failed: File Changed Externally");
        }
        ConfigContextEvent ccce = new ConfigContextEvent(this, "PRE_FLUSH_CHANGE");
        this.preChange(ccce);
        try {
            FileOutputStream fos = new FileOutputStream(this.xmlUrl);
            this.server.write(fos);
        }
        catch (Exception e) {
            throw new ConfigException("Error Flushing ConfigContext " + this.toString());
        }
        this.initLastModified();
        ccce = new ConfigContextEvent(this, "POST_FLUSH_CHANGE");
        this.postChange(ccce);
    }

    public void flush() throws ConfigException {
        this.flush(true);
    }

    public synchronized void refresh(boolean force) throws ConfigException {
        try {
            if (!force && this.isChanged()) {
                throw new ConfigException("ConfigContext has changed in Memory. cannot refresh " + this.toString());
            }
            FileInputStream in = new FileInputStream(this.xmlUrl);
            this.server = this.defaultHandler != null ? (ConfigBean)BaseBean.createGraph((Class)this.rootClass, (InputStream)in, (boolean)true, (EntityResolver)this.defaultHandler, (ErrorHandler)this.defaultHandler) : (ConfigBean)BaseBean.createGraph((Class)this.rootClass, (InputStream)in, (boolean)true);
            this.initConfigChanges();
            this.initLastModified();
            if (!this.readOnly) {
                this.setXPathInAllBeans();
            }
            this.setIsAdministered(true);
            this.server.setInterceptor(this.configBeanInterceptor);
        }
        catch (Exception e) {
            throw new ConfigException("Error refreshing ConfigContext:" + this.xmlUrl, e);
        }
    }

    public void setXPathInAllBeans() throws ConfigException {
        if (this.readOnly) {
            return;
        }
        ConfigBean cb = this.getRootConfigBean();
        this.setXPathInTree(cb, "");
    }

    private void setXPathInTree(ConfigBean cb, String parentXpath) {
        cb.setConfigContext(this);
        String xp = cb.getAbsoluteXPath(parentXpath);
        cb.setXPath(xp);
        ConfigBean[] chChildArr = cb.getAllChildBeans();
        if (chChildArr == null || chChildArr.length <= 0) {
            return;
        }
        for (int i = 0; i < chChildArr.length; ++i) {
            if (chChildArr[i] == null) continue;
            try {
                this.setXPathInTree(chChildArr[i], cb.getXPath());
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        if (this.server != null) {
            this.cleanup(this.server);
        }
        this.server = null;
    }

    private void cleanup(ConfigBean cb) {
        cb.cleanup();
        ConfigBean[] chChildArr = cb.getAllChildBeans();
        if (chChildArr == null || chChildArr.length <= 0) {
            return;
        }
        for (int i = 0; i < chChildArr.length; ++i) {
            if (chChildArr[i] == null) continue;
            try {
                this.cleanup(chChildArr[i]);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void refresh() throws ConfigException {
        this.refresh(true);
    }

    public Object clone() {
        ConfigContextImpl ctxClone = new ConfigContextImpl(this.xmlUrl, false, false, this.rootClass, this.defaultHandler);
        ctxClone.configBeanInterceptor = this.getConfigBeanInterceptor();
        if (this.server != null) {
            ConfigBean rootClone = (ConfigBean)this.server.clone();
            ctxClone.setRootConfigBean(rootClone);
            rootClone.setConfigContext(ctxClone);
            rootClone.setInterceptor(ctxClone.configBeanInterceptor);
            try {
                ctxClone.setXPathInAllBeans();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctxClone.setIsAdministered(true);
        return ctxClone;
    }

    void setRootConfigBean(ConfigBean c) {
        this.server = c;
    }

    public synchronized ConfigChange addToConfigChangeList(String parentXpath, String childXpath, String name, ConfigBean cb) {
        if (!this.isAdministered) {
            return null;
        }
        ConfigAdd cChange = ConfigChangeFactory.createConfigAdd(parentXpath, childXpath, name, cb);
        this.configChangeList.add(cChange);
        this.persistConfigChanges();
        return cChange;
    }

    public synchronized ConfigChange addToConfigChangeList(String xpath) {
        if (!this.isAdministered) {
            return null;
        }
        ConfigDelete cChange = null;
        if (!this.removeOtherConfigChanges(xpath)) {
            cChange = ConfigChangeFactory.createConfigDelete(xpath);
            this.configChangeList.add(cChange);
        }
        this.persistConfigChanges();
        return cChange;
    }

    private boolean removeOtherConfigChanges(String xpath) {
        boolean ret = false;
        try {
            Iterator it = this.configChangeList.iterator();
            while (it.hasNext()) {
                ConfigChange cc = (ConfigChange)it.next();
                if (xpath.indexOf(cc.getXPath()) < 0) continue;
                if (cc instanceof ConfigAdd) {
                    ret = true;
                }
                it.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public synchronized ConfigChange addToConfigChangeList(String parentXpath, String name, Object cb, Object[] cbArray) {
        if (!this.isAdministered) {
            return null;
        }
        ConfigSet cChange = ConfigChangeFactory.createConfigSet(parentXpath, name, cb, cbArray);
        this.configChangeList.add(cChange);
        this.persistConfigChanges();
        return cChange;
    }

    public synchronized void removeConfigChange(ConfigChange change) {
        if (!this.isAdministered) {
            return;
        }
        int ndx = this.configChangeList.indexOf(change);
        if (ndx != -1) {
            this.configChangeList.remove(ndx);
        }
        this.persistConfigChanges();
    }

    public synchronized void updateFromConfigChange(ConfigChange configChange) throws ConfigException {
        if (configChange == null) {
            return;
        }
        boolean tmpAdministered = this.isAdministered;
        this.isAdministered = false;
        if (configChange.getConfigChangeType().equals("add")) {
            this.updateFromConfigAdd((ConfigAdd)configChange);
        } else if (configChange.getConfigChangeType().equals("update")) {
            this.updateFromConfigUpdate((ConfigUpdate)configChange);
        } else if (configChange.getConfigChangeType().equals("delete")) {
            this.updateFromConfigDelete((ConfigDelete)configChange);
        } else if (configChange.getConfigChangeType().equals("set")) {
            this.updateFromConfigSet((ConfigSet)configChange);
        }
        this.isAdministered = tmpAdministered;
    }

    private void updateFromConfigAdd(ConfigAdd configChange) throws ConfigException {
        ConfigBean parent = ConfigBeansFactory.getConfigBeanByXPath(this, configChange.getParentXPath());
        if (parent == null) {
            throw new ConfigException("updateFromConfigAdd: Cannot find parent");
        }
        ConfigBean rootBean = configChange.getConfigBean();
        if (rootBean == null) {
            throw new ConfigException("updateFromConfigAdd: Cannot find root bean");
        }
        ConfigBean childBean = ConfigBeansFactory.getConfigBeanByXPath(rootBean, configChange.getXPath());
        if (childBean == null) {
            throw new ConfigException("updateFromConfigAdd: Cannot find childBean");
        }
        if (this.isLastModifiedCheckEnabled()) {
            this.validateLastModified(parent, configChange);
        }
        childBean = (ConfigBean)childBean.clone();
        parent.addValue(configChange.getName(), childBean);
    }

    private void updateFromConfigSet(ConfigSet configChange) throws ConfigException {
        ConfigBean parent = ConfigBeansFactory.getConfigBeanByXPath(this, configChange.getParentXPath());
        if (parent == null) {
            throw new ConfigException("updateFromConfigSet: Cannot update. Could not get parent");
        }
        Object child = configChange.getConfigBean();
        if (this.isLastModifiedCheckEnabled()) {
            this.validateLastModified(parent, configChange);
        }
        if (child != null) {
            parent.setValue(configChange.getName(), child);
        } else {
            Object[] childArray = configChange.getConfigBeanArray();
            parent.setValue(configChange.getName(), childArray);
        }
    }

    private void updateFromConfigUpdate(ConfigUpdate configChange) throws ConfigException {
        ConfigBean b = ConfigBeansFactory.getConfigBeanByXPath(this, configChange.getXPath());
        if (b == null) {
            throw new ConfigException("updateFromConfigUpdate:Could not find ConfigBean to update");
        }
        if (this.isLastModifiedCheckEnabled()) {
            this.validateLastModified(b, configChange);
        }
        Set s = configChange.getAttributeSet();
        for (String name : s) {
            b.setAttributeValue(name, configChange.getNewValue(name));
        }
    }

    private void updateFromConfigDelete(ConfigDelete configChange) throws ConfigException {
        String xpath = configChange.getXPath();
        ConfigBean child = ConfigBeansFactory.getConfigBeanByXPath(this, xpath);
        if (child != null) {
            ConfigBean parent = (ConfigBean)child.parent();
            if (this.isLastModifiedCheckEnabled()) {
                this.validateLastModified(parent, configChange);
            }
            parent.removeChild(child);
        }
    }

    public String toString() {
        return "com.sun.enterprise.config.ConfigContext: Url=" + this.xmlUrl + ", ReadOnly=" + this.readOnly + ", ResolvePath=" + this.resolvePath + ", LastModified Timestamp=" + this.lastModified + ", isChanged=" + this.isChanged() + ", Autocommit=" + this.autoCommit + ", isConfigBeanNull=" + (this.server == null);
    }

    public String configBeanToString() {
        if (this.server == null) {
            return "null bean";
        }
        return this.server.dumpBeanNode();
    }

    public String getAttributeValue(String xpath, String attributeName) {
        ConfigBean c = null;
        try {
            c = this.exactLookup(xpath);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c != null) {
            if (!this.isResolvingPaths()) {
                return c.getRawAttributeValue(attributeName);
            }
            return c.getAttributeValue(attributeName);
        }
        return null;
    }

    public boolean getBooleanAttributeValue(String xpath, String attributeName) {
        String ret = this.getAttributeValue(xpath, attributeName);
        if (ret == null) {
            return false;
        }
        return ret.equals("true");
    }

    public boolean isChanged() {
        return this.configChangeList != null && this.configChangeList.size() != 0;
    }

    private long getLastModified() {
        long ts = -1L;
        try {
            File f = new File(this.xmlUrl);
            ts = f.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ts;
    }

    public boolean isFileChangedExternally() {
        return this.getLastModified() != this.lastModified;
    }

    private void initLastModified() {
        this.lastModified = this.getLastModified();
    }

    public boolean equals(Object obj) {
        try {
            if (this.getRootConfigBean().equals(((ConfigContext)obj).getRootConfigBean())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getRootConfigBean().hashCode();
        }
        catch (Throwable throwable) {
            return super.hashCode();
        }
    }

    private String getConfigChangeUrl() {
        return this.xmlUrl + ".changes";
    }

    private void persistConfigChanges() {
    }

    private void initConfigChanges() {
    }

    private void clearPersistentConfigChanges() {
    }

    public void addConfigContextEventListener(ConfigContextEventListener ccel) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(ccel);
    }

    public void removeConfigContextEventListener(ConfigContextEventListener ccel) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.removeElement(ccel);
    }

    public void preChange(ConfigContextEvent ccce) {
        this.change(PRE_CHANGE, ccce);
    }

    public void postChange(ConfigContextEvent ccce) {
        this.change(POST_CHANGE, ccce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(String when, ConfigContextEvent ne) {
        if (this.listeners == null) {
            return;
        }
        String type = ne.getType();
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            ConfigContextEventListener nl = (ConfigContextEventListener)e.nextElement();
            if (when.equals(PRE_CHANGE)) {
                nl.preChangeNotification(ne);
                continue;
            }
            nl.postChangeNotification(ne);
        }
    }

    public boolean isResolvingPaths() {
        return this.resolvePath;
    }

    public synchronized boolean enableLastModifiedCheck(boolean value) {
        boolean prev = this._lastModifiedCheck;
        this._lastModifiedCheck = value;
        return prev;
    }

    public boolean isLastModifiedCheckEnabled() {
        return this._lastModifiedCheck;
    }

    private void validateLastModified(ConfigBean cb, ConfigChange cc) throws StaleWriteConfigException {
        if (cb == null || cc == null) {
            return;
        }
        long beanLM = cb.getThisLastModified();
        if (beanLM == -1L) {
            return;
        }
        long ccLM = cc.getGlobalLastModified();
        if (ccLM == -1L) {
            return;
        }
        if (beanLM == ccLM) {
            return;
        }
        throw new StaleWriteConfigException("validateLastModified failed for cb=" + cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList updateFromConfigChange(ArrayList configChangeList) throws ConfigException {
        ArrayList<ConfigChange> errList = new ArrayList<ConfigChange>();
        if (configChangeList == null || configChangeList.size() == 0) {
            return errList;
        }
        this.validateAllLastModified(configChangeList);
        boolean prev = this.enableLastModifiedCheck(false);
        try {
            for (int i = 0; i < configChangeList.size(); ++i) {
                ConfigChange cc = (ConfigChange)configChangeList.get(i);
                try {
                    this.updateFromConfigChange(cc);
                    continue;
                }
                catch (Exception e) {
                    errList.add(cc);
                }
            }
        }
        finally {
            this.enableLastModifiedCheck(prev);
        }
        return errList;
    }

    private void validateAllLastModified(ArrayList arr) throws StaleWriteConfigException {
        if (arr == null || arr.size() == 0) {
            return;
        }
        for (int i = 0; i < arr.size(); ++i) {
            ConfigChange cc = (ConfigChange)arr.get(i);
            this.validateLastModified(cc);
        }
    }

    private void validateLastModified(ConfigChange cc) throws StaleWriteConfigException {
        ConfigBean bean = this.getConfigBeanFromConfigChange(cc);
        this.validateLastModified(bean, cc);
    }

    private ConfigBean getConfigBeanFromConfigChange(ConfigChange configChange) {
        ConfigBean result = null;
        try {
            if (configChange.getConfigChangeType().equals("update")) {
                result = ConfigBeansFactory.getConfigBeanByXPath(this, configChange.getXPath());
            } else if (configChange.getConfigChangeType().equals("delete")) {
                String xpath = configChange.getXPath();
                ConfigBean child = ConfigBeansFactory.getConfigBeanByXPath(this, xpath);
                if (child != null) {
                    result = (ConfigBean)child.parent();
                }
            } else {
                result = ConfigBeansFactory.getConfigBeanByXPath(this, configChange.getParentXPath());
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return result;
    }

    public String getUrl() {
        return this.xmlUrl;
    }

    public ConfigBeanInterceptor getConfigBeanInterceptor() {
        ConfigBeanInterceptor cbiClone = null;
        if (null != this.configBeanInterceptor) {
            cbiClone = (ConfigBeanInterceptor)this.configBeanInterceptor.clone();
        }
        return cbiClone;
    }
}

