/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import java.io.Serializable;

public class ConnectorConnectionPool
extends J2EEResourceBase
implements Serializable {
    protected ConnectorDescriptorInfo connectorDescriptorInfo_;
    protected String steadyPoolSize_;
    protected String maxPoolSize_;
    protected String maxWaitTimeInMillis_;
    protected String poolResizeQuantity_;
    protected String idleTimeoutInSeconds_;
    protected boolean failAllConnections_;
    protected boolean matchConnections_ = false;
    protected int transactionSupport_;
    protected boolean isConnectionValidationRequired_ = false;
    private boolean lazyConnectionAssoc_ = false;
    private boolean lazyConnectionEnlist_ = false;
    private boolean associateWithThread_ = false;
    private boolean nonTransactional_ = false;
    private boolean nonComponent_ = false;
    private boolean connectionLeakTracing_ = false;
    private ConnectorSecurityMap[] securityMaps = null;
    private boolean isAuthCredentialsDefinedInPool_ = false;
    private boolean validateAtmostEveryIdleSecs = false;

    public ConnectorConnectionPool(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        ConnectorConnectionPool clone = new ConnectorConnectionPool(name);
        ConnectorDescriptorInfo cdi = this.connectorDescriptorInfo_.doClone();
        clone.setSecurityMaps(this.securityMaps);
        clone.setSteadyPoolSize(this.getSteadyPoolSize());
        clone.setMaxPoolSize(this.getMaxPoolSize());
        clone.setMaxWaitTimeInMillis(this.getMaxWaitTimeInMillis());
        clone.setPoolResizeQuantity(this.getPoolResizeQuantity());
        clone.setIdleTimeoutInSeconds(this.getIdleTimeoutInSeconds());
        clone.setFailAllConnections(this.isFailAllConnections());
        clone.setMatchConnections(this.matchConnections());
        clone.setTransactionSupport(this.getTransactionSupport());
        clone.setConnectorDescriptorInfo(cdi);
        clone.setConnectionValidationRequired(this.isConnectionValidationRequired_);
        clone.setLazyConnectionAssoc(this.isLazyConnectionAssoc());
        clone.setAssociateWithThread(this.isAssociateWithThread());
        clone.setNonComponent(this.isNonComponent());
        clone.setNonTransactional(this.isNonTransactional());
        clone.setConnectionLeakTracing(this.isConnectionLeakTracing());
        return clone;
    }

    public void setAuthCredentialsDefinedInPool(boolean authCred) {
        this.isAuthCredentialsDefinedInPool_ = authCred;
    }

    public boolean getAuthCredentialsDefinedInPool() {
        return this.isAuthCredentialsDefinedInPool_;
    }

    public ConnectorDescriptorInfo getConnectorDescriptorInfo() {
        return this.connectorDescriptorInfo_;
    }

    public void setConnectorDescriptorInfo(ConnectorDescriptorInfo connectorDescriptorInfo) {
        this.connectorDescriptorInfo_ = connectorDescriptorInfo;
    }

    public int getType() {
        return 8;
    }

    public String getSteadyPoolSize() {
        return this.steadyPoolSize_;
    }

    public void setSteadyPoolSize(String steadyPoolSize) {
        this.steadyPoolSize_ = steadyPoolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize;
    }

    public String getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis_;
    }

    public void setMaxWaitTimeInMillis(String maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis_ = maxWaitTimeInMillis;
    }

    public String getPoolResizeQuantity() {
        return this.poolResizeQuantity_;
    }

    public void setPoolResizeQuantity(String poolResizeQuantity) {
        this.poolResizeQuantity_ = poolResizeQuantity;
    }

    public String getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds_;
    }

    public void setIdleTimeoutInSeconds(String idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds_ = idleTimeoutInSeconds;
    }

    public boolean isFailAllConnections() {
        return this.failAllConnections_;
    }

    public void setFailAllConnections(boolean failAllConnections) {
        this.failAllConnections_ = failAllConnections;
    }

    public boolean matchConnections() {
        return this.matchConnections_;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections_ = matchConnections;
    }

    public int getTransactionSupport() {
        return this.transactionSupport_;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport_ = transactionSupport;
    }

    public void setConnectionValidationRequired(boolean validation) {
        this.isConnectionValidationRequired_ = validation;
    }

    public boolean isIsConnectionValidationRequired() {
        return this.isConnectionValidationRequired_;
    }

    public boolean isLazyConnectionAssoc() {
        return this.lazyConnectionAssoc_;
    }

    public void setLazyConnectionAssoc(boolean match) {
        this.lazyConnectionAssoc_ = match;
    }

    public boolean isLazyConnectionEnlist() {
        return this.lazyConnectionEnlist_;
    }

    public void setLazyConnectionEnlist(boolean flag) {
        this.lazyConnectionEnlist_ = flag;
    }

    public boolean isAssociateWithThread() {
        return this.associateWithThread_;
    }

    public void setAssociateWithThread(boolean match) {
        this.associateWithThread_ = match;
    }

    public boolean isNonTransactional() {
        return this.nonTransactional_;
    }

    public void setNonTransactional(boolean match) {
        this.nonTransactional_ = match;
    }

    public boolean isNonComponent() {
        return this.nonComponent_;
    }

    public void setNonComponent(boolean match) {
        this.nonComponent_ = match;
    }

    public boolean isConnectionLeakTracing() {
        return this.connectionLeakTracing_;
    }

    public void setConnectionLeakTracing(boolean match) {
        this.connectionLeakTracing_ = match;
    }

    public void setSecurityMaps(ConnectorSecurityMap[] securityMapArray) {
        this.securityMaps = securityMapArray;
    }

    public ConnectorSecurityMap[] getSecurityMaps() {
        return this.securityMaps;
    }

    public String toString() {
        String returnVal = null;
        StringBuffer sb = new StringBuffer("ConnectorConnectionPool :: ");
        try {
            sb.append(this.getName());
            sb.append("\nsteady size: ");
            sb.append(this.getSteadyPoolSize());
            sb.append("\nmax pool size: ");
            sb.append(this.getMaxPoolSize());
            sb.append("\nmax wait time: ");
            sb.append(this.getMaxWaitTimeInMillis());
            sb.append("\npool resize qty: ");
            sb.append(this.getPoolResizeQuantity());
            sb.append("\nIdle timeout: ");
            sb.append(this.getIdleTimeoutInSeconds());
            sb.append("\nfailAllConnections: ");
            sb.append(this.isFailAllConnections());
            sb.append("\nTransaction Support Level: ");
            sb.append(this.transactionSupport_);
            sb.append("\nmatchConnections_ ");
            sb.append(this.matchConnections_);
            sb.append("\nisConnectionValidationRequired_ ");
            sb.append(this.isConnectionValidationRequired_);
            sb.append("\nassociateWithThread_ ");
            sb.append(this.associateWithThread_);
            sb.append("\nlazyConnectionAssoc_ ");
            sb.append(this.lazyConnectionAssoc_);
            sb.append("\nnonTransactional_ ");
            sb.append(this.nonTransactional_);
            sb.append("\nnonComponent_ ");
            sb.append(this.nonComponent_);
            sb.append("\nconnectionLeakTracing_ ");
            sb.append(this.connectionLeakTracing_);
            sb.append("\nConnectorDescriptorInfo -> ");
            sb.append("\nrarName: ");
            sb.append(this.connectorDescriptorInfo_.getRarName());
            sb.append("\nresource adapter class: ");
            sb.append(this.connectorDescriptorInfo_.getResourceAdapterClassName());
            sb.append("\nconnection def name: ");
            sb.append(this.connectorDescriptorInfo_.getConnectionDefinitionName());
            sb.append("\nMCF Config properties-> ");
            for (EnvironmentProperty ep : this.connectorDescriptorInfo_.getMCFConfigProperties()) {
                sb.append(ep.getName());
                sb.append(":");
                sb.append("password".equalsIgnoreCase(ep.getName()) ? "****" : ep.getValue());
                sb.append("\n");
            }
            if (this.securityMaps != null) {
                sb.append("SecurityMaps -> {");
                for (int i = 0; i < this.securityMaps.length; ++i) {
                    if (this.securityMaps[i] == null || this.securityMaps[i].getName() == null) continue;
                    sb.append(this.securityMaps[i].getName() + " ");
                }
                sb.append("}");
            }
            returnVal = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public boolean isValidateAtmostEveryIdleSecs() {
        return this.validateAtmostEveryIdleSecs;
    }

    public void setValidateAtmostEveryIdleSecs(boolean validateAtmostEveryIdleSecs) {
        this.validateAtmostEveryIdleSecs = validateAtmostEveryIdleSecs;
    }
}

