/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.persistence.EntityManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleDescriptor
extends RootDeploymentDescriptor
implements Roles {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BundleDescriptor.class);
    private static final String DEPLOYMENT_DESCRIPTOR_DIR = "META-INF";
    private static final String WSDL_DIR = "wsdl";
    private static final double ANNOTATION_EJB_VER = 3.0;
    private static final double ANNOTATION_WAR_VER = 2.5;
    private static final double ANNOTATION_CAR_VER = 5.0;
    private final String PERSISTENCE_UNIT_NAME_SEPARATOR = "#";
    private Application application;
    private Set roles;
    private Set messageDestinations = new HashSet();
    private WebServicesDescriptor webServices = new WebServicesDescriptor();
    private boolean fullFlag = false;
    private boolean fullAttribute = false;
    private Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private ModuleDescriptor moduleDescriptor;

    public BundleDescriptor() {
        this.webServices.setBundleDescriptor(this);
    }

    public BundleDescriptor(String name, String description) {
        super(name, description);
        this.webServices.setBundleDescriptor(this);
    }

    public void setApplication(Application a) {
        if (this.application != null) {
            this.removeNotificationListener(this.application);
        }
        this.application = a;
        if (this.application != null) {
            this.addNotificationListener(this.application);
        }
    }

    void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.getRoles().addAll(bundleDescriptor.getRoles());
        this.changed();
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    public Application getApplication() {
        return this.application;
    }

    public void addEntityManagerFactory(String unitName, EntityManagerFactory emf) {
        this.entityManagerFactories.put(unitName, emf);
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        return this.entityManagerFactories.get(unitName);
    }

    public Set<EntityManagerFactory> getEntityManagerFactories() {
        return new HashSet<EntityManagerFactory>(this.entityManagerFactories.values());
    }

    public abstract Set getServiceReferenceDescriptors();

    public WebServicesDescriptor getWebServices() {
        return this.webServices;
    }

    public WebServiceEndpoint getWebServiceEndpointByName(String name) {
        return this.webServices.getEndpointByName(name);
    }

    public boolean hasWebServiceClients() {
        return false;
    }

    public boolean hasWebServices() {
        return this.getWebServices().hasWebServices();
    }

    public Set getMessageDestinations() {
        if (this.messageDestinations == null) {
            this.messageDestinations = new HashSet();
        }
        return this.messageDestinations;
    }

    public boolean hasMessageDestinationByName(String name) {
        for (Descriptor next : this.getMessageDestinations()) {
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationDescriptor getMessageDestinationByName(String name) {
        for (Descriptor next : this.getMessageDestinations()) {
            if (!next.getName().equals(name)) continue;
            return (MessageDestinationDescriptor)next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmessagedestbundle", "Referencing error: this bundle has no message destination of name: {0}", new Object[]{name}));
    }

    public void addMessageDestination(MessageDestinationDescriptor messageDestination) {
        messageDestination.setBundleDescriptor(this);
        this.getMessageDestinations().add(messageDestination);
        super.changed();
    }

    public void removeMessageDestination(MessageDestinationDescriptor msgDest) {
        msgDest.setBundleDescriptor(null);
        this.getMessageDestinations().remove(msgDest);
        super.changed();
    }

    @Override
    public Set getRoles() {
        if (this.roles == null) {
            this.roles = new OrderedSet();
        }
        if (this.application != null) {
            this.roles.addAll(this.application.getAppRoles());
        }
        return this.roles;
    }

    @Override
    public void addRole(Role role) {
        this.getRoles().add(role);
        this.changed();
    }

    public void addRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.addRole(role);
    }

    @Override
    public void removeRole(Role role) {
        this.getRoles().remove(role);
        this.changed();
    }

    protected Collection getNamedDescriptorsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<EnvironmentProperty> namedDescriptors = new Vector<EnvironmentProperty>();
        for (ResourceReferenceDescriptor resourceReference : nameEnvironment.getResourceReferenceDescriptors()) {
            namedDescriptors.add(resourceReference);
        }
        for (EjbReferenceDescriptor ejbReference : nameEnvironment.getEjbReferenceDescriptors()) {
            namedDescriptors.add(ejbReference);
        }
        for (JmsDestinationReferenceDescriptor resourceEnvRef : nameEnvironment.getJmsDestinationReferenceDescriptors()) {
            namedDescriptors.add(resourceEnvRef);
        }
        return namedDescriptors;
    }

    protected Vector getNamedReferencePairsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        for (ResourceReferenceDescriptor resourceReference : nameEnvironment.getResourceReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createResourceRefPair((Descriptor)((Object)nameEnvironment), resourceReference));
        }
        for (EjbReferenceDescriptor ejbReference : nameEnvironment.getEjbReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createEjbRefPair((Descriptor)((Object)nameEnvironment), ejbReference));
        }
        for (JmsDestinationReferenceDescriptor resourceEnvRef : nameEnvironment.getJmsDestinationReferenceDescriptors()) {
            pairs.add(NamedReferencePair.createResourceEnvRefPair((Descriptor)((Object)nameEnvironment), resourceEnvRef));
        }
        return pairs;
    }

    public InjectionInfo getInjectionInfoByClass(String className, JndiNameEnvironment jndiNameEnv) {
        LifecycleCallbackDescriptor postConstructDesc = this.getPostConstructDescriptorByClass(className, jndiNameEnv);
        String postConstructMethodName = postConstructDesc != null ? postConstructDesc.getLifecycleCallbackMethod() : null;
        LifecycleCallbackDescriptor preDestroyDesc = this.getPreDestroyDescriptorByClass(className, jndiNameEnv);
        String preDestroyMethodName = preDestroyDesc != null ? preDestroyDesc.getLifecycleCallbackMethod() : null;
        return new InjectionInfo(className, postConstructMethodName, preDestroyMethodName, this.getInjectableResourcesByClass(className, jndiNameEnv));
    }

    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className, JndiNameEnvironment jndiNameEnv) {
        for (LifecycleCallbackDescriptor next : jndiNameEnv.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className, JndiNameEnvironment jndiNameEnv) {
        for (LifecycleCallbackDescriptor next : jndiNameEnv.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    protected List<InjectionCapable> getInjectableResources(JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        HashSet<EnvironmentProperty> allEnvProps = new HashSet<EnvironmentProperty>();
        for (EnvironmentProperty environmentProperty : jndiNameEnv.getEnvironmentProperties()) {
            if (!environmentProperty.hasAValue()) continue;
            allEnvProps.add(environmentProperty);
        }
        allEnvProps.addAll(jndiNameEnv.getEjbReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getServiceReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getResourceReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getJmsDestinationReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getMessageDestinationReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getEntityManagerFactoryReferenceDescriptors());
        allEnvProps.addAll(jndiNameEnv.getEntityManagerReferenceDescriptors());
        for (InjectionCapable injectionCapable : allEnvProps) {
            if (!injectionCapable.isInjectable()) continue;
            injectables.add(injectionCapable);
        }
        return injectables;
    }

    protected List<InjectionCapable> getInjectableResourcesByClass(String className, JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        for (InjectionCapable next : this.getInjectableResources(jndiNameEnv)) {
            if (!next.isInjectable()) continue;
            for (InjectionTarget target : next.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectables.add(next);
            }
        }
        return injectables;
    }

    public ModuleDescriptor getModuleDescriptor() {
        if (this.moduleDescriptor == null) {
            this.moduleDescriptor = new ModuleDescriptor();
            this.moduleDescriptor.setModuleType(this.getModuleType());
            this.moduleDescriptor.setDescriptor(this);
        }
        return this.moduleDescriptor;
    }

    public void setModuleDescriptor(ModuleDescriptor descriptor) {
        this.moduleDescriptor = descriptor;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.application != null) {
            return this.application.getClassLoader();
        }
        throw new RuntimeException("No class loader associated with this module " + this.getName());
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n Roles[] = ").append(this.roles);
        if (this.getWebServices().hasWebServices()) {
            toStringBuffer.append("\n WebServices ");
            ((Descriptor)this.getWebServices()).print(toStringBuffer);
        }
    }

    @Override
    public abstract ModuleType getModuleType();

    @Override
    public String getModuleID() {
        if (this.moduleID == null) {
            this.moduleID = this.getModuleDescriptor().getArchiveUri();
        }
        if (this.getModuleDescriptor().isStandalone()) {
            return this.moduleID;
        }
        if (this.application != null) {
            if (this.application.getModuleID() == null) {
                return this.getDisplayName();
            }
            return this.application.getModuleID() + "#" + this.moduleID;
        }
        return this.moduleID;
    }

    public String getDeploymentDescriptorDir() {
        return DEPLOYMENT_DESCRIPTOR_DIR;
    }

    public String getWsdlDir() {
        return this.getDeploymentDescriptorDir() + "/" + WSDL_DIR;
    }

    public void setFullFlag(boolean flag) {
        this.fullFlag = flag;
    }

    public void setFullAttribute(String value) {
        this.fullAttribute = Boolean.valueOf(value);
    }

    public boolean isFullAttribute() {
        return this.fullAttribute;
    }

    public boolean isFullFlag() {
        if (this.fullAttribute || this.fullFlag) {
            return true;
        }
        return this.isDDWithNoAnnotationAllowed();
    }

    public boolean isDDWithNoAnnotationAllowed() {
        ModuleType mType = this.getModuleType();
        double specVersion = Double.parseDouble(this.getSpecVersion());
        if (mType.equals(ModuleType.RAR)) {
            return true;
        }
        return mType.equals(ModuleType.EJB) && specVersion < 3.0 || mType.equals(ModuleType.WAR) && specVersion < 2.5 || mType.equals(ModuleType.CAR) && specVersion < 5.0;
    }

    public PersistenceUnitDescriptor findReferencedPU(String unitName) {
        if (unitName == null || unitName.length() == 0) {
            return this.findDefaultPU();
        }
        return this.findReferencedPU0(unitName);
    }

    public PersistenceUnitDescriptor findDefaultPU() {
        PersistenceUnitDescriptor pu = null;
        int totalNumberOfPUInClient = 0;
        for (PersistenceUnitsDescriptor nextPUs : this.getPersistenceUnitsDescriptors()) {
            Iterator<PersistenceUnitDescriptor> i$ = nextPUs.getPersistenceUnitDescriptors().iterator();
            while (i$.hasNext()) {
                PersistenceUnitDescriptor nextPU;
                pu = nextPU = i$.next();
                ++totalNumberOfPUInClient;
            }
        }
        if (totalNumberOfPUInClient == 1) {
            return pu;
        }
        if (totalNumberOfPUInClient == 0) {
            int totalNumberOfPUInEar = 0;
            for (PersistenceUnitsDescriptor nextPUs : this.getApplication().getPersistenceUnitsDescriptors()) {
                Iterator<PersistenceUnitDescriptor> i$ = nextPUs.getPersistenceUnitDescriptors().iterator();
                while (i$.hasNext()) {
                    PersistenceUnitDescriptor nextPU;
                    pu = nextPU = i$.next();
                    ++totalNumberOfPUInEar;
                }
            }
            if (totalNumberOfPUInEar == 1) {
                return pu;
            }
        }
        return null;
    }

    private PersistenceUnitDescriptor findReferencedPU0(String unitName) {
        int separatorIndex = unitName.lastIndexOf("#");
        if (separatorIndex != -1) {
            String unqualifiedUnitName = unitName.substring(separatorIndex + 1);
            String path = unitName.substring(0, separatorIndex);
            String puRoot = this.getTargetUri(this, path);
            PersistenceUnitsDescriptor pus = this.getApplication().getPersistenceUnitsDescriptor(puRoot);
            if (pus != null) {
                for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                    if (!pu.getName().equals(unqualifiedUnitName)) continue;
                    return pu;
                }
            }
        } else {
            Map<String, PersistenceUnitDescriptor> visiblePUs = this.getVisiblePUs();
            PersistenceUnitDescriptor result = visiblePUs.get(unitName);
            if (result != null) {
                return result;
            }
            int sameNamedEarScopedPUCount = 0;
            for (String s : visiblePUs.keySet()) {
                int idx = s.lastIndexOf("#");
                if (idx == -1 || !s.substring(idx + 1).matches(unitName)) continue;
                result = visiblePUs.get(s);
                ++sameNamedEarScopedPUCount;
            }
            if (sameNamedEarScopedPUCount == 1) {
                return result;
            }
        }
        return null;
    }

    public Map<String, PersistenceUnitDescriptor> getVisiblePUs() {
        HashMap<String, PersistenceUnitDescriptor> result = new HashMap<String, PersistenceUnitDescriptor>();
        for (PersistenceUnitsDescriptor pus : this.getPersistenceUnitsDescriptors()) {
            for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                result.put(pu.getName(), pu);
            }
        }
        Application application = this.getApplication();
        if (application != null) {
            for (PersistenceUnitsDescriptor pus : application.getPersistenceUnitsDescriptors()) {
                for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                    result.put(pu.getPuRoot() + "#" + pu.getName(), pu);
                }
            }
        }
        return result;
    }

    private String getTargetUri(BundleDescriptor origin, String relativeTargetUri) {
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            return new URI(archiveUri).resolve(relativeTargetUri).getPath();
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public String getUniqueFriendlyId() {
        String uniqueId = this.getApplication().isVirtual() ? this.getApplication().getRegistrationName() : this.getModuleDescriptor().getArchiveUri();
        return FileUtils.makeFriendlyFileName(uniqueId);
    }
}

