/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebService
extends Descriptor {
    private String wsdlFileUri;
    private URL wsdlFileUrl;
    private String mappingFileUri;
    private File mappingFile;
    private HashMap<String, WebServiceEndpoint> endpoints;
    private WebServicesDescriptor webServicesDesc;
    private URL publishUrl;

    public WebService() {
        this("");
    }

    public WebService(WebService other) {
        super(other);
        this.wsdlFileUri = other.wsdlFileUri;
        this.wsdlFileUrl = other.wsdlFileUrl;
        this.mappingFileUri = other.mappingFileUri;
        this.mappingFile = other.mappingFile;
        this.publishUrl = other.publishUrl;
        this.webServicesDesc = other.webServicesDesc;
        if (other.endpoints != null) {
            this.endpoints = new HashMap();
            for (WebServiceEndpoint wsep : other.endpoints.values()) {
                wsep.setWebService(this);
                this.endpoints.put(wsep.getEndpointName(), wsep);
            }
        } else {
            this.endpoints = null;
        }
    }

    public WebService(String name) {
        this.setName(name);
        this.endpoints = new HashMap();
    }

    public void setWebServicesDescriptor(WebServicesDescriptor webServices) {
        this.webServicesDesc = webServices;
    }

    public WebServicesDescriptor getWebServicesDescriptor() {
        return this.webServicesDesc;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.webServicesDesc.getBundleDescriptor();
    }

    public boolean hasWsdlFile() {
        return this.wsdlFileUri != null;
    }

    public void setWsdlFileUri(String uri) {
        this.wsdlFileUri = uri;
        super.changed();
    }

    public String getWsdlFileUri() {
        if (this.wsdlFileUri == null && this.wsdlFileUrl != null) {
            return this.getBundleDescriptor().getWsdlDir() + "/" + new File(this.wsdlFileUrl.getFile()).getName();
        }
        return this.wsdlFileUri;
    }

    public URL getWsdlFileUrl() {
        return this.wsdlFileUrl;
    }

    public void setWsdlFileUrl(URL url) {
        this.wsdlFileUrl = url;
        super.changed();
    }

    public String getGeneratedWsdlFilePath() {
        if (this.hasWsdlFile()) {
            String xmlDir = this.getBundleDescriptor().getApplication().getGeneratedXMLDirectory();
            if (!this.getBundleDescriptor().getModuleDescriptor().isStandalone()) {
                String uri = this.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                xmlDir = xmlDir + File.separator + uri.replaceAll("\\.", "_");
            }
            if (xmlDir == null) {
                return null;
            }
            return xmlDir + File.separator + this.wsdlFileUri;
        }
        return this.getWsdlFileUrl().getPath();
    }

    public boolean hasMappingFile() {
        return this.mappingFileUri != null;
    }

    public void setMappingFileUri(String uri) {
        this.mappingFileUri = uri;
        super.changed();
    }

    public String getMappingFileUri() {
        return this.mappingFileUri;
    }

    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(File file) {
        this.mappingFile = file;
        super.changed();
    }

    public void addEndpoint(WebServiceEndpoint endpoint) {
        endpoint.setWebService(this);
        this.endpoints.put(endpoint.getEndpointName(), endpoint);
        super.changed();
    }

    public void removeEndpointByName(String endpointName) {
        WebServiceEndpoint endpoint = this.endpoints.remove(endpointName);
        endpoint.setWebService(null);
        super.changed();
    }

    public void removeEndpoint(WebServiceEndpoint endpoint) {
        this.removeEndpointByName(endpoint.getEndpointName());
        super.changed();
    }

    public Collection<WebServiceEndpoint> getEndpoints() {
        HashMap<String, WebServiceEndpoint> shallowCopy = new HashMap<String, WebServiceEndpoint>(this.endpoints);
        return shallowCopy.values();
    }

    public boolean hasClientPublishUrl() {
        return this.publishUrl != null;
    }

    public void setClientPublishUrl(URL url) {
        this.publishUrl = url;
        super.changed();
    }

    public URL getClientPublishUrl() {
        return this.publishUrl;
    }

    public boolean hasUrlPublishing() {
        return !this.hasFilePublishing();
    }

    public boolean hasFilePublishing() {
        return this.hasClientPublishUrl() && this.publishUrl.getProtocol().equals("file");
    }

    public WebServiceEndpoint pickEndpointForRelativeImports() {
        WebServiceEndpoint pick = null;
        for (WebServiceEndpoint wse : this.endpoints.values()) {
            if (wse.isSecure()) {
                pick = wse;
                break;
            }
            pick = wse;
        }
        return pick;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n wsdl file : ").append(this.wsdlFileUri);
        toStringBuffer.append("\n mapping file ").append(this.mappingFileUri);
        toStringBuffer.append("\n publish url ").append(this.publishUrl);
        toStringBuffer.append("\n final wsdl ").append(this.wsdlFileUrl);
        toStringBuffer.append("\n endpoints ").append(this.endpoints);
    }
}

