/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.annotation.Scanner;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import com.sun.enterprise.deployment.annotation.impl.JavaEEScanner;
import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModuleScanner
extends JavaEEScanner
implements Scanner {
    protected File archiveFile = null;
    protected ClassLoader classLoader = null;
    protected ClassFile classFile = new ClassFile();
    private boolean processAllClasses = Boolean.getBoolean("com.sun.enterprise.deployment.annotation.processAllClasses");
    private Set<String> entries = new HashSet<String>();

    ModuleScanner() {
    }

    protected void addScanClassName(String className) {
        if (className != null && className.length() != 0) {
            this.entries.add(className);
        }
    }

    protected void addScanJar(File jarFile) throws IOException {
        JarFile jf = new JarFile(jarFile);
        Enumeration<JarEntry> entriesEnum = jf.entries();
        while (entriesEnum.hasMoreElements()) {
            JarEntry je = entriesEnum.nextElement();
            if (!je.getName().endsWith(".class")) continue;
            if (this.processAllClasses) {
                this.addEntry(je);
                continue;
            }
            ReadableByteChannel channel = Channels.newChannel(jf.getInputStream(je));
            if (channel == null || !this.classFile.containsAnnotation(channel, je.getSize())) continue;
            this.addEntry(je);
        }
    }

    private void addEntry(JarEntry je) {
        String className = je.getName().replace('/', '.');
        className = className.substring(0, className.length() - 6);
        this.entries.add(className);
    }

    private void addEntry(File top, File f) {
        String fileName = f.getPath();
        fileName = fileName.substring(top.getPath().length() + 1);
        String className = fileName.replace(File.separatorChar, '.');
        className = className.substring(0, className.length() - 6);
        this.entries.add(className);
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.initScanDirectory(directory, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScanDirectory(File top, File directory) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                if (this.processAllClasses) {
                    this.addEntry(top, file);
                    continue;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    if (!this.classFile.containsAnnotation(fis.getChannel(), file.length())) continue;
                    this.addEntry(top, file);
                    continue;
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            this.initScanDirectory(top, file);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String className : this.entries) {
            if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
                AnnotationUtils.getLogger().fine("Getting " + className);
            }
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationUtils.getLogger().warning("Cannot load " + className + " reason : " + cnfe.getMessage());
            }
        }
        return elements;
    }
}

