/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeployDirectoryScanner;
import com.sun.enterprise.deployment.autodeploy.AutoDeploymentException;
import com.sun.enterprise.deployment.autodeploy.DirectoryScanner;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class AutoDeployer {
    private ObjectName mbeanName = null;
    private MBeanServer mbs = null;
    private Boolean verify = null;
    private Boolean forceDeploy = null;
    private Boolean enabled = null;
    private Boolean jspPreCompilation = null;
    private boolean renameOnSuccess = true;
    private String targetInstance = null;
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    private static StringManager localStrings = StringManager.getManager(AutoDeployer.class);
    private DirectoryScanner directoryScanner = null;
    private boolean cancelDeployment = false;
    protected static final int DEPLOY_SUCCESS = 1;
    protected static final int DEPLOY_FAILURE = 2;
    protected static final int DEPLOY_PENDING = 3;
    private final AbstractArchiveFactory archiveFactory = new ArchiveFactory();
    private AutodeployRetryManager retryManager = new AutodeployRetryManager();

    public AutoDeployer() {
        this.verify = new Boolean(false);
        this.jspPreCompilation = new Boolean(false);
        this.forceDeploy = new Boolean(true);
        this.enabled = new Boolean(true);
    }

    public AutoDeployer(boolean verify, boolean jspPreCompilation) {
        this.verify = new Boolean(verify);
        this.jspPreCompilation = new Boolean(jspPreCompilation);
        this.forceDeploy = new Boolean(true);
        this.enabled = new Boolean(true);
    }

    public void setDirectoryScanner(DirectoryScanner ds) {
        this.directoryScanner = ds;
    }

    public void setTarget(String target) {
        this.targetInstance = target;
        this.mbeanName = this.getMBean(this.targetInstance);
    }

    public void disableRenameOnSuccess() {
        this.renameOnSuccess = false;
    }

    public void enableRenameOnSuccess() {
        this.renameOnSuccess = true;
    }

    public void setVerify(boolean verify) {
        this.verify = new Boolean(verify);
    }

    public void setJspPreCompilation(boolean jspPreCompilation) {
        this.jspPreCompilation = new Boolean(jspPreCompilation);
    }

    public void deployAll(File autoDeployDir, boolean verify, boolean jspPreCompilation) throws AutoDeploymentException {
        this.verify = new Boolean(verify);
        this.jspPreCompilation = new Boolean(jspPreCompilation);
        this.deployAll(autoDeployDir);
    }

    public void deployAll(File autoDeployDir) throws AutoDeploymentException {
        this.deployAll(autoDeployDir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployAll(File autoDeployDir, boolean includeSubDir) throws AutoDeploymentException {
        if (this.directoryScanner == null) {
            this.directoryScanner = new AutoDeployDirectoryScanner();
        }
        if (this.targetInstance == null) {
            this.setTarget(this.getDefaultTarget());
        }
        File[] files = null;
        files = this.directoryScanner.getAllDeployableModules(autoDeployDir, includeSubDir);
        if (files != null) {
            for (int i = 0; i < files.length && !this.cancelDeployment; ++i) {
                Object var8_7;
                boolean okToRecordResult = true;
                try {
                    try {
                        okToRecordResult = this.deploy(files[i], AutoDeployer.getNameFromFilePath(autoDeployDir, files[i])) != 3;
                    }
                    catch (AutoDeploymentException ae) {
                        var8_7 = null;
                        if (!this.renameOnSuccess || !okToRecordResult) continue;
                        this.directoryScanner.deployedEntity(autoDeployDir, files[i]);
                        continue;
                    }
                    var8_7 = null;
                    if (!this.renameOnSuccess || !okToRecordResult) continue;
                    this.directoryScanner.deployedEntity(autoDeployDir, files[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (this.renameOnSuccess && okToRecordResult) {
                        this.directoryScanner.deployedEntity(autoDeployDir, files[i]);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployAll(File autoDeployDir) throws AutoDeploymentException {
        if (this.directoryScanner == null) {
            this.directoryScanner = new AutoDeployDirectoryScanner();
        }
        if (this.mbs == null) {
            this.mbs = this.getMBeanServer();
        }
        if (this.targetInstance == null) {
            this.setTarget(this.getDefaultTarget());
        }
        File[] apps = null;
        apps = this.directoryScanner.getAllFilesForUndeployment(autoDeployDir);
        if (apps != null) {
            for (int i = 0; i < apps.length && !this.cancelDeployment; ++i) {
                Object var6_6;
                try {
                    block10: {
                        try {
                            boolean stat = this.undeployApplication(apps[i], AutoDeployer.getNameFromFilePath(autoDeployDir, apps[i]));
                            if (stat) {
                                this.markUndeployed(apps[i]);
                                break block10;
                            }
                            this.markUndeployFailed(apps[i]);
                        }
                        catch (AutoDeploymentException ae) {
                            this.markUndeployFailed(apps[i]);
                            var6_6 = null;
                            this.directoryScanner.undeployedEntity(autoDeployDir, apps[i]);
                            continue;
                        }
                    }
                    var6_6 = null;
                    this.directoryScanner.undeployedEntity(autoDeployDir, apps[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    this.directoryScanner.undeployedEntity(autoDeployDir, apps[i]);
                    throw throwable;
                }
            }
        }
    }

    private boolean undeployApplication(File applicationFile, String name) throws AutoDeploymentException {
        boolean status = false;
        Properties props = this.getUndeployActionProperties(name);
        String[] signature = new String[]{"java.util.Properties"};
        Object[] params = new Object[]{props};
        sLogger.log(Level.INFO, "Autoundeploying application :" + name);
        status = this.invokeUndeploymentService(applicationFile.getAbsolutePath(), "undeploy", params, signature);
        String msg = localStrings.getString("enterprise.deployment.autodeploy.autoundeploying_application", applicationFile);
        sLogger.log(Level.INFO, msg);
        return status;
    }

    public void setCancel(boolean value) {
        this.cancelDeployment = value;
    }

    public boolean isCancelled() {
        return this.cancelDeployment;
    }

    void init() throws AutoDeploymentException {
        this.getMBeanServer();
        if (this.targetInstance == null) {
            this.setTarget(this.getDefaultTarget());
        }
    }

    protected int deploy(File deployablefile, String name) throws AutoDeploymentException {
        boolean result;
        int status = 2;
        if (this.cancelDeployment) {
            return status;
        }
        String file = deployablefile.getAbsolutePath();
        status = this.retryManager.testFileAsArchive(file);
        if (status != 1) {
            return status;
        }
        if (this.isModuleDeployed(name) && !(result = this.undeployApplication(deployablefile, name))) {
            return 2;
        }
        Properties props = this.getDeployActionProperties(deployablefile, name);
        String[] signature = new String[]{"java.util.Properties"};
        Object[] params = new Object[]{props};
        status = this.invokeDeploymentService(deployablefile, "deploy", params, signature) ? 1 : 2;
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean invokeDeploymentService(File deployablefile, String action, Object[] params, String[] signature) throws AutoDeploymentException {
        String msg;
        boolean status;
        String file;
        block9: {
            block10: {
                file = deployablefile.getAbsolutePath();
                status = false;
                msg = localStrings.getString("enterprise.deployment.autodeploy.selecting_file", deployablefile.getAbsolutePath());
                sLogger.log(Level.INFO, msg);
                try {
                    try {
                        Object result = this.getMBeanServer().invoke(this.getMBeanName(), action, params, signature);
                        status = this.parseResult(result);
                    }
                    catch (Exception e) {
                        while (true) {
                            if (!(e instanceof MBeanException)) {
                                status = false;
                                msg = localStrings.getString("enterprise.deployment.autodeploy.invocation_exception", file);
                                AutoDeploymentException ae = new AutoDeploymentException(msg, e);
                                sLogger.log(Level.INFO, ae.getMessage());
                                throw ae;
                            }
                            e = ((MBeanException)e).getTargetException();
                        }
                    }
                    Object var11_11 = null;
                    if (!status) break block9;
                    if (!this.renameOnSuccess) break block10;
                    this.markDeployed(deployablefile);
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (!status) {
                        this.markDeployFailed(deployablefile);
                        msg = localStrings.getString("enterprise.deployment.autodeploy.autodeploy_failed", file);
                        sLogger.log(Level.INFO, msg);
                        throw throwable;
                    }
                    if (this.renameOnSuccess) {
                        this.markDeployed(deployablefile);
                    }
                    msg = localStrings.getString("enterprise.deployment.autodeploy.successfully_autodeployed", file);
                    sLogger.log(Level.INFO, msg);
                    throw throwable;
                }
            }
            msg = localStrings.getString("enterprise.deployment.autodeploy.successfully_autodeployed", file);
            sLogger.log(Level.INFO, msg);
            return status;
        }
        this.markDeployFailed(deployablefile);
        msg = localStrings.getString("enterprise.deployment.autodeploy.autodeploy_failed", file);
        sLogger.log(Level.INFO, msg);
        return status;
    }

    final ObjectName getMBeanName() throws AutoDeploymentException {
        if (this.mbeanName == null) {
            throw new AutoDeploymentException("Internal Error: mbeanName is null");
        }
        return this.mbeanName;
    }

    final MBeanServer getMBeanServer() throws AutoDeploymentException {
        if (this.mbs == null) {
            this.mbs = MBeanServerFactory.getMBeanServer();
        }
        return this.mbs;
    }

    private ObjectName getMBean(String instanceName) {
        ObjectName mbean = null;
        try {
            mbean = new ObjectName("com.sun.appserv:type=applications,category=config");
        }
        catch (Exception e) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentFailure", new Object[]{e.getMessage()});
        }
        return mbean;
    }

    private boolean isModuleDeployed(String moduleID) {
        if (moduleID == null) {
            return false;
        }
        try {
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Object result = this.getMBeanServer().invoke(this.getMBeanName(), "getModuleType", params, signature);
            return result != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getDefaultVirtualServer(String instanceName) {
        String virtualServer = null;
        try {
            ConfigContext context = this.getConfigContext();
            HttpService service = ServerBeansFactory.getHttpServiceBean(context);
            if (service != null) {
                HttpListener[] hlArray = service.getHttpListener();
                HttpListener ls = null;
                if (hlArray != null && hlArray.length > 0) {
                    ls = hlArray[0];
                    for (int i = 0; i < hlArray.length; ++i) {
                        if (!hlArray[i].isEnabled()) continue;
                        ls = hlArray[i];
                        break;
                    }
                }
                if (ls != null) {
                    virtualServer = ls.getDefaultVirtualServer();
                }
            }
        }
        catch (ConfigException e) {
            String msg = localStrings.getString("enterprise.deployment.autodeploy.unable_to_get_virtualserver");
            sLogger.log(Level.WARNING, msg + e.getMessage());
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.autodeploy.unable_to_get_virtualserver");
            sLogger.log(Level.WARNING, msg + e.getMessage());
        }
        return virtualServer;
    }

    private String getDefaultTarget() throws AutoDeploymentException {
        try {
            ConfigContext confContext = this.getConfigContext();
            Domain domain = (Domain)confContext.getRootConfigBean();
            Servers svrs = domain.getServers();
            Server[] svrArr = svrs.getServer();
            int size = svrArr.length;
            String targetName = null;
            for (int i = 0; i < size; ++i) {
                if (svrArr[i].getName().equals("")) continue;
                targetName = svrArr[i].getName();
                break;
            }
            if (targetName == null) {
                sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentFailure", new Object[]{"Target server not found"});
                throw new AutoDeploymentException("Target Server not found");
            }
            return targetName;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private ConfigContext getConfigContext() throws ConfigException {
        ServerContext serverContext = AdminService.getAdminService().getContext();
        ConfigContext context = serverContext.getConfigContext();
        return context;
    }

    protected boolean parseResult(Object result) {
        if (result != null && result instanceof DeploymentStatus) {
            DeploymentStatus status = (DeploymentStatus)result;
            if (status.getStatus() > 1) {
                return true;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bos);
            DeploymentStatus.parseDeploymentStatus(status, pw);
            byte[] statusBytes = bos.toByteArray();
            String statusString = new String(statusBytes);
            if (status.getStatus() == 1) {
                String msg = localStrings.getString("enterprise.deployment.warning_occured", statusString);
                sLogger.log(Level.WARNING, msg);
                return true;
            }
            if (status.getStatus() == 0) {
                sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentFailure", new Object[]{statusString});
                return false;
            }
        }
        return false;
    }

    static String getNameFromFilePath(File autodeployDir, File filePath) {
        File parent = filePath.getParentFile();
        String moduleName = null;
        while (!parent.getAbsolutePath().equals(autodeployDir.getAbsolutePath())) {
            moduleName = moduleName == null ? parent.getName() : parent.getName() + "_" + moduleName;
            parent = parent.getParentFile();
        }
        int toIndex = (moduleName = moduleName == null ? filePath.getName() : moduleName + "_" + filePath.getName()).lastIndexOf(46);
        if (toIndex > 0) {
            moduleName = moduleName.substring(0, toIndex);
        }
        return moduleName;
    }

    protected void markDeployed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getDeployedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void markDeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getDeployFailedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void markUndeployed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getUndeployedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void markUndeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            this.getUndeployFailedFile(f).createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void deleteAllMarks(File f) {
        try {
            this.getDeployedFile(f).delete();
            this.getDeployFailedFile(f).delete();
            this.getUndeployedFile(f).delete();
            this.getUndeployFailedFile(f).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected File getDeployedFile(File f) {
        String absPath = f.getAbsolutePath();
        File ret = new File(absPath + "_deployed");
        return ret;
    }

    protected File getDeployFailedFile(File f) {
        String absPath = f.getAbsolutePath();
        File ret = new File(absPath + "_deployFailed");
        return ret;
    }

    protected File getUndeployedFile(File f) {
        String absPath = f.getAbsolutePath();
        File ret = new File(absPath + "_undeployed");
        return ret;
    }

    protected File getUndeployFailedFile(File f) {
        String absPath = f.getAbsolutePath();
        File ret = new File(absPath + "_undeployFailed");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean invokeUndeploymentService(String appFile, String action, Object[] params, String[] signature) throws AutoDeploymentException {
        boolean status;
        block8: {
            status = false;
            try {
                try {
                    Object result = this.getMBeanServer().invoke(this.getMBeanName(), action, params, signature);
                    status = this.parseResult(result);
                }
                catch (Exception e) {
                    while (true) {
                        if (!(e instanceof MBeanException)) {
                            status = false;
                            String msg = localStrings.getString("enterprise.deployment.autodeploy.invocation_exception", appFile);
                            AutoDeploymentException ae = new AutoDeploymentException(msg, e);
                            sLogger.log(Level.INFO, ae.getMessage());
                            throw ae;
                        }
                        e = ((MBeanException)e).getTargetException();
                    }
                }
                Object var10_9 = null;
                if (!status) break block8;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (status) {
                    String msg = localStrings.getString("enterprise.deployment.autodeploy.successfully_autoundeployed", appFile);
                    sLogger.log(Level.INFO, msg);
                    throw throwable;
                }
                String msg = localStrings.getString("enterprise.deployment.autodeploy.autoundeploy_failed", appFile);
                sLogger.log(Level.INFO, msg);
                throw throwable;
            }
            String msg = localStrings.getString("enterprise.deployment.autodeploy.successfully_autoundeployed", appFile);
            sLogger.log(Level.INFO, msg);
            return status;
        }
        String msg = localStrings.getString("enterprise.deployment.autodeploy.autoundeploy_failed", appFile);
        sLogger.log(Level.INFO, msg);
        return status;
    }

    protected Properties getDeployActionProperties(File deployablefile, String ID) {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setArchiveName(deployablefile.getAbsolutePath());
        dProps.setName(ID);
        dProps.setEnable(this.enabled);
        dProps.setVirtualServers(this.getDefaultVirtualServer(this.targetInstance));
        dProps.setForce(this.forceDeploy);
        dProps.setVerify(this.verify);
        dProps.setPrecompileJSP(this.jspPreCompilation);
        dProps.setResourceAction("resDeployment");
        dProps.setResourceTargetList("server");
        return dProps;
    }

    protected Properties getUndeployActionProperties(String name) {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setName(name);
        dProps.setResourceAction("resUndeployment");
        dProps.setResourceTargetList("server");
        return dProps;
    }

    class AutodeployRetryManager {
        private final String RETRY_LIMIT_NAME = "com.sun.appserv.autodeploy.retry.limit";
        private final long RETRY_LIMIT_DEFAULT = 30000L;
        private final long RETRY_LIMIT = Long.getLong("com.sun.appserv.autodeploy.retry.limit", 30000L);
        private HashMap invalidFiles = new HashMap();

        AutodeployRetryManager() {
        }

        int testFileAsArchive(String file) throws AutoDeploymentException {
            int result;
            try {
                File inFile = new File(file);
                if (!inFile.isDirectory() && file.endsWith(".class")) {
                    return 1;
                }
                AbstractArchive arch = this.openFileAsArchive(file);
                if (arch != null) {
                    result = 1;
                    arch.close();
                } else {
                    result = 3;
                }
            }
            catch (AutoDeploymentException ade) {
                result = 2;
            }
            catch (IOException ioe) {
                String msg = localStrings.getString("enterprise.deployment.autodeploy.error_closing_archive", file);
                throw new AutoDeploymentException(msg, ioe);
            }
            return result;
        }

        AbstractArchive openFileAsArchive(String file) throws AutoDeploymentException {
            AbstractArchive archive;
            block3: {
                archive = null;
                File f = new File(file);
                if (this.shouldOpen(f)) {
                    try {
                        archive = AutoDeployer.this.archiveFactory.openArchive(file);
                        this.recordSuccessfulOpen(f);
                    }
                    catch (IOException ioe) {
                        boolean failedPreviously;
                        String errorMsg = null;
                        if (archive != null || (failedPreviously = this.recordFailedOpen(f))) break block3;
                        Info info = this.get(f);
                        errorMsg = localStrings.getString("enterprise.deployment.autodeploy.error_opening_start_retry", file, new Date(info.retryExpiration).toString());
                        sLogger.log(Level.INFO, errorMsg);
                    }
                }
            }
            return archive;
        }

        Info get(File file) {
            Info info = (Info)this.invalidFiles.get(file);
            return info;
        }

        private boolean shouldOpen(File file) {
            boolean result = true;
            String msg = null;
            boolean loggable = sLogger.isLoggable(Level.FINE);
            Info info = (Info)this.invalidFiles.get(file);
            if (info != null) {
                boolean bl = result = file.length() == info.recordedLength;
                if (loggable) {
                    msg = result ? localStrings.getString("enterprise.deployment.autodeploy.try_stable_length", file.getAbsolutePath()) : localStrings.getString("enterprise.deployment.autodeploy.no_try_unstable_length", file.getAbsolutePath(), String.valueOf(file.length()));
                }
                info.update();
            } else if (loggable) {
                msg = localStrings.getString("enterprise.deployment.autodeploy.try_not_monitored", file.getAbsolutePath());
            }
            if (loggable) {
                sLogger.log(Level.FINE, msg);
            }
            return result;
        }

        private boolean recordFailedOpen(File file) throws AutoDeploymentException {
            boolean fileAlreadyPresent;
            Info info = this.get(file);
            if (info == null) {
                fileAlreadyPresent = false;
                info = new Info(file);
                this.invalidFiles.put(file, info);
                if (sLogger.isLoggable(Level.FINE)) {
                    String msg = localStrings.getString("enterprise.deployment.autodeploy.begin_monitoring", file.getAbsolutePath(), new Date(info.retryExpiration).toString());
                    sLogger.log(Level.FINE, msg);
                }
            } else {
                fileAlreadyPresent = true;
                info.update();
                boolean loggable = sLogger.isLoggable(Level.FINE);
                if (info.isEligibleForRetry()) {
                    if (loggable) {
                        String msg = localStrings.getString("enterprise.deployment.autodeploy.continue_monitoring", file.getAbsolutePath(), new Date(info.retryExpiration).toString());
                        sLogger.log(Level.FINE, msg);
                    }
                } else {
                    String msg = localStrings.getString("enterprise.deployment.autodeploy.abort_monitoring", file.getAbsolutePath(), String.valueOf(this.RETRY_LIMIT));
                    if (loggable) {
                        sLogger.log(Level.FINE, msg);
                    }
                    this.invalidFiles.remove(file);
                    throw new AutoDeploymentException(msg);
                }
            }
            return fileAlreadyPresent;
        }

        private boolean recordSuccessfulOpen(File file) {
            if (sLogger.isLoggable(Level.FINE)) {
                String msg = localStrings.getString("enterprise.deployment.autodeploy.end_monitoring", file.getAbsolutePath());
                sLogger.log(Level.FINE, msg);
            }
            return this.invalidFiles.remove(file) != null;
        }

        class Info {
            private File file = null;
            private long recordedLength = 0L;
            private long retryExpiration = 0L;

            public Info(File file) {
                this.file = file;
                this.update();
            }

            private void update() {
                long currentLength = this.file.length();
                if (this.recordedLength != currentLength) {
                    long now = new Date().getTime();
                    this.retryExpiration = now + AutodeployRetryManager.this.RETRY_LIMIT;
                }
                this.recordedLength = currentLength;
            }

            private boolean isEligibleForRetry() {
                long now = new Date().getTime();
                boolean result = now < this.retryExpiration;
                return result;
            }
        }
    }
}

