/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.ejb.codegen.IASEJBCTimes;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.backend.AppDeployerBase;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.EJBCompiler;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.JSPCompiler;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchiveFactory;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.security.factory.EJBSecurityManagerFactory;
import com.sun.enterprise.tools.verifier.AppVerifier;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileSource;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class AppDeployer
extends AppDeployerBase {
    private static final String stars = "\n*********************\n";
    private static StringManager localStrings = StringManager.getManager(AppDeployer.class);

    AppDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void doRequest() throws IASDeploymentException {
        this.doRequestPrepare();
        this.doRequestFinish();
    }

    public void doRequestPrepare() throws IASDeploymentException {
        try {
            this.begin();
        }
        catch (Exception e) {
            this.rollback();
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, msg, e);
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(msg, e);
        }
    }

    public void doRequestFinish() throws IASDeploymentException {
        try {
            try {
                this.predeploy();
                this.deploy();
                this.generatePolicy();
            }
            catch (Exception e) {
                String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
                this.rollback();
                this.logger.log(Level.FINE, msg, e);
                if (e instanceof IASDeploymentException) {
                    throw (IASDeploymentException)e;
                }
                throw new IASDeploymentException(msg, e);
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.finish();
            throw throwable;
        }
        this.finish();
    }

    public void cleanup_internal() {
    }

    protected void predeploy() throws IASDeploymentException {
        super.predeploy();
        if (this.request.isDeploy()) {
            this.liquidateAppDirAndStubsDirIfTheyHappenToExist();
        }
    }

    protected void deploy() throws IASDeploymentException {
        try {
            Application app;
            DeploymentStatus J2EECPhaseStatus = this.request.getCurrentDeploymentStatus();
            if (this.isArchive()) {
                app = this.explodeArchive();
            } else {
                this.getXMLDir().mkdirs();
                this.getJWSDir().mkdirs();
                ApplicationArchivist appArchivist = new ApplicationArchivist();
                String dir = this.request.getDeployedDirectory().getAbsolutePath();
                FileArchive appArchive = new FileArchive();
                appArchive.open(dir);
                if (!appArchivist.hasStandardDeploymentDescriptor(appArchive)) {
                    Application appDesc = Application.createApplication(appArchive, true, true);
                    this.request.setDescriptor(appDesc);
                }
                app = this.loadDescriptors();
            }
            this.request.setDescriptor(app);
            this.request.getDescriptor().setGeneratedXMLDirectory(this.getXMLDir().getAbsolutePath());
            DeploymentStatus runEJBCStatus = new DeploymentStatus(J2EECPhaseStatus);
            this.request.setCurrentDeploymentStatus(runEJBCStatus);
            this.runJSPC();
            this.runVerifier();
            ZipItem[] clientStubs = this.runEJBC();
            this.checkAppclientsMainClasses();
            this.createClientJar(clientStubs);
            DeploymentStatus postDeployStatus = new DeploymentStatus(J2EECPhaseStatus);
            this.request.setCurrentDeploymentStatus(postDeployStatus);
            this.postDeploy();
            this.addToSummary(this.getSuccessMessage() + this.getAppName() + stars);
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void rollback() {
        try {
            this.DeleteOrKeepFailedStubs(this.getStubsDir());
            if (FileUtils.safeIsDirectory(this.getJSPDir())) {
                FileUtils.whack(this.getJSPDir());
            }
            if (FileUtils.safeIsDirectory(this.getXMLDir())) {
                FileUtils.whack(this.getXMLDir());
            }
            if (FileUtils.safeIsDirectory(this.getJWSDir())) {
                FileUtils.whack(this.getJWSDir());
            }
            if (this.isArchive() && FileUtils.safeIsDirectory(this.getAppDir())) {
                FileUtils.whack(this.getAppDir());
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "enterprise.deployment_rollback_error", t);
        }
    }

    private void liquidateAppDirAndStubsDirIfTheyHappenToExist() throws IASDeploymentException {
        if (this.isArchive()) {
            this.cleanAndCheck(this.getAppDir());
        }
        this.cleanAndCheck(this.getStubsDir());
        this.cleanAndCheck(this.getJSPDir());
        this.cleanAndCheck(this.getXMLDir());
        this.cleanAndCheck(this.getJWSDir());
    }

    private void cleanAndCheck(File dir) throws IASDeploymentException {
        if (FileUtils.safeIsDirectory(dir)) {
            FileUtils.whack(dir);
            if (FileUtils.safeIsDirectory(dir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.cannot_delete_dir", dir);
                throw new IASDeploymentException(msg);
            }
        }
    }

    private Application explodeArchive() throws Exception {
        Application appDesc = J2EEModuleExploder.explodeEar(this.request.getFileSource().getFile(), this.getAppDir());
        appDesc.setRegistrationName(this.request.getName());
        this.request.setDescriptor(appDesc);
        this.getXMLDir().mkdirs();
        this.getJWSDir().mkdirs();
        this.getStubsDir().mkdirs();
        this.loadDescriptors();
        return appDesc;
    }

    private ZipItem[] runEJBC() throws IASDeploymentException {
        ZipItem[] clientStubs = null;
        try {
            IASEJBCTimes timing = new IASEJBCTimes();
            EJBCompiler compiler = new EJBCompiler(this.getAppName(), this.getAppDir(), this.getOldAppDir(), this.getStubsDir(), this.getOldStubsDir(), this.getManager(), this.request, timing);
            clientStubs = compiler.compile();
            this.addEJBCTime(timing);
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "enterprise.deployment_ejbc_error", e);
            String msg = localStrings.getString("enterprise.deployment.backend.ejbc_error");
            throw new IASDeploymentException(msg, e);
        }
        return clientStubs;
    }

    private void runJSPC() throws IASDeploymentException {
        if (!this.request.getPrecompileJSP()) {
            return;
        }
        Application app = this.request.getDescriptor();
        Set webBundleDescriptors = app.getWebBundleDescriptors();
        if (webBundleDescriptors == null) {
            return;
        }
        for (WebBundleDescriptor wbd : webBundleDescriptors) {
            String warDirName = FileUtils.makeFriendlyFilename(wbd.getModuleDescriptor().getArchiveUri());
            File outDir = new File(this.getJSPDir(), warDirName);
            File inDir = new File(this.getAppDir(), warDirName);
            long time = System.currentTimeMillis();
            JSPCompiler.compile(inDir, outDir, wbd, this.request.getCompleteClasspath());
            this.addJSPCTime(System.currentTimeMillis() - time);
        }
    }

    protected void postDeploy() throws ConfigException, IASDeploymentException {
        String resourceType;
        Application applicationDD = this.request.getDescriptor();
        this.getManager().registerDescriptor(applicationDD.getRegistrationName(), applicationDD);
        DeploymentEventInfo info = new DeploymentEventInfo(this.getAppDir(), this.getStubsDir(), this.getOldStubsDir(), applicationDD, this.getRequest());
        DeploymentEvent ev = new DeploymentEvent(2, info);
        DeploymentEventManager.notifyDeploymentEvent(ev);
        WebSecurityManagerFactory wsmfactory = WebSecurityManagerFactory.getInstance();
        Iterator iter = applicationDD.getWebBundleDescriptors().iterator();
        while (iter.hasNext()) {
            wsmfactory.newWebSecurityManager((WebBundleDescriptor)iter.next());
        }
        EJBSecurityManagerFactory ejbmfactory = (EJBSecurityManagerFactory)EJBSecurityManagerFactory.getInstance();
        for (Object ejbBundleDescObj : applicationDD.getEjbBundleDescriptors()) {
            for (Object ejbDescObj : ((EjbBundleDescriptor)ejbBundleDescObj).getEjbs()) {
                ejbmfactory.createSecurityManager((EjbDescriptor)ejbDescObj);
            }
        }
        if (!this.isDirectory()) {
            this.postDeployArchive();
        }
        this.getManager().registerDescriptor(this.request.getName(), this.request.getDescriptor());
        Properties optionalAttributes = this.request.getOptionalAttributes();
        if (optionalAttributes == null) {
            optionalAttributes = new Properties();
        }
        if ((resourceType = this.getResourceType(this.getAppDir())) != null) {
            optionalAttributes.setProperty("object-type", resourceType);
        }
    }

    private void postDeployArchive() throws ConfigException, IASDeploymentException {
    }

    protected File setAppDir() throws IASDeploymentException {
        File appDirectory;
        ApplicationEnvironment aenv = this.getAppEnv();
        if (this.isArchive()) {
            File parent = new File(this.getInstanceEnv().getApplicationRepositoryPath());
            appDirectory = new File(parent, this.getAppName());
            appDirectory.mkdirs();
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (!fileSource.exists()) {
                String msg = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource.toString());
                throw new IASDeploymentException(msg);
            }
            assert (fileSource.isDirectory());
            appDirectory = fileSource.getFile();
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.deployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
        return appDirectory;
    }

    protected File getOldStubsDir() {
        return null;
    }

    protected File getOldAppDir() {
        return null;
    }

    protected String whatAreYou() {
        return "Deployment";
    }

    protected final String getSuccessMessage() {
        return "\n*********************\n**** " + this.whatAreYou() + " successful for " + this.getAppName() + " ****" + stars;
    }

    protected final String getFailureMessage() {
        return "\n*********************\n**** " + this.whatAreYou() + " failed for " + this.getAppName() + " ****" + stars;
    }

    private void runVerifier() throws IASDeploymentException {
        if (this.request.isVerifying()) {
            try {
                String archive = this.request.getDeployedDirectory().getCanonicalPath();
                File jspDir = this.request.getPrecompileJSP() ? this.getJSPDir() : null;
                new AppVerifier().verify(this.request.getDescriptor(), new FileArchiveFactory().openArchive(archive), this.request.getCompleteClasspath(), jspDir);
            }
            catch (Exception e) {
                String msg = localStrings.getString("enterprise.deployment.backend.verifier_error");
                throw new IASDeploymentException(msg);
            }
        }
    }
}

