/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.WsUtil;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.SingleThreadModel;

public class WebServiceDeployer {
    private static StringManager localStrings = StringManager.getManager(WebServiceDeployer.class);
    private DeploymentRequest request;

    public WebServiceDeployer(DeploymentRequest request) {
        this.request = request;
    }

    public void doWebServiceDeployment(Application app, File appDir) throws Exception {
        ClassLoader loader = app.getClassLoader();
        HashSet webBundles = new HashSet();
        HashSet webServices = new HashSet();
        webBundles.addAll(app.getWebBundleDescriptors());
        webServices.addAll(app.getWebServiceDescriptors());
        if (this.request.getContextRoot() != null && app.isVirtual()) {
            ((WebBundleDescriptor)webBundles.iterator().next()).setContextRoot(this.request.getContextRoot());
        }
        Iterator iter = webBundles.iterator();
        while (iter.hasNext()) {
            this.doWebServiceDeployment((WebBundleDescriptor)iter.next(), appDir);
        }
        iter = webServices.iterator();
        while (iter.hasNext()) {
            File tmpName;
            WsUtil wsUtil = new WsUtil();
            WebService next = (WebService)iter.next();
            if (next.getWsdlFileUrl() == null && next.getMappingFileUri() == null) {
                for (WebServiceEndpoint wsep : next.getEndpoints()) {
                    if (!"http://www.w3.org/2004/08/wsdl/http".equals(wsep.getProtocolBinding())) {
                        throw new Exception(localStrings.getStringWithDefault("enterprise.webservice.noWsdlError", "Service {0} has an endpoint with non-HTTP binding but there is no WSDL; Deployment cannot proceed", new Object[]{next.getName()}));
                    }
                    wsep.composeFinalWsdlUrl(wsUtil.getWebServerInfo(this.request).getWebServerRootURL(wsep.isSecure()));
                }
                continue;
            }
            URL clientPublishLocation = next.getClientPublishUrl();
            URL url = next.getWsdlFileUrl();
            File genXmlDir = this.request.getGeneratedXMLDirectory();
            if (this.request.isApplication()) {
                String subDirName = next.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                genXmlDir = new File(genXmlDir, subDirName.replaceAll("\\.", "_"));
            }
            File genWsdlFile = null;
            if (!next.hasWsdlFile()) {
                genWsdlFile = new File(url.toURI());
                genWsdlFile = File.createTempFile("gen_", "", genWsdlFile.getParentFile());
            } else {
                String wsdlFileDir = next.getWsdlFileUri().substring(0, next.getWsdlFileUri().lastIndexOf(47));
                new File(genXmlDir, wsdlFileDir).mkdirs();
                genWsdlFile = new File(genXmlDir, next.getWsdlFileUri());
            }
            wsUtil.generateFinalWsdl(url, next, wsUtil.getWebServerInfo(this.request), genWsdlFile);
            if (next.hasWsdlFile()) continue;
            File finalName = new File(url.toURI());
            boolean renameDone = finalName.renameTo(tmpName = new File(genWsdlFile.getAbsolutePath() + ".TMP"));
            if (!renameDone) {
                FileUtils.moveFile(finalName.getAbsolutePath(), tmpName.getAbsolutePath());
            }
            if (!(renameDone = genWsdlFile.renameTo(finalName))) {
                FileUtils.moveFile(genWsdlFile.getAbsolutePath(), finalName.getAbsolutePath());
            }
            tmpName.delete();
        }
    }

    public void doWebServiceDeployment(WebBundleDescriptor web, File outDir) throws Exception {
        Collection<WebServiceEndpoint> endpoints = web.getWebServices().getEndpoints();
        ClassLoader loader = web.getClassLoader();
        boolean writeModule = !endpoints.isEmpty();
        for (WebServiceEndpoint nextEndpoint : endpoints) {
            WebComponentDescriptor webComp = nextEndpoint.getWebComponentImpl();
            String servletImplClass = nextEndpoint.getServletImplClass();
            if (!nextEndpoint.hasServletImplClass()) {
                throw new Exception(localStrings.getStringWithDefault("enterprise.deployment.backend.cannot_find_servlet", "Runtime settings error.  Cannot find servlet-impl-class for endpoint {0} ", new Object[]{nextEndpoint.getEndpointName()}));
            }
            if (!nextEndpoint.getWebService().hasFilePublishing()) {
                String publishingUri = nextEndpoint.getPublishingUri();
                String publishingUrlPattern = publishingUri.charAt(0) == '/' ? publishingUri : "/" + publishingUri + "/*";
                webComp.addUrlPattern(publishingUrlPattern);
            }
            Class<?> servletImplClazz = loader.loadClass(servletImplClass);
            String containerServlet = "1.1".compareTo(web.getWebServices().getSpecVersion()) < 0 ? "com.sun.enterprise.webservice.JAXWSServlet" : (SingleThreadModel.class.isAssignableFrom(servletImplClazz) ? "com.sun.enterprise.webservice.SingleThreadJAXRPCServlet" : "com.sun.enterprise.webservice.JAXRPCServlet");
            webComp.setWebComponentImplementation(containerServlet);
        }
    }
}

