/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import com.sun.enterprise.deployment.annotation.introspection.CustomAnnotationScanner;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public abstract class AnnotationDetector {
    private ClassFile classFile = new ClassFile();

    public AnnotationDetector() {
        CustomAnnotationScanner scanner = this.createAnnotationScanner();
        ConstantPoolInfo poolInfo = new ConstantPoolInfo(scanner);
        this.classFile.setConstantPoolInfo(poolInfo);
    }

    protected abstract CustomAnnotationScanner createAnnotationScanner();

    public boolean hasAnnotationInArchive(AbstractArchive archive) throws IOException {
        File file = new File(archive.getArchiveUri());
        if (!file.exists()) {
            throw new FileNotFoundException(archive.getArchiveUri());
        }
        if (file.isDirectory()) {
            return this.hasAnnotationInDirectory(archive);
        }
        return this.hasAnnotationInJar(archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotationInJar(AbstractArchive archive) throws IOException {
        ZipFile jf = null;
        try {
            jf = new JarFile(new File(archive.getArchiveUri()));
            Enumeration<JarEntry> entriesEnum = ((JarFile)jf).entries();
            while (entriesEnum.hasMoreElements()) {
                JarEntry je = entriesEnum.nextElement();
                if (!je.getName().endsWith(".class") || !this.containsAnnotation((JarFile)jf, je)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (jf != null) {
                jf.close();
            }
        }
        return false;
    }

    private boolean hasAnnotationInDirectory(AbstractArchive archive) throws IOException {
        Enumeration entriesEnum = archive.entries();
        while (entriesEnum.hasMoreElements()) {
            String entry = (String)entriesEnum.nextElement();
            if (!entry.endsWith(".class")) continue;
            File file = null;
            int ind = entry.lastIndexOf("/");
            if (ind != -1) {
                String entryName = entry.substring(ind + 1);
                String parent = archive.getArchiveUri() + File.separatorChar + entry.substring(0, ind);
                file = new File(parent.replace('/', File.separatorChar), entryName);
            } else {
                file = new File(archive.getArchiveUri(), entry);
            }
            if (!this.containsAnnotation(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotation(JarFile jarFile, JarEntry entry) throws IOException {
        boolean result = false;
        ReadableByteChannel channel = null;
        try {
            channel = Channels.newChannel(jarFile.getInputStream(entry));
            if (channel != null) {
                result = this.classFile.containsAnnotation(channel, entry.getSize());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotation(File file) throws FileNotFoundException, IOException {
        boolean result = false;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            ReadableByteChannel channel = Channels.newChannel(is);
            if (channel != null) {
                result = this.classFile.containsAnnotation(channel, file.length());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

