/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util.webservice;

import com.sun.enterprise.deployment.util.webservice.SEIConfig;
import com.sun.enterprise.deployment.util.webservice.WSDLConfig;
import com.sun.enterprise.deployment.util.webservice.WsCompileInvoker;
import com.sun.enterprise.deployment.util.webservice.WsCompileInvokerException;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.tools.CompileTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;

public class WsCompileInvokerImpl
extends WsCompileInvoker {
    private OutputStream output = null;

    public WsCompileInvokerImpl(OutputStream out) {
        this.output = out;
    }

    private void invokeTool(File configFile, String operation) throws WsCompileInvokerException {
        String value;
        String key;
        int wsCompileOptionCount = 0;
        Object[] keySet = this.wsCompileOptions.keySet().toArray();
        for (int j = 0; j < keySet.length; ++j) {
            key = (String)keySet[j];
            value = (String)this.wsCompileOptions.get(keySet[j]);
            if (value == null) {
                ++wsCompileOptionCount;
                continue;
            }
            wsCompileOptionCount += 2;
        }
        String[] wscompileArgs = new String[wsCompileOptionCount + 3];
        int argsIndex = 0;
        for (int i = 0; i < keySet.length; ++i) {
            key = (String)keySet[i];
            value = (String)this.wsCompileOptions.get(keySet[i]);
            wscompileArgs[argsIndex++] = key;
            if (value == null) continue;
            wscompileArgs[argsIndex++] = value;
        }
        wscompileArgs[argsIndex++] = "-" + operation;
        wscompileArgs[argsIndex++] = "-keep";
        wscompileArgs[argsIndex++] = configFile.getPath();
        CompileTool tool = JaxRpcObjectFactory.newInstance().createCompileTool(this.output, "wscompile");
        if (!tool.run(wscompileArgs)) {
            throw new WsCompileInvokerException("wscompile invocation failed");
        }
    }

    public void generateWSDL(SEIConfig config) throws WsCompileInvokerException, IOException {
        File configFile = File.createTempFile("wscompileinvoker_seiinfo", "config");
        configFile.deleteOnExit();
        FileWriter writer = new FileWriter(configFile);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        writer.write("<configuration xmlns=\"http://java.sun.com/xml/ns/jax-rpc/ri/config\">\n");
        writer.write("<service name=\"" + config.getWebServiceName() + "\" ");
        writer.write("targetNamespace=\"urn:" + config.getNameSpace() + "\" ");
        writer.write("typeNamespace=\"urn:" + config.getNameSpace() + "\" ");
        writer.write("packageName=\"" + config.getPackageName() + "\">\n");
        writer.write("<interface name=\"" + config.getInterface() + "\" ");
        writer.write("servantName=\"" + config.getServant() + "\"/>\n");
        writer.write("<typeMappingRegistry />\n");
        writer.write("</service>\n");
        writer.write("</configuration>\n");
        writer.close();
        this.invokeTool(configFile, "define");
    }

    public void generateSEI(WSDLConfig config) throws WsCompileInvokerException, IOException {
        File configFile = File.createTempFile("wscompileinvoker_wsdlinfo", "config");
        configFile.deleteOnExit();
        FileWriter writer = new FileWriter(configFile);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        writer.write("<configuration xmlns=\"http://java.sun.com/xml/ns/jax-rpc/ri/config\">\n");
        writer.write("<wsdl location=\"" + config.getWsdlLocation() + "\" packageName=\"" + config.getPackageName() + "\">\n");
        writer.write("<typeMappingRegistry />\n");
        writer.write("</wsdl>\n");
        writer.write("</configuration>\n");
        writer.close();
        this.invokeTool(configFile, "import");
    }

    public void generateClientStubs(WSDLConfig config) throws WsCompileInvokerException, IOException {
        File configFile = File.createTempFile("wscompileinvoker_stubsinfo", "config");
        configFile.deleteOnExit();
        FileWriter writer = new FileWriter(configFile);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        writer.write("<configuration xmlns=\"http://java.sun.com/xml/ns/jax-rpc/ri/config\">\n");
        writer.write("<wsdl name=\"" + config.getWebServiceName() + "\" location=\"" + config.getWsdlLocation() + "\" packageName=\"" + config.getPackageName() + "\">\n");
        writer.write("<typeMappingRegistry />\n");
        writer.write("</wsdl>\n");
        writer.write("</configuration>\n");
        writer.close();
        this.invokeTool(configFile, "gen:client");
    }
}

