/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.report.html;

import com.sun.enterprise.diagnostics.report.html.Attribute;
import com.sun.enterprise.diagnostics.report.html.Escape;
import com.sun.enterprise.diagnostics.report.html.Text;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class HTMLAttribute
implements Attribute,
Text {
    private String name = null;
    private String value = null;
    private static final String DOUBLE_QUOTES = "\"";
    private static final char EQUALS = '=';

    public HTMLAttribute(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("Attribute value is null.");
        }
        this.value = value;
    }

    public String toString() {
        String nameStr = Escape.getInstance().encodeEntities(this.name, " \t\r\n");
        String valueStr = Escape.getInstance().encodeEntities(this.value, "");
        StringBuffer buf = new StringBuffer();
        buf.append(nameStr).append("=\"").append(valueStr).append(DOUBLE_QUOTES);
        return buf.toString();
    }

    public void write(Writer output) throws IOException {
        output.append(this.toString());
        output.flush();
    }

    public void write(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        this.write(fw);
        fw.close();
    }
}

