/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.ModulesManager;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

public class EjbModulesManager
extends ModulesManager {
    public EjbModulesManager(InstanceEnvironment env) throws ConfigException {
        super(env, true);
    }

    public EjbModulesManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        super(env, useBackupServerXml);
        EjbModule[] jArray = ((Applications)this.configBean).getEjbModule();
        if (jArray != null) {
            for (int i = 0; i < jArray.length; ++i) {
                jArray[i].setConfigContext(this.configContext);
                jArray[i].setXPath(ServerXPathHelper.getEjbModuleIdXpathExpression(jArray[i].getName()));
            }
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.EJB;
    }

    public EjbModule[] listEjbModules() {
        EjbModule[] mods = ((Applications)this.configBean).getEjbModule();
        if (mods == null) {
            return new EjbModule[0];
        }
        ArrayList<EjbModule> list = new ArrayList<EjbModule>();
        for (int i = 0; i < mods.length; ++i) {
            if (!this.isReferenced(mods[i].getName())) continue;
            list.add(mods[i]);
        }
        EjbModule[] refList = new EjbModule[list.size()];
        return list.toArray(refList);
    }

    public List listIds() {
        ArrayList<String> arr = new ArrayList<String>();
        EjbModule[] mods = ((Applications)this.configBean).getEjbModule();
        if (mods == null) {
            return arr;
        }
        for (int i = 0; i < mods.length; ++i) {
            String name = mods[i].getName();
            if (!this.isReferenced(name)) continue;
            arr.add(name);
        }
        return arr;
    }

    private EjbModule getEjbModule(String modId) throws ConfigException {
        EjbModule mod = ((Applications)this.configBean).getEjbModuleByName(modId);
        if (mod == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_EJB_MOD));
        }
        return mod;
    }

    public void remove(String modID) throws ConfigException {
        this.removeEjbModule(modID);
    }

    private void removeEjbModule(String modId) throws ConfigException {
        EjbModule backEm = ((Applications)this.configBean).getEjbModuleByName(modId);
        ((Applications)this.configBean).removeEjbModule(backEm);
    }

    protected boolean isRegistered(String appId, ConfigBean bean) {
        EjbModule cb = null;
        try {
            cb = ((Applications)bean).getEjbModuleByName(appId);
        }
        catch (Exception cn) {
            // empty catch block
        }
        return cb != null;
    }

    public boolean isShared(String modId) throws ConfigException {
        return false;
    }

    public boolean isEnabled(String modId) throws ConfigException {
        return this.getEjbModule(modId).isEnabled();
    }

    public boolean isSystem(String modId) throws ConfigException {
        EjbModule em = this.getEjbModule(modId);
        String resourceType = em.getObjectType();
        return resourceType.startsWith("system-");
    }

    public boolean isSystemAdmin(String modId) throws ConfigException {
        EjbModule em = this.getEjbModule(modId);
        String resourceType = em.getObjectType();
        return resourceType.startsWith("system-admin");
    }

    public void setShared(String modId, boolean shared) throws ConfigException {
    }

    public void setEnable(String modId, boolean enable) throws ConfigException {
        this.getEjbModule(modId).setEnabled(enable);
    }

    public void setOptionalAttributes(String modId, Properties optionalAttributes) throws ConfigException {
        if (optionalAttributes != null) {
            EjbModule em = this.getEjbModule(modId);
            Enumeration<Object> tags = optionalAttributes.keys();
            while (tags.hasMoreElements()) {
                String tag = (String)tags.nextElement();
                String value = optionalAttributes.getProperty(tag);
                em.setAttributeValue(tag, value);
            }
        }
    }

    public String getLocation(String name) throws ConfigException {
        EjbModule ejbModule = ((Applications)this.configBean).getEjbModuleByName(name);
        String location = ejbModule.getLocation();
        return this.resolvePath(location);
    }

    public void setLocation(String modId, String location) throws ConfigException {
        this.getEjbModule(modId).setLocation(location);
    }

    public String getStubLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.EJB);
        return menv.getModuleStubPath();
    }

    public String getGeneratedXMLLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.EJB);
        return menv.getModuleGeneratedXMLPath();
    }

    public String getDescription(String modId) throws ConfigException {
        return this.getEjbModule(modId).getDescription();
    }

    public void setDescription(String modId, String desc) throws ConfigException {
        this.getEjbModule(modId).setDescription(desc);
    }

    public Application getDescriptor(String moduleID, ClassLoader parentClassLoader) throws ConfigException {
        EJBClassLoader cl = new EJBClassLoader(parentClassLoader);
        String[] classPaths = EJBClassPathUtils.getModuleClasspath(moduleID, null, this).toArray(new String[0]);
        if (classPaths != null) {
            int classPathSize = classPaths.length;
            for (int i = 0; i < classPathSize; ++i) {
                try {
                    cl.appendURL(new File(classPaths[i]));
                    continue;
                }
                catch (IOException ioe) {
                    _logger.log(Level.WARNING, "Cannot convert path to URL: " + classPaths[i]);
                }
            }
        }
        return this.getDescriptor(moduleID, cl, false);
    }

    public Application getDescriptor(String modId, ClassLoader cl, String loc, boolean validateXML) throws ConfigException {
        return this.getDescriptor(modId, cl, validateXML);
    }

    public Application getDescriptor(String modId, ClassLoader cl, boolean validateXml) throws ConfigException {
        Application application = this.getRegisteredDescriptor(modId);
        if (application != null) {
            application.setClassLoader(cl);
            return application;
        }
        try {
            String moduleDir = this.getLocation(modId);
            EjbArchivist ejbArchivist = new EjbArchivist();
            ejbArchivist.setXMLValidation(validateXml);
            ClassLoader tcl = cl instanceof InstrumentableClassLoader ? ((InstrumentableClassLoader)InstrumentableClassLoader.class.cast(cl)).copy() : cl;
            ejbArchivist.setClassLoader(tcl);
            FileArchive archive = new FileArchive();
            if (this.isSystemAdmin(modId)) {
                archive.open(moduleDir);
            } else {
                String xmlDir = this.getGeneratedXMLLocation(modId);
                if (FileUtils.safeIsDirectory(xmlDir)) {
                    archive.open(xmlDir);
                } else {
                    _logger.log(Level.WARNING, "core.no_xmldir", new Object[]{xmlDir, moduleDir});
                    archive.open(moduleDir);
                }
            }
            application = ApplicationArchivist.openArchive(modId, ejbArchivist, archive, true);
            application.setClassLoader(tcl);
            for (BundleDescriptor bd : application.getBundleDescriptors()) {
                bd.setClassLoader(tcl);
            }
            if (!this.isSystemAdmin(modId) && !this.isSystem(modId)) {
                this.readPersistenceDeploymentDescriptors(moduleDir, application);
            }
            application.setGeneratedXMLDirectory(this.getGeneratedXMLLocation(modId));
            if (!application.getWebServiceDescriptors().isEmpty()) {
                ModuleContentLinker visitor = new ModuleContentLinker(archive);
                application.visit(visitor);
            }
            application.setClassLoader(cl);
            for (BundleDescriptor bd : application.getBundleDescriptors()) {
                bd.setClassLoader(cl);
            }
            this.registerDescriptor(modId, application);
            return application;
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (IOException ioe) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, modId), ioe);
        }
        catch (Throwable t) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, modId), t);
        }
    }
}

