/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.agent;

import com.sun.enterprise.management.agent.EventListenerProxy;
import com.sun.enterprise.management.agent.MEJBUtility;
import com.sun.enterprise.management.agent.RemoteListenerConnector;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.ListenerRegistration;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class ListenerRegistry
implements ListenerRegistration {
    private Hashtable listenerConnectors = new Hashtable();
    private String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    private String serverAddress;
    private Management server;
    private boolean debug = false;

    public ListenerRegistry(String ip) {
        this.serverAddress = ip;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws RemoteException {
        String proxyAddress = EventListenerProxy.getEventListenerProxy().getProxyAddress();
        try {
            if (this.debug) {
                System.out.println("ListenerRegistry:addNotificationListener(" + listener + ") to " + name);
            }
            RemoteListenerConnector connector = new RemoteListenerConnector(proxyAddress);
            this.getMEJBUtility().addNotificationListener(name, connector, filter, (Object)connector.getId());
            EventListenerProxy.getEventListenerProxy().addListener(connector.getId(), listener, handback);
            this.listenerConnectors.put(listener, connector);
        }
        catch (InstanceNotFoundException inf) {
            throw new RemoteException(inf.getMessage(), inf);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws RemoteException {
        EventListenerProxy proxy = EventListenerProxy.getEventListenerProxy();
        try {
            if (this.debug) {
                System.out.println("removeNotificationListener: " + listener);
                System.out.println("listenerProxy = " + this.listenerConnectors.get(((RemoteListenerConnector)listener).getId()));
            }
            RemoteListenerConnector connector = (RemoteListenerConnector)this.listenerConnectors.get(listener);
            this.getMEJBUtility().removeNotificationListener(name, connector);
            proxy.removeListener(connector.getId());
            this.listenerConnectors.remove(listener);
        }
        catch (InstanceNotFoundException inf) {
            throw new RemoteException(inf.getMessage(), inf);
        }
        catch (ListenerNotFoundException lnf) {
            throw new RemoteException(lnf.getMessage(), lnf);
        }
    }

    MEJBUtility getMEJBUtility() {
        return MEJBUtility.getMEJBUtility();
    }

    Management getMEJB() throws RemoteException {
        if (this.server == null) {
            try {
                InitialContext ic = new InitialContext();
                String ejbName = System.getProperty("mejb.name", "ejb/mgmt/MEJB");
                Object objref = ic.lookup(ejbName);
                ManagementHome home = (ManagementHome)PortableRemoteObject.narrow(objref, ManagementHome.class);
                this.server = home.create();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.server;
    }
}

