/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.management.model.J2EEManagedObjectMdl;
import com.sun.enterprise.server.PEMain;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

public class J2EEServerMdl
extends J2EEManagedObjectMdl {
    private String serverVendor = "Sun Microsystems, Inc.";
    private String serverVersion = "8.0";
    private static String MANAGED_OBJECT_TYPE = "J2EEServer";
    private long startTime = System.currentTimeMillis();
    private static String DEBUG_SYS_PROPERTY = "com.sun.aas.jdwpOptions";

    public J2EEServerMdl() {
        super("j2ee100", true, false, false);
    }

    public J2EEServerMdl(String serverName, String version) {
        super(serverName, serverName, true, false, false);
        this.serverVersion = version;
    }

    public J2EEServerMdl(String[] location) {
        this(location[1], "8.0");
    }

    public String[] getdeployedObjects() {
        Set apps = this.findNames("j2eeType=J2EEApplication,J2EEServer=" + this.getJ2EEServer());
        apps.addAll(this.findNames("j2eeType=EJBModule,J2EEServer=" + this.getJ2EEServer()));
        apps.addAll(this.findNames("j2eeType=WebModule,J2EEServer=" + this.getJ2EEServer()));
        apps.addAll(this.findNames("j2eeType=ResourceAdapterModule,J2EEServer=" + this.getJ2EEServer()));
        apps.addAll(this.findNames("j2eeType=AppClientModule,J2EEServer=" + this.getJ2EEServer()));
        Iterator it = apps.iterator();
        String[] deployed = new String[apps.size()];
        int i = 0;
        while (it.hasNext()) {
            deployed[i++] = ((ObjectName)it.next()).toString();
        }
        return deployed;
    }

    public String[] getresources() {
        Set res = this.findNames("j2eeType=JCAResource,J2EEServer=" + this.getJ2EEServer());
        res.addAll(this.findNames("j2eeType=JavaMailResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=JDBCResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=JMSResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=JNDIResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=JTAResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=RMI_IIOPResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=URLResource,J2EEServer=" + this.getJ2EEServer()));
        res.addAll(this.findNames("j2eeType=AdminObjectResource,J2EEServer=" + this.getJ2EEServer()));
        Iterator it = res.iterator();
        String[] resources = new String[res.size()];
        int i = 0;
        while (it.hasNext()) {
            resources[i++] = ((ObjectName)it.next()).toString();
        }
        return resources;
    }

    public String[] getnodes() {
        try {
            return new String[]{InetAddress.getLocalHost().toString()};
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public String[] getjavaVMs() {
        Set vms = this.findNames("j2eeType=JVM");
        Iterator it = vms.iterator();
        String[] jvms = new String[vms.size()];
        int i = 0;
        while (it.hasNext()) {
            jvms[i++] = ((ObjectName)it.next()).toString();
        }
        return jvms;
    }

    public String getserverVendor() {
        return this.serverVendor;
    }

    public String getserverVersion() {
        return Version.getVersion();
    }

    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public String getobjectName() {
        Set s = this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + this.getJ2EEServer());
        Object[] objs = s.toArray();
        if (objs.length > 0) {
            String name = ((ObjectName)objs[0]).toString();
            return name;
        }
        return null;
    }

    public long getstartTime() {
        return this.startTime;
    }

    public void start() {
    }

    public void startRecursive() {
        this.start();
    }

    public void stop() {
        PEMain.shutdown();
    }

    public String getdebugPort() {
        int nameIndex;
        String debug = System.getProperty(DEBUG_SYS_PROPERTY);
        if (debug != null && (nameIndex = debug.indexOf("address")) != -1) {
            String value = debug.substring(nameIndex + "address".length() + 1);
            int commaIndex = value.indexOf(",");
            if (commaIndex != -1) {
                value = value.substring(0, commaIndex);
            }
            return value;
        }
        return null;
    }

    public boolean isrestartRequired() {
        String instanceId = AdminService.getAdminService().getInstanceName();
        RMIClient rc = AdminChannel.getRMIClient(instanceId);
        return rc.isRestartNeeded();
    }
}

