/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import java.util.HashMap;

public class CipherInfo {
    private static final short SSL2 = 1;
    private static final short SSL3 = 2;
    private static final short TLS = 4;
    private static final String[][] OLD_HTTP_CIPHER_MAPPING;
    private static final String[][] OLD_CIPHER_MAPPING;
    private static final String[] USER_CONFIGURABLE_CIPHERS;
    private static HashMap ciphers;
    private String configName;
    private String cipherName;
    private short protocolVersion;

    private CipherInfo(String configName, String cipherName, short protocolVersion) {
        this.configName = configName;
        this.cipherName = cipherName;
        this.protocolVersion = protocolVersion;
    }

    public static CipherInfo getCipherInfo(String configName) {
        return (CipherInfo)ciphers.get(configName);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public boolean isSSL2() {
        return (this.protocolVersion & 1) == 1;
    }

    public boolean isSSL3() {
        return (this.protocolVersion & 2) == 2;
    }

    public boolean isTLS() {
        return (this.protocolVersion & 4) == 4;
    }

    static {
        String stdName;
        String nonStdName;
        int i;
        OLD_HTTP_CIPHER_MAPPING = new String[][]{{"rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5"}, {"rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"rsa_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"rsa_null_md5", "SSL_RSA_WITH_NULL_MD5"}, {"rsa_des_56_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_rc4_56_sha", "SSL_RSA_WITH_RC4_128_SHA"}};
        OLD_CIPHER_MAPPING = new String[][]{{"rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA"}, {"fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_null_sha", "SSL_RSA_WITH_NULL_SHA"}};
        USER_CONFIGURABLE_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_NULL_SHA"};
        ciphers = new HashMap();
        for (String s : USER_CONFIGURABLE_CIPHERS) {
            ciphers.put(s, new CipherInfo(s, s, 6));
        }
        int len = OLD_HTTP_CIPHER_MAPPING.length;
        for (i = 0; i < len; ++i) {
            nonStdName = OLD_HTTP_CIPHER_MAPPING[i][0];
            stdName = OLD_HTTP_CIPHER_MAPPING[i][1];
            ciphers.put(nonStdName, new CipherInfo(nonStdName, stdName, 6));
        }
        len = OLD_CIPHER_MAPPING.length;
        for (i = 0; i < len; ++i) {
            nonStdName = OLD_CIPHER_MAPPING[i][0];
            stdName = OLD_CIPHER_MAPPING[i][1];
            ciphers.put(nonStdName, new CipherInfo(nonStdName, stdName, 6));
        }
    }
}

