/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class RoleMapper
implements Serializable,
SecurityRoleMapper {
    private static Map ROLEMAPPER = new HashMap();
    private static final String DEFAULT_ROLE_NAME = "ANYONE";
    private static Role defaultRole = null;
    private static String defaultRoleName = null;
    private String appName;
    private final Map roleToSubject = new HashMap();
    private static String defaultP2RMappingClassName = null;
    private DefaultRoleToSubjectMapping defaultRTSM = new DefaultRoleToSubjectMapping();
    private final Map roleToPrincipal = new HashMap();
    private final Map roleToGroup = new HashMap();
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");

    private RoleMapper(String appName) {
        this.appName = appName;
        Switch sw = Switch.getSwitch();
        if (sw.getContainerType() == 2) {
            RoleMapper.initDefaultRole();
        }
        if (defaultP2RMappingClassName == null) {
            defaultP2RMappingClassName = RoleMapper.getDefaultP2RMappingClassName();
        }
    }

    private static synchronized void initDefaultRole() {
        if (defaultRole == null) {
            defaultRoleName = DEFAULT_ROLE_NAME;
            try {
                ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
                assert (configContext != null);
                Server configBean = ServerBeansFactory.getServerBean(configContext);
                assert (configBean != null);
                SecurityService securityBean = ServerBeansFactory.getSecurityServiceBean(configContext);
                assert (securityBean != null);
                defaultRoleName = securityBean.getAnonymousRole();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "java_security.anonymous_role_reading_exception", e);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Default role is: " + defaultRoleName);
            }
            defaultRole = new Role(defaultRoleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RoleMapper getRoleMapper(String appName) {
        RoleMapper r = (RoleMapper)ROLEMAPPER.get(appName);
        if (r != null) return r;
        r = new RoleMapper(appName);
        Class<RoleMapper> clazz = RoleMapper.class;
        synchronized (RoleMapper.class) {
            ROLEMAPPER.put(appName, r);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoleMapper(String appName, SecurityRoleMapper rmap) {
        Class<RoleMapper> clazz = RoleMapper.class;
        synchronized (RoleMapper.class) {
            ROLEMAPPER.put(appName, rmap);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeRoleMapper(String appName) {
        if (!ROLEMAPPER.containsKey(appName)) return;
        Class<RoleMapper> clazz = RoleMapper.class;
        synchronized (RoleMapper.class) {
            ROLEMAPPER.remove(appName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    private void addRoleToPrincipal(final Principal principal, String role) {
        assert (this.roleToSubject != null);
        Subject subject = (Subject)this.roleToSubject.get(role);
        final Subject sub = subject == null ? new Subject() : subject;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(principal);
                return null;
            }
        });
        this.roleToSubject.put(role, sub);
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        assert (this.roleToSubject != null);
        String mrole = role.getName();
        final Subject sub = (Subject)this.roleToSubject.get(mrole);
        final Principal p = principal;
        if (sub != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sub.getPrincipals().remove(p);
                    return null;
                }
            });
            this.roleToSubject.put(mrole, sub);
        }
        Map tmp = null;
        tmp = principal instanceof Group ? this.roleToGroup : this.roleToPrincipal;
        Vector v = (Vector)tmp.get(mrole);
        if (v != null) {
            v.remove(principal);
            tmp.put(mrole, v);
        }
    }

    static boolean isDefaultRTSMActivated() {
        return defaultP2RMappingClassName != null;
    }

    public Map getRoleToSubjectMapping() {
        assert (this.roleToSubject != null);
        if (this.roleToSubject.isEmpty() && RoleMapper.isDefaultRTSMActivated()) {
            return this.defaultRTSM;
        }
        return this.roleToSubject;
    }

    public void assignRole(Principal p, Role r) {
        String role = r.getName();
        Map tmp_map = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SECURITY:RoleMapper Assigning Role " + role + " to  " + p.getName());
        }
        this.addRoleToPrincipal(p, role);
        tmp_map = p instanceof Group ? this.roleToGroup : this.roleToPrincipal;
        Vector<Principal> _principals = (Vector<Principal>)tmp_map.get(role);
        if (_principals == null) {
            _principals = new Vector<Principal>();
        }
        _principals.add(p);
        tmp_map.put(role, _principals);
    }

    public Iterator getRoles() {
        assert (this.roleToSubject != null);
        return this.roleToSubject.keySet().iterator();
    }

    public Enumeration getGroupsAssignedTo(Role r) {
        assert (this.roleToGroup != null);
        Vector v = (Vector)this.roleToGroup.get(r.getName());
        v = v == null ? new Vector() : v;
        return v.elements();
    }

    public Enumeration getUsersAssignedTo(Role r) {
        assert (this.roleToPrincipal != null);
        Vector v = (Vector)this.roleToPrincipal.get(r.getName());
        v = v == null ? new Vector() : v;
        return v.elements();
    }

    public void unassignRole(Role r) {
        if (r != null) {
            String role = r.getName();
            this.roleToSubject.remove(role);
            this.roleToPrincipal.remove(role);
            this.roleToGroup.remove(role);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("RoleMapper:");
        Iterator e = this.getRoles();
        while (e.hasNext()) {
            String r = (String)e.next();
            s.append("\n\tRole (" + r + ") has Principals(");
            Subject sub = (Subject)this.roleToSubject.get(r);
            for (Principal p : sub.getPrincipals()) {
                s.append(p.getName() + " ");
            }
            s.append(")");
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, s.toString());
        }
        return s.toString();
    }

    public RoleMapper(RoleMapper r) {
        this.appName = r.getName();
        Iterator it = r.getRoles();
        while (it.hasNext()) {
            String role = (String)it.next();
            Enumeration groups = r.getGroupsAssignedTo(new Role(role));
            Vector<Group> groupsToRole = new Vector<Group>();
            while (groups.hasMoreElements()) {
                Group gp = (Group)groups.nextElement();
                groupsToRole.add(new Group(gp.getName()));
                this.addRoleToPrincipal(gp, role);
            }
            this.roleToGroup.put(role, groupsToRole);
            Enumeration users = r.getUsersAssignedTo(new Role(role));
            Vector<PrincipalImpl> usersToRole = new Vector<PrincipalImpl>();
            while (users.hasMoreElements()) {
                PrincipalImpl gp = (PrincipalImpl)users.nextElement();
                usersToRole.add(new PrincipalImpl(gp.getName()));
                this.addRoleToPrincipal(gp, role);
            }
            this.roleToPrincipal.put(role, usersToRole);
        }
    }

    private static String getDefaultP2RMappingClassName() {
        if (defaultP2RMappingClassName != null) {
            return defaultP2RMappingClassName;
        }
        String className = null;
        try {
            SecurityService securityService;
            ConfigContext configContext;
            ServerContext serverContext = ApplicationServer.getServerContext();
            if (serverContext != null && (configContext = serverContext.getConfigContext()) != null && (securityService = ServerBeansFactory.getSecurityServiceBean(configContext)) != null && securityService.isActivateDefaultPrincipalToRoleMapping() && ((className = securityService.getMappedPrincipalClass()) == null || "".equals(className))) {
                className = "com.sun.enterprise.deployment.Group";
            }
            if (className == null) {
                return null;
            }
            Class<?> clazz = Class.forName(className);
            Class[] argClasses = new Class[]{String.class};
            Object[] arg = new Object[]{"anystring"};
            Constructor<?> c = clazz.getConstructor(argClasses);
            Principal principal = (Principal)c.newInstance(arg);
            return className;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "pc.getDefaultP2RMappingClass: " + e);
            return null;
        }
    }

    class DefaultRoleToSubjectMapping
    extends HashMap {
        private HashMap roleMap = new HashMap();

        DefaultRoleToSubjectMapping() {
        }

        Principal getSameNamedPrincipal(String roleName) {
            Subject subject = new Subject();
            try {
                Class<?> clazz = Class.forName(defaultP2RMappingClassName);
                Class[] argClasses = new Class[]{String.class};
                Object[] arg = new Object[]{new String(roleName)};
                Constructor<?> c = clazz.getConstructor(argClasses);
                Principal principal = (Principal)c.newInstance(arg);
                return principal;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "rm.getSameNamedPrincipal", new Object[]{roleName, e});
                throw new RuntimeException("Unable to get principal by default p2r mapping");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            assert (key instanceof String);
            HashMap hashMap = this.roleMap;
            synchronized (hashMap) {
                Subject s = (Subject)this.roleMap.get(key);
                if (s == null && key instanceof String) {
                    final Subject fs = new Subject();
                    final String roleName = (String)key;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            fs.getPrincipals().add(DefaultRoleToSubjectMapping.this.getSameNamedPrincipal(roleName));
                            return null;
                        }
                    });
                    this.roleMap.put(key, fs);
                    s = fs;
                }
                return s;
            }
        }
    }
}

