/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.audit;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public final class AuditManager {
    static final String NAME = "name";
    static final String CLASSNAME = "classname";
    private static final String AUDIT_MGR_WS_INVOCATION_KEY = "auditmgr.webServiceInvocation";
    private static final String AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY = "auditmgr.ejbAsWebServiceInvocation";
    private static final String AUDIT_MGR_SERVER_STARTUP_KEY = "auditmgr.serverStartup";
    private static final String AUDIT_MGR_SERVER_SHUTDOWN_KEY = "auditmgr.serverShutdown";
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(AuditManager.class);
    private List instances = Collections.synchronizedList(new ArrayList());
    private Map moduleToNameMap = new HashMap();
    private Map nameToModuleMap = new HashMap();
    private static boolean auditOn = false;

    AuditManager() {
    }

    public void loadAuditModules() {
        try {
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            assert (configContext != null);
            Server configBean = ServerBeansFactory.getServerBean(configContext);
            assert (configBean != null);
            SecurityService securityBean = ServerBeansFactory.getSecurityServiceBean(configContext);
            assert (securityBean != null);
            boolean auditFlag = securityBean.isAuditEnabled();
            this.setAuditOn(auditFlag);
            AuditModule[] am = securityBean.getAuditModule();
            for (int i = 0; i < am.length; ++i) {
                try {
                    String name = am[i].getName();
                    String classname = am[i].getClassname();
                    Properties p = new Properties();
                    p.setProperty(NAME, name);
                    p.setProperty(CLASSNAME, classname);
                    ElementProperty[] ep = am[i].getElementProperty();
                    int epsize = am[i].sizeElementProperty();
                    for (int j = 0; j < epsize; ++j) {
                        String nme = ep[j].getName();
                        String val = ep[j].getValue();
                        p.setProperty(nme, val);
                    }
                    com.sun.appserv.security.AuditModule auditModule = this.loadAuditModule(classname, p);
                    this.instances.add(auditModule);
                    this.moduleToNameMap.put(auditModule, name);
                    this.nameToModuleMap.put(name, auditModule);
                    continue;
                }
                catch (Exception ex) {
                    String msg = _localStrings.getLocalString("auditmgr.loaderror", "Audit: Cannot load AuditModule = {0}", new Object[]{am[i].getName()});
                    _logger.log(Level.WARNING, msg, ex);
                }
            }
        }
        catch (Exception e) {
            String msg = _localStrings.getLocalString("auditmgr.badinit", "Audit: Cannot load Audit Module Initialization information. AuditModules will not be loaded.");
            _logger.log(Level.WARNING, msg, e);
        }
    }

    void addAuditModule(String name, String classname, Properties props) throws Exception {
        this.removeAuditModule(name);
        com.sun.appserv.security.AuditModule am = this.loadAuditModule(classname, props);
        this.moduleToNameMap.put(am, name);
        this.nameToModuleMap.put(name, am);
        ArrayList<com.sun.appserv.security.AuditModule> list = new ArrayList<com.sun.appserv.security.AuditModule>();
        Collections.copy(this.instances, list);
        list.add(am);
        this.instances = Collections.synchronizedList(list);
    }

    void removeAuditModule(String name) {
        Object am = this.nameToModuleMap.get(name);
        if (am != null) {
            this.nameToModuleMap.remove(name);
            this.moduleToNameMap.remove(am);
            ArrayList list = new ArrayList();
            Collections.copy(this.instances, list);
            list.remove(am);
            this.instances = Collections.synchronizedList(list);
        }
    }

    com.sun.appserv.security.AuditModule getAuditModule(String name) {
        return (com.sun.appserv.security.AuditModule)this.nameToModuleMap.get(name);
    }

    private com.sun.appserv.security.AuditModule loadAuditModule(String classname, Properties props) throws Exception {
        com.sun.appserv.security.AuditModule auditModule = null;
        Class<?> am = Class.forName(classname);
        Object obj = am.newInstance();
        auditModule = (com.sun.appserv.security.AuditModule)obj;
        auditModule.init(props);
        return auditModule;
    }

    public void authentication(String user, String realm, boolean success) {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = null;
                try {
                    am = (com.sun.appserv.security.AuditModule)list.get(i);
                    am.authentication(user, realm, success);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString("auditmgr.authentication", " Audit Module {0} threw the followin exception during authentication:", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void webInvocation(String user, HttpServletRequest req, String type, boolean success) {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.webInvocation(user, req, type, success);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString("auditmgr.webinvocation", " Audit Module {0} threw the followin exception during web invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void ejbInvocation(String user, String ejb, String method, boolean success) {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.ejbInvocation(user, ejb, method, success);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString("auditmgr.ejbinvocation", " Audit Module {0} threw the followin exception during ejb invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void webServiceInvocation(String uri, String endpoint, boolean validRequest) {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.webServiceInvocation(uri, endpoint, validRequest);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void ejbAsWebServiceInvocation(String endpoint, boolean validRequest) {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.ejbAsWebServiceInvocation(endpoint, validRequest);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during ejb as web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void serverStarted() {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.serverStarted();
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_SERVER_STARTUP_KEY, " Audit Module {0} threw the following exception during server startup :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void serverShutdown() {
        if (auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.serverShutdown();
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_SERVER_SHUTDOWN_KEY, " Audit Module {0} threw the following exception during server shutdown :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    void setAuditOn(boolean auditOn) {
        AuditManager.auditOn = auditOn;
    }

    public boolean isAuditOn() {
        return auditOn;
    }
}

