/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import com.sun.enterprise.security.jauth.AuthConfig;
import com.sun.enterprise.security.jauth.AuthContext;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.jauth.ConfigParser;
import com.sun.enterprise.security.jauth.DependentCallbackHandler;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import sun.security.util.Debug;

class ConfigFile
extends AuthConfig {
    private int epoch;
    private String parserClassName;
    private ConfigParser parser;
    static final String CLIENT = "client";
    static final String SERVER = "server";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private static final String DEFAULT_PARSER_CLASS = "com.sun.enterprise.security.jauth.ConfigXMLParser";
    private static final Debug debug = Debug.getInstance("configfile", "[ConfigFile]");

    ConfigFile() throws IOException {
        String propertyValue = System.getProperty("configfile.parser");
        this.parserClassName = propertyValue == null ? DEFAULT_PARSER_CLASS : propertyValue;
        this.epoch = 1;
        this.parser = ConfigFile.loadParser(this.parserClassName);
    }

    public ClientAuthContext getClientAuthContext(String intercept, String id, AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler) throws AuthException {
        Entry[] entries = this.getEntries(intercept, id, requestPolicy, responsePolicy, CLIENT);
        if (entries == null || entries.length == 0) {
            return null;
        }
        if (handler == null) {
            handler = ConfigFile.loadDefaultCallbackHandler();
        } else if (handler instanceof DependentCallbackHandler) {
            handler = new DelegatingHandler(handler);
        }
        for (int i = 0; i < entries.length; ++i) {
            entries[i].module = ConfigFile.createModule(entries[i], handler);
        }
        return new ConfigClient(entries);
    }

    public ServerAuthContext getServerAuthContext(String intercept, String id, AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler) throws AuthException {
        Entry[] entries = this.getEntries(intercept, id, requestPolicy, responsePolicy, SERVER);
        if (entries == null || entries.length == 0) {
            return null;
        }
        if (handler == null) {
            handler = ConfigFile.loadDefaultCallbackHandler();
        } else if (handler instanceof DependentCallbackHandler) {
            handler = new DelegatingHandler(handler);
        }
        for (int i = 0; i < entries.length; ++i) {
            entries[i].module = ConfigFile.createModule(entries[i], handler);
        }
        return new ConfigServer(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws AuthException {
        ConfigParser configParser = this.parser;
        synchronized (configParser) {
            ConfigParser nextParser;
            int next = this.epoch + 1;
            try {
                nextParser = ConfigFile.loadParser(this.parserClassName);
            }
            catch (IOException ioe) {
                throw new AuthException(ioe.toString());
            }
            this.epoch = next == 0 ? 1 : next;
            this.parser = nextParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry[] getEntries(String intercept, String id, AuthPolicy requestPolicy, AuthPolicy responsePolicy, String type) {
        int i;
        AuthPolicy respP;
        HashMap configMap;
        ConfigParser configParser = this.parser;
        synchronized (configParser) {
            configMap = this.parser.getConfigMap();
        }
        if (configMap == null) {
            return null;
        }
        InterceptEntry intEntry = (InterceptEntry)configMap.get(intercept);
        if (intEntry == null || intEntry.idMap == null) {
            if (debug != null) {
                debug.println("module config has no IDs configured for [" + intercept + "]");
            }
            return null;
        }
        IDEntry idEntry = null;
        if (id == null || (idEntry = (IDEntry)intEntry.idMap.get(id)) == null) {
            String defaultID;
            if (debug != null) {
                debug.println("DD did not specify ID, or DD-specified ID for [" + intercept + "] not found in config -- " + "attempting to look for default ID");
            }
            if ((idEntry = (IDEntry)intEntry.idMap.get(defaultID = CLIENT.equals(type) ? intEntry.defaultClientID : intEntry.defaultServerID)) == null) {
                if (debug != null) {
                    debug.println("no default config ID for [" + intercept + "]");
                }
                return null;
            }
        }
        if (idEntry.type.indexOf(type) < 0) {
            if (debug != null) {
                debug.println("request type [" + type + "] does not match config type [" + idEntry.type + "]");
            }
            return null;
        }
        AuthPolicy reqP = requestPolicy != null || responsePolicy != null ? requestPolicy : idEntry.requestPolicy;
        AuthPolicy authPolicy = respP = requestPolicy != null || responsePolicy != null ? responsePolicy : idEntry.responsePolicy;
        if (reqP == null && respP == null) {
            if (debug != null) {
                debug.println("no policy applies");
            }
            return null;
        }
        Entry[] entries = new Entry[idEntry.modules.size()];
        for (i = 0; i < entries.length; ++i) {
            AppConfigurationEntry aEntry = (AppConfigurationEntry)idEntry.modules.get(i);
            entries[i] = new Entry(reqP, respP, aEntry.getLoginModuleName(), aEntry.getControlFlag(), aEntry.getOptions());
        }
        if (debug != null) {
            debug.println("getEntries found " + entries.length + " entries for: " + intercept + " -- " + id);
            for (i = 0; i < entries.length; ++i) {
                debug.println("Entry " + (i + 1) + ":" + "\n    module class: " + entries[i].getLoginModuleName() + "\n    flag: " + entries[i].getControlFlag() + "\n    options: " + entries[i].getOptions() + "\n    request policy: " + entries[i].requestPolicy + "\n    response policy: " + entries[i].responsePolicy);
            }
        }
        return entries;
    }

    private static ConfigParser loadParser(String className) throws IOException {
        try {
            final String finalClassName = className;
            final ClassLoader finalLoader = AuthConfig.getClassLoader();
            return (ConfigParser)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> c = Class.forName(finalClassName, true, finalLoader);
                    return c.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            IOException iex = new IOException(pae.getException().toString());
            iex.initCause(pae.getException());
            throw iex;
        }
    }

    private static CallbackHandler loadDefaultCallbackHandler() throws AuthException {
        try {
            final ClassLoader finalLoader = AuthConfig.getClassLoader();
            return (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String className = System.getProperty("configfile.handler");
                    if (!(className != null && className.length() != 0 || (className = Security.getProperty(ConfigFile.DEFAULT_HANDLER)) != null && className.length() != 0)) {
                        return null;
                    }
                    Class<?> c = Class.forName(className, true, finalLoader);
                    return c.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            AuthException aex = new AuthException(pae.getException().toString());
            aex.initCause(pae.getException());
            throw aex;
        }
    }

    private static Object createModule(Entry entry, CallbackHandler handler) throws AuthException {
        try {
            Object newModule = entry.newInstance();
            Object[] initArgs = new Object[]{entry.getRequestPolicy(), entry.getResponsePolicy(), handler, entry.getOptions()};
            boolean foundOne = false;
            Method[] mArray = newModule.getClass().getMethods();
            for (int i = 0; i < mArray.length; ++i) {
                if (!mArray[i].getName().equals("initialize")) continue;
                mArray[i].invoke(newModule, initArgs);
                foundOne = true;
                break;
            }
            if (foundOne) {
                return newModule;
            }
            throw new SecurityException("could not find initialize method in module");
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                throw (AuthException)e;
            }
            AuthException ae = new AuthException();
            ae.initCause(e);
            throw ae;
        }
    }

    private class DelegatingHandler
    implements CallbackHandler {
        CallbackHandler handler;
        CallbackHandler defaultHandler;

        private DelegatingHandler(CallbackHandler cbh) {
            this.handler = cbh;
            try {
                this.defaultHandler = ConfigFile.loadDefaultCallbackHandler();
            }
            catch (Exception e) {
                this.defaultHandler = null;
            }
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (this.defaultHandler == null) {
                this.handler.handle(callbacks);
            } else {
                Callback[] oneCallback = new Callback[1];
                for (int i = 0; i < callbacks.length; ++i) {
                    boolean tryDefault = false;
                    oneCallback[0] = callbacks[i];
                    try {
                        this.handler.handle(oneCallback);
                    }
                    catch (UnsupportedCallbackException uce) {
                        tryDefault = true;
                    }
                    if (!tryDefault) continue;
                    this.defaultHandler.handle(oneCallback);
                }
            }
        }
    }

    private static class ConfigServer
    implements ServerAuthContext {
        private AuthContext context;
        private static final Debug debug = Debug.getInstance("configserver", "[ConfigServer]");

        ConfigServer(Entry[] entries) throws AuthException {
            this.context = new AuthContext(entries, debug);
        }

        public void validateRequest(AuthParam param, Subject subject, Map sharedState) throws AuthException {
            Object[] args = new Object[]{param, subject, sharedState};
            this.context.invoke("validateRequest", args);
        }

        public void secureResponse(AuthParam param, Subject subject, Map sharedState) throws AuthException {
            Object[] args = new Object[]{param, subject, sharedState};
            this.context.invoke("secureResponse", args);
        }

        public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
            Object[] args = new Object[]{subject, sharedState};
            this.context.invoke("disposeSubject", args);
        }

        public boolean managesSessions(Map sharedState) throws AuthException {
            Object[] rValues;
            block3: {
                Object[] args = new Object[]{sharedState};
                rValues = null;
                try {
                    rValues = this.context.invoke("managesSessions", args);
                }
                catch (AuthException ae) {
                    if (ae.getCause() instanceof NoSuchMethodException) break block3;
                    throw ae;
                }
            }
            boolean rvalue = false;
            for (int i = 0; rValues != null && i < rValues.length; ++i) {
                if (rValues[i] == null) continue;
                boolean thisValue = (Boolean)rValues[i];
                rvalue |= thisValue;
            }
            return rvalue;
        }
    }

    private static class ConfigClient
    implements ClientAuthContext {
        private AuthContext context;
        private static final Debug debug = Debug.getInstance("configclient", "[ConfigClient]");

        ConfigClient(Entry[] entries) throws AuthException {
            this.context = new AuthContext(entries, debug);
        }

        public void secureRequest(AuthParam param, Subject subject, Map sharedState) throws AuthException {
            Object[] args = new Object[]{param, subject, sharedState};
            this.context.invoke("secureRequest", args);
        }

        public void validateResponse(AuthParam param, Subject subject, Map sharedState) throws AuthException {
            Object[] args = new Object[]{param, subject, sharedState};
            this.context.invoke("validateResponse", args);
        }

        public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
            Object[] args = new Object[]{subject, sharedState};
            this.context.invoke("disposeSubject", args);
        }
    }

    static class IDEntry {
        private String type;
        private AuthPolicy requestPolicy;
        private AuthPolicy responsePolicy;
        private ArrayList modules;

        IDEntry(String type, AuthPolicy requestPolicy, AuthPolicy responsePolicy, ArrayList modules) {
            this.type = type;
            this.modules = modules;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
        }

        IDEntry(String type, String requestPolicy, String responsePolicy, ArrayList modules) {
            this.type = type;
            if (requestPolicy != null) {
                this.requestPolicy = new AuthPolicy(1, true, true);
            }
            if (responsePolicy != null) {
                this.responsePolicy = new AuthPolicy(2, true, false);
            }
            this.modules = modules;
        }
    }

    static class InterceptEntry {
        String defaultClientID;
        String defaultServerID;
        HashMap idMap;

        InterceptEntry(String defaultClientID, String defaultServerID, HashMap idMap) {
            this.defaultClientID = defaultClientID;
            this.defaultServerID = defaultServerID;
            this.idMap = idMap;
        }
    }

    static class Entry
    extends AppConfigurationEntry {
        private static final Class[] PARAMS = new Class[0];
        private static final Object[] ARGS = new Object[0];
        private AuthPolicy requestPolicy;
        private AuthPolicy responsePolicy;
        Object module;

        Entry(AuthPolicy requestPolicy, AuthPolicy responsePolicy, String moduleClass, AppConfigurationEntry.LoginModuleControlFlag flag, Map options) {
            super(moduleClass, flag, options);
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
        }

        AuthPolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        AuthPolicy getResponsePolicy() {
            return this.responsePolicy;
        }

        Object newInstance() throws AuthException {
            try {
                ClassLoader finalLoader = AuthConfig.getClassLoader();
                String clazz = this.getLoginModuleName();
                Class<?> c = Class.forName(clazz, true, finalLoader);
                Constructor<?> constructor = c.getConstructor(PARAMS);
                return constructor.newInstance(ARGS);
            }
            catch (Exception e) {
                AuthException ae = new AuthException();
                ae.initCause(e);
                throw ae;
            }
        }
    }
}

