/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanException;

public class ApplicationLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private boolean isForceDeploy = false;

    public ApplicationLoader(String appID, ClassLoader parentClassLoader, AppsManager appsManager) {
        super(appID, parentClassLoader, appsManager);
        boolean createClassLoader = true;
        try {
            boolean finishLoading;
            this.application = appsManager.getRegisteredDescriptor(appID);
            boolean bl = finishLoading = this.application == null;
            if (this.application == null) {
                this.application = appsManager.getAppDescriptor(appID, parentClassLoader);
                createClassLoader = false;
            } else {
                try {
                    ClassLoader clazzloader = this.application.getClassLoader();
                    if (clazzloader != null && clazzloader instanceof EJBClassLoader && !((EJBClassLoader)clazzloader).isDone()) {
                        createClassLoader = false;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (createClassLoader) {
                String[] classPath = EJBClassPathUtils.getAppClasspath(this.application, appsManager).toArray(new String[0]);
                this.initializeLoader(classPath, appsManager.getLocation(this.application.getRegistrationName()), ModuleType.EAR);
                this.application.setClassLoader(this.ejbClassLoader);
            } else {
                this.initializeLoader(this.application.getClassLoader());
            }
            if (finishLoading) {
                this.application = appsManager.getAppDescriptor(this.application);
            }
            this.initializeRegistry();
        }
        catch (Exception confEx) {
            _logger.log(Level.SEVERE, "ERROR while loading application " + appID);
            _logger.log(Level.SEVERE, "loader.error_while_loading_app_desc", confEx);
        }
    }

    boolean load(boolean jsr77) {
        boolean allModulesDeployed = false;
        if (this.loadUnloadAction == 0) {
            this.loadUnloadAction = 1;
        }
        if (this.loadUnloadAction == 1 || this.loadUnloadAction == 2) {
            this.notifyAppEvent(0);
            allModulesDeployed = this.loadRars(jsr77);
            if (this.loadUnloadAction == 2) {
                return allModulesDeployed;
            }
        }
        if (!(allModulesDeployed = this.loadPersistenceUnits())) {
            return false;
        }
        if (allModulesDeployed) {
            allModulesDeployed = this.loadEjbs(jsr77);
            this.notifyAppEvent(1);
        }
        if (!allModulesDeployed) {
            this.unloadPersistenceUnits();
            return allModulesDeployed;
        }
        this.loadWebserviceEndpoints(jsr77);
        return allModulesDeployed;
    }

    boolean unload(boolean jsr77) {
        if (this.loadUnloadAction == 0) {
            this.loadUnloadAction = 4;
        }
        boolean wsUnloaded = false;
        boolean ejbUnloaded = false;
        boolean pusUnloaded = false;
        if (this.loadUnloadAction == 4 || this.loadUnloadAction == 6) {
            this.notifyAppEvent(2);
            wsUnloaded = this.unloadWebserviceEndpoints(jsr77);
            ejbUnloaded = this.unloadEjbs(jsr77);
            pusUnloaded = this.unloadPersistenceUnits();
            if (this.loadUnloadAction == 6) {
                return wsUnloaded && ejbUnloaded && pusUnloaded;
            }
        }
        boolean rarUnloaded = this.unloadRars(jsr77);
        this.configManager.unregisterDescriptor(this.id);
        this.notifyAppEvent(3);
        this.done();
        if (this.loadUnloadAction == 5) {
            return rarUnloaded;
        }
        return wsUnloaded && ejbUnloaded && pusUnloaded && rarUnloaded;
    }

    void createRootMBean() throws MBeanException {
        try {
            Switch.getSwitch().getManagementObjectManager().createAppMBean(this.application, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
            Switch.getSwitch().getManagementObjectManager().createAppMBeanModules(this.application, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    void deleteRootMBean() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().deleteAppMBean(this.application, this.configManager.getInstanceEnvironment().getName());
    }

    void createLeafMBeans() throws MBeanException {
        try {
            Switch.getSwitch().getManagementObjectManager().createAppMBeans(this.application, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    void createLeafMBean(Descriptor descriptor) throws MBeanException {
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = null;
            try {
                ejbDescriptor = (EjbDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().createEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
        } else if (descriptor instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd = null;
            try {
                cd = (ConnectorDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().createRARMBean(cd, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void deleteLeafMBean(Descriptor descriptor) throws MBeanException {
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = null;
            try {
                ejbDescriptor = (EjbDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().deleteEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
        } else if (descriptor instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd = null;
            try {
                cd = (ConnectorDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().deleteRARMBean(cd, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void deleteLeafMBeans() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().deleteAppMBeans(this.application, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafAndRootMBeans() throws MBeanException {
        this.deleteLeafMBeans();
        this.deleteRootMBean();
    }

    void setState(int state) throws MBeanException {
        if (this.application == null) {
            _logger.log(Level.FINE, "Application descriptor is NULL. setState skipped");
        } else {
            Switch.getSwitch().getManagementObjectManager().setApplicationState(state, this.application, this.configManager.getInstanceEnvironment().getName());
        }
    }

    public boolean isForceDeploy() {
        return this.isForceDeploy;
    }

    public void setForceDeploy(boolean isForceDeploy) {
        this.isForceDeploy = isForceDeploy;
    }
}

