/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static final String DEFAULT_PROVIDER_NAME = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String DEFAULT_DS_NAME = "jdbc/__default";
    private static String defaultProvider;
    private static Logger logger;
    private PersistenceUnitDescriptor persistenceUnitDescriptor;
    private String applicationLocation;
    private File absolutePuRootFile;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private List<URL> jarFiles;
    private InstrumentableClassLoader classLoader;

    public PersistenceUnitInfoImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, String applicationLocation, InstrumentableClassLoader classLoader) {
        this.persistenceUnitDescriptor = persistenceUnitDescriptor;
        this.applicationLocation = applicationLocation;
        this.classLoader = classLoader;
        this.jarFiles = this._getJarFiles();
        this.jtaDataSource = this._getJtaDataSource();
        this.nonJtaDataSource = this._getNonJtaDataSource();
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitDescriptor.getName();
    }

    public String getPersistenceProviderClassName() {
        return PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc(this.persistenceUnitDescriptor);
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.valueOf((String)this.persistenceUnitDescriptor.getTransactionType());
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public URL getPersistenceUnitRootUrl() {
        try {
            return this.getAbsolutePuRootFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getMappingFileNames() {
        return this.persistenceUnitDescriptor.getMappingFiles();
    }

    public List<URL> getJarFileUrls() {
        return this.jarFiles;
    }

    public List<String> getManagedClassNames() {
        return this.persistenceUnitDescriptor.getClasses();
    }

    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitDescriptor.isExcludeUnlistedClasses();
    }

    public Properties getProperties() {
        return this.persistenceUnitDescriptor.getProperties();
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)ClassLoader.class.cast(this.classLoader);
    }

    public void addTransformer(ClassTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.classLoader.copy();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("<persistence-unit>");
        result.append("\n\t<PURoot>" + this.getPersistenceUnitRootUrl() + "</PURoot>");
        result.append("\n\t<name>" + this.getPersistenceUnitName() + "</name>");
        result.append("\n\t<provider>" + this.getPersistenceProviderClassName() + "</provider>");
        result.append("\n\t<transaction-type>" + this.getTransactionType() + "</transaction-type>");
        result.append("\n\t<jta-data-source>" + this.getJtaDataSource() + "</jta-data-source>");
        result.append("\n\t<non-jta-data-source>" + this.getNonJtaDataSource() + "</non-jta-data-source>");
        for (URL jar : this.getJarFileUrls()) {
            result.append("\n\t<jar-file>" + jar + "</jar-file>");
        }
        for (String mappingFile : this.getMappingFileNames()) {
            result.append("\n\t<mapping-file>" + mappingFile + "</mapping-file>");
        }
        for (String clsName : this.getManagedClassNames()) {
            result.append("\n\t<class-name>" + clsName + "</class-name>");
        }
        result.append("\n\t<exclude-unlisted-classes>" + this.excludeUnlistedClasses() + "</exclude-unlisted-classes>");
        result.append("\n\t<properties>" + this.getProperties() + "</properties>");
        result.append("\n\t<class-loader>" + this.getClassLoader() + "</class-loader>");
        result.append("\n</persistence-unit>\n");
        return result.toString();
    }

    protected DataSource _getJtaDataSource() {
        if (this.getTransactionType() != PersistenceUnitTransactionType.JTA) {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getJtaDataSource", "This PU is configured as non-jta, so jta-data-source is null");
            return null;
        }
        String userSuppliedJTADSName = this.persistenceUnitDescriptor.getJtaDataSource();
        String DSName = !PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedJTADSName) ? userSuppliedJTADSName : DEFAULT_DS_NAME;
        try {
            logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "_getJtaDataSource", "JTADSName = {0}", DSName);
            return (DataSource)DataSource.class.cast(ConnectorRuntime.getRuntime().lookupPMResource(DSName));
        }
        catch (NamingException e) {
            logger.log(Level.SEVERE, "Error looking up jta-datasource by name : " + DSName, e);
            throw new RuntimeException(e);
        }
    }

    protected DataSource _getNonJtaDataSource() {
        String userSuppliedJTADSName;
        String userSuppliedNonJTADSName = this.persistenceUnitDescriptor.getNonJtaDataSource();
        String DSName = !PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedNonJTADSName) ? userSuppliedNonJTADSName : (!PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedJTADSName = this.persistenceUnitDescriptor.getJtaDataSource()) ? userSuppliedJTADSName : DEFAULT_DS_NAME);
        try {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getNonJtaDataSource", "nonJTADSName = {0}", DSName);
            return (DataSource)DataSource.class.cast(ConnectorRuntime.getRuntime().lookupNonTxResource(DSName));
        }
        catch (NamingException e) {
            logger.log(Level.SEVERE, "Error looking up non-jta-datasource by name : " + DSName, e);
            throw new RuntimeException(e);
        }
    }

    private List<URL> _getJarFiles() {
        ArrayList<String> jarFileNames = new ArrayList<String>(this.persistenceUnitDescriptor.getJarFiles());
        ArrayList<URL> jarFiles = new ArrayList<URL>(jarFileNames.size() + 1);
        String absolutePuRoot = this.getAbsolutePuRootFile().getAbsolutePath();
        for (String jarFileName : jarFileNames) {
            String nativeJarFileName = jarFileName.replace('/', File.separatorChar);
            File parentFile = new File(absolutePuRoot).getParentFile();
            File jarFile = new File(parentFile, nativeJarFileName);
            if (!jarFile.exists()) {
                String pathComponent = "";
                String nameComponent = jarFileName;
                if (jarFileName.lastIndexOf("../") != -1) {
                    int separatorIndex = jarFileName.lastIndexOf("../") + 3;
                    pathComponent = jarFileName.substring(0, separatorIndex);
                    nameComponent = jarFileName.substring(separatorIndex);
                }
                logger.fine("For jar-file=" + jarFileName + ", " + "pathComponent=" + pathComponent + ", nameComponent=" + nameComponent);
                jarFile = new File(new File(parentFile, pathComponent), FileUtils.makeFriendlyFileName(nameComponent));
            }
            if (jarFile.exists()) {
                try {
                    jarFiles.add(jarFile.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            logger.logp(Level.WARNING, "PersistenceUnitInfoImpl", "initJarFiles", "For pu-root {0}, \na jar-file specified in persistence.xml is not found.\nOriginal name = {1}, and looked up name = {2}.", new Object[]{absolutePuRoot, jarFileName, jarFile});
        }
        return jarFiles;
    }

    private File getAbsolutePuRootFile() {
        if (this.absolutePuRootFile == null) {
            this.absolutePuRootFile = new File(this.applicationLocation, this.persistenceUnitDescriptor.getAbsolutePuRoot().replace('/', File.separatorChar));
            if (!this.absolutePuRootFile.exists()) {
                throw new RuntimeException(this.absolutePuRootFile.getAbsolutePath() + " does not exist!");
            }
        }
        return this.absolutePuRootFile;
    }

    private static String getDefaultprovider() {
        String DEFAULT_PERSISTENCE_PROVIDER_PROPERTY = "com.sun.persistence.defaultProvider";
        if (defaultProvider == null) {
            defaultProvider = System.getProperty("com.sun.persistence.defaultProvider", DEFAULT_PROVIDER_NAME);
        }
        return defaultProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createJar(String sourcePath, String destinationPath) throws IOException {
        FileArchive source = new FileArchive();
        OutputJarArchive destination = new OutputJarArchive();
        try {
            source.open(sourcePath);
            destination.create(destinationPath);
            Enumeration entries = source.entries();
            while (entries.hasMoreElements()) {
                OutputStream os;
                block7: {
                    Object var9_8;
                    String entry = (String)String.class.cast(entries.nextElement());
                    InputStream is = null;
                    os = null;
                    try {
                        is = source.getEntry(entry);
                        os = destination.putNextEntry(entry);
                        ArchivistUtils.copyWithoutClose(is, os);
                        var9_8 = null;
                        if (is == null) break block7;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            destination.closeEntry();
                        }
                        throw throwable;
                    }
                    is.close();
                }
                if (os == null) continue;
                destination.closeEntry();
                {
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            source.close();
            destination.close();
            throw throwable;
        }
        source.close();
        destination.close();
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getPersistenceProviderClassNameForPuDesc(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String provider = persistenceUnitDescriptor.getProvider();
        if (PersistenceUnitInfoImpl.isNullOrEmpty(provider)) {
            provider = PersistenceUnitInfoImpl.getDefaultprovider();
        }
        return provider;
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    }
}

