/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.iiop.ORBMonitoring;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ondemand.OnDemandServer;
import com.sun.enterprise.server.ondemand.ServiceGroup;
import com.sun.enterprise.server.ondemand.ServiceGroupException;
import com.sun.enterprise.server.ondemand.SystemAppLoader;
import com.sun.enterprise.server.ondemand.entry.EntryContext;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.jta.TransactionManagerImpl;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class EjbServiceGroup
extends ServiceGroup {
    public static final String J2EE_APPNAME = "com.sun.enterprise.appname";
    public static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    public static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    private static final boolean debug = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(J2EEServer.class);
    private static final int DEFAULT_SERVER_ID = 100;
    private final String MEJB_JNDI_NAME = "ejb/mgmt/MEJB";
    private File repositoryDir;
    private int orbInitialPort;
    private ORB orb;
    private ProtocolManager protocolMgr;

    public void start(EntryContext context) throws ServiceGroupException {
        this._start(context);
        if (context.getEntryPointType() != 5) {
            this.loadSystemApps();
        }
    }

    private void _start(EntryContext context) throws ServiceGroupException {
        ServerContext serverContext = context.getServerContext();
        String[] args = serverContext.getCmdLineArgs();
        if (args == null) {
            args = new String[]{};
        }
        try {
            this.startORB(args);
            J2EETransactionManagerImpl.createJTSTransactionManager();
        }
        catch (Exception e) {
            throw new ServiceGroupException(e);
        }
    }

    public void stop(EntryContext context) throws ServiceGroupException {
        super.stopLifecycleServices();
    }

    public void abort(EntryContext context) {
        super.stopLifecycleServices();
    }

    private void loadSystemApps() {
        SystemAppLoader loader = OnDemandServer.getSystemAppLoader();
        loader.loadSystemApps(loader.getEjbServiceGroupSystemApps());
    }

    public boolean analyseEntryContext(EntryContext context) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Analysing the context in EJB ServiceGroup :" + context);
        }
        boolean result = false;
        try {
            ConfigContext ctxt = context.getServerContext().getConfigContext();
            Config conf = ServerBeansFactory.getConfigBean(ctxt);
            if (context.getEntryPointType() == 5) {
                boolean onDemandStartup = (Boolean)context.get();
                if (!onDemandStartup) {
                    result = true;
                }
            } else if (context.get() == null) {
                return false;
            }
            if (context.getEntryPointType() == 2) {
                Descriptor desc = (Descriptor)context.get();
                if (desc instanceof Application) {
                    Application app = (Application)desc;
                    if (app.getEjbComponentCount() > 0) {
                        result = true;
                    } else {
                        for (ConnectorDescriptor cd : app.getRarDescriptors()) {
                            String raClass;
                            if (ResourcesUtil.getInstance().belongToSystemRar(cd.getName()) || (raClass = cd.getResourceAdapterClass()) == null || raClass.trim().equals("")) continue;
                            result = true;
                            break;
                        }
                    }
                } else if (desc instanceof ConnectorDescriptor) {
                    String raClass;
                    ConnectorDescriptor cd = (ConnectorDescriptor)desc;
                    if (!ResourcesUtil.getInstance().belongToSystemRar(cd.getName()) && (raClass = cd.getResourceAdapterClass()) != null && !raClass.trim().equals("")) {
                        result = true;
                    }
                } else {
                    boolean bl = result = desc instanceof EjbBundleDescriptor || desc instanceof EjbAbstractDescriptor;
                }
            }
            if (context.getEntryPointType() == 3) {
                String jndiName = (String)context.get();
                String JAVA = "java";
                String COMP = "comp";
                String ENV = "env";
                int minSize = (JAVA + ":" + COMP + "/" + ENV).length();
                String txMgr = "java:appserver/TransactionManager";
                if (jndiName.equals(txMgr)) {
                    return true;
                }
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.log(Level.FINER, "Jndi name being analysed is :" + jndiName);
                }
                if (jndiName.length() > minSize && jndiName.startsWith(JAVA) && (jndiName = jndiName.substring(JAVA.length() + 1)).startsWith(COMP) && (jndiName = jndiName.substring(COMP.length() + 1)).startsWith(ENV)) {
                    jndiName = jndiName.substring(ENV.length() + 1);
                }
                result = jndiName.equalsIgnoreCase("ejb/mgmt/MEJB") ? true : this.isXAResource(jndiName, ctxt);
            }
            if (context.getEntryPointType() == 4) {
                result = this.analyseObjectName((ObjectName)context.get());
            }
            if (context.getEntryPointType() == 1) {
                IiopService iiopService = conf.getIiopService();
                IiopListener[] iiopListeners = iiopService.getIiopListener();
                for (int i = 0; i < iiopListeners.length; ++i) {
                    int port = Integer.parseInt(iiopListeners[i].getPort());
                    if (port != (Integer)context.get()) continue;
                    result = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private boolean isXAResource(String jndiName, ConfigContext conf) {
        try {
            ConfigBean res = ResourceHelper.findResource(conf, jndiName);
            if (res != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Got the resource :" + res);
                }
                if (res instanceof JdbcResource) {
                    String poolName = ((JdbcResource)res).getPoolName();
                    JdbcConnectionPool pool = (JdbcConnectionPool)ResourceHelper.findResource(conf, poolName);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Got the Pool :" + pool);
                    }
                    return pool.getResType() != null && pool.getResType().equals("javax.sql.XADataSource");
                }
                if (res instanceof ConnectorResource) {
                    String txSupport;
                    String poolName = ((ConnectorResource)res).getPoolName();
                    Resources root = ((Domain)conf.getRootConfigBean()).getResources();
                    ConnectorConnectionPool pool = root.getConnectorConnectionPoolByName(poolName);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Got the Pool :" + pool);
                    }
                    return (txSupport = pool.getTransactionSupport()) == null || txSupport.trim().equals("") || txSupport.trim().equals("XATransaction");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private boolean analyseObjectName(ObjectName name) {
        String nameStr = name.getKeyProperty("name");
        String ref = name.getKeyProperty("ref");
        String app = name.getKeyProperty("J2EEApplication");
        return this.belongsToThisServiceGroup(nameStr) || this.belongsToThisServiceGroup(ref) || this.belongsToThisServiceGroup(app);
    }

    private boolean belongsToThisServiceGroup(String name) {
        SystemAppLoader appLoader = OnDemandServer.getSystemAppLoader();
        if (appLoader != null) {
            for (java.lang.Object n : appLoader.getEjbServiceGroupSystemApps()) {
                if (!((String)n).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void startORB(String[] args) {
        try {
            Properties jtsProperties;
            try {
                Properties props = System.getProperties();
                props.setProperty(J2EE_APPNAME, "j2ee");
                jtsProperties = EjbServiceGroup.initJTSProperties(true);
                this.orb = this.createORB();
                try {
                    Object obj = this.orb.resolve_initial_references("RootPOA");
                }
                catch (InvalidName in) {
                    _logger.log(Level.SEVERE, "enterprise.orb_reference_exception", in);
                }
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.createorb_exception", ex.toString());
                }
                _logger.log(Level.FINEST, "Exception while creating ORB: ", ex);
                throw new RuntimeException("Unable to create ORB");
            }
            if (Switch.getSwitch().getContainerType() == 2) {
                new ORBMonitoring(this.orb);
            }
            Switch theSwitch = Switch.getSwitch();
            this.protocolMgr = new POAProtocolMgr(this.orb);
            theSwitch.setProtocolManager(this.protocolMgr);
            this.protocolMgr.initializeNaming(this.repositoryDir, this.orbInitialPort);
            ((POAProtocolMgr)this.protocolMgr).initializePOAs();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.naming", "Naming service started: ") + this.orbInitialPort);
            }
            try {
                Switch.getSwitch().getProviderManager().initRemoteProvider();
            }
            catch (RemoteException re) {
                _logger.log(Level.WARNING, "init.remote.provider", re);
            }
            PEORBConfigurator.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService", jtsProperties);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2eeservice_running_exception", ex.toString());
            }
            _logger.log(Level.FINEST, "Exception running j2ee services", ex);
            Log.err.flush();
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private ORB createORB() throws Exception {
        ORB orb = ORBManager.getORB();
        this.orbInitialPort = ORBManager.getORBInitialPort();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("j2ee.listenPort", "J2EE server listen port: ") + this.orbInitialPort);
        }
        return orb;
    }

    public static Properties initJTSProperties(boolean lateRegistration) {
        Properties props = new Properties();
        if (!lateRegistration) {
            props.put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        }
        Configuration.setAsAppClientConatiner(false);
        ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
        TransactionService txnService = null;
        try {
            IiopListener iiopListener;
            txnService = ServerBeansFactory.getTransactionServiceBean(ctx);
            props.put("com.sun.jts.heuristicDirection", txnService.getHeuristicDecision());
            props.put("com.sun.jts.keypointCount", txnService.getKeypointInterval());
            if (txnService.isAutomaticRecovery()) {
                _logger.log(Level.FINE, "Recoverable J2EE Server");
                props.put("com.sun.jts.ManualRecovery", "true");
            }
            boolean disable_distributed_transaction_logging = false;
            String dbLoggingResource = null;
            ElementProperty[] eprops = txnService.getElementProperty();
            for (int index = 0; index < eprops.length; ++index) {
                if ("disable-distributed-transaction-logging".equals(eprops[index].getName())) {
                    if (!"true".equals(eprops[index].getValue())) {
                        disable_distributed_transaction_logging = false;
                        continue;
                    }
                    disable_distributed_transaction_logging = true;
                    continue;
                }
                if ("xaresource-txn-timeout".equals(eprops[index].getName())) {
                    String value = eprops[index].getValue();
                    _logger.log(Level.FINE, "XAResource transaction timeout is" + value);
                    if (value == null) continue;
                    TransactionManagerImpl.setXAResourceTimeOut(Integer.parseInt(value));
                    continue;
                }
                if (!"db-logging-resource".equals(eprops[index].getName())) continue;
                dbLoggingResource = eprops[index].getValue();
                _logger.log(Level.FINE, "Transaction DB Logging Resource Name" + dbLoggingResource);
                if (dbLoggingResource != null && !" ".equals(dbLoggingResource)) continue;
                dbLoggingResource = "jdbc/TxnDS";
            }
            if (dbLoggingResource != null) {
                disable_distributed_transaction_logging = true;
                props.put("com.sun.jts.logResource", dbLoggingResource);
            }
            String jtsServerId = String.valueOf(100);
            IiopService iiopServiceBean = ServerBeansFactory.getIiopServiceBean(ctx);
            if (iiopServiceBean != null && (iiopListener = iiopServiceBean.getIiopListener(0)) != null) {
                jtsServerId = iiopListener.getPort();
            }
            props.put(JTS_SERVER_ID, jtsServerId);
            String serverId = String.valueOf(100);
            System.setProperty(J2EE_SERVER_ID_PROP, serverId);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "++++ Server id: " + props.getProperty("com.sun.corba.ee.POA.ORBServerId"));
            }
            if (!txnService.isAutomaticRecovery() && disable_distributed_transaction_logging) {
                Configuration.disableFileLogging();
            }
            if (dbLoggingResource == null) {
                Domain svr;
                String logdir = txnService.getTxLogDir();
                if (logdir == null) {
                    svr = null;
                    svr = ServerBeansFactory.getDomainBean(ctx);
                    logdir = svr.getLogRoot();
                    if (logdir == null) {
                        logdir = FileUtil.getAbsolutePath(".." + File.separator + "logs");
                    }
                } else if (!new File(logdir).isAbsolute()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "enterprise.relative_tx_log_dir", logdir);
                    }
                    svr = null;
                    svr = ServerBeansFactory.getDomainBean(ctx);
                    String logroot = svr.getLogRoot();
                    logdir = logroot != null ? logroot + File.separator + logdir : FileUtil.getAbsolutePath(".." + File.separator + "logs" + File.separator + logdir);
                }
                String instanceName = ApplicationServer.getServerContext().getInstanceName();
                logdir = logdir + File.separator + instanceName + File.separator + "tx";
                _logger.log(Level.FINE, "JTS log directory: " + logdir);
                _logger.log(Level.FINE, "JTS Server id " + jtsServerId);
                new File(logdir).mkdirs();
                props.put("com.sun.jts.logDirectory", logdir);
            }
            props.put("com.sun.jts.commitRetry", txnService.getRetryTimeoutInSeconds());
        }
        catch (ConfigException e) {
            throw new RuntimeException("Error reading configuration : " + e);
        }
        Configuration.setProperties(props);
        return props;
    }
}

