/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.provider.ASSelector;
import com.sun.enterprise.server.ss.provider.ASServerSocketChannel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;

public class ASSelectorProvider
extends SelectorProvider {
    public static final int PORT_UNBOUND = 0;
    public static final int PORT_BOUND = 1;
    public static final int PORT_CONFLICT = 2;
    private SelectorProvider provider = null;
    private HashMap<Integer, Integer> statemap = new HashMap();
    private HashMap<Integer, ServerSocket> socketmap = new HashMap();

    public ASSelectorProvider() {
        this.provider = this.getProvider();
    }

    public DatagramChannel openDatagramChannel() throws IOException {
        return this.provider.openDatagramChannel();
    }

    public Pipe openPipe() throws IOException {
        return this.provider.openPipe();
    }

    public ServerSocketChannel openServerSocketChannel() throws IOException {
        ServerSocketChannel ssc = this.provider.openServerSocketChannel();
        return new ASServerSocketChannel(ssc, this);
    }

    public SocketChannel openSocketChannel() throws IOException {
        return this.provider.openSocketChannel();
    }

    public AbstractSelector openSelector() throws IOException {
        AbstractSelector sel = this.provider.openSelector();
        return new ASSelector(sel, this);
    }

    ServerSocket getServerSocket(int port) {
        return this.socketmap.get(port);
    }

    int getPortState(int port) {
        Integer i = this.statemap.get(port);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void setPortState(int port, int state) {
        this.statemap.put(port, state);
    }

    public void clear(int port) {
        this.statemap.remove(port);
        this.socketmap.remove(port);
    }

    void setServerSocket(ServerSocket ss, int port) {
        int state = this.getPortState(port);
        if (state == 0) {
            this.socketmap.put(port, ss);
            this.setPortState(port, 1);
        } else if (state == 1) {
            this.setPortState(port, 2);
        }
    }

    private SelectorProvider getProvider() {
        SelectorProvider sp = null;
        try {
            Class<?> clazz = Class.forName("sun.nio.ch.DefaultSelectorProvider");
            Method createMeth = clazz.getMethod("create", new Class[0]);
            sp = (SelectorProvider)createMeth.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create default SelectorProvider.", e);
        }
        return sp;
    }
}

