/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class SpecVersionMapper {
    private static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    public static final String JavaEEVersion_1_2 = "1.2";
    public static final String JavaEEVersion_1_3 = "1.3";
    public static final String JavaEEVersion_1_4 = "1.4";
    public static final String JavaEEVersion_5 = "5";
    private static String[][] PlatformVersionToEJBVersionMap = new String[][]{{"1.2", "1.1"}, {"1.3", "2.0"}, {"1.4", "2.1"}, {"5", "3.0"}};
    private static String[][] PlatformVersionToAppClientVersionMap = new String[][]{{"1.2", "1.2"}, {"1.3", "1.3"}, {"1.4", "1.4"}, {"5", "5"}};
    private static String[][] PlatformVersionToJCAVersionMap = new String[][]{{"1.3", "1.0"}, {"1.4", "1.5"}, {"5", "1.5"}};
    private static String[][] PlatformVersionToWebAppVersionMap = new String[][]{{"1.2", "2.2"}, {"1.3", "2.3"}, {"1.4", "2.4"}, {"5", "2.5"}};
    private static String[][] PlatformVersionToWebServiceVersionMap = new String[][]{{"1.4", "1.1"}, {"5", "1.2"}};
    private static String[][] PlatformVersionToWebServiceClientVersionMap = new String[][]{{"1.4", "1.1"}, {"5", "1.2"}};

    private static String throwException(String platformVersion) throws IllegalArgumentException {
        throw new IllegalArgumentException(smh.getLocalString("com.sun.enterprise.tools.verifier.SpecVersionMapper.exception", "Not able to map platform version [ {0} ] component version.", new Object[]{platformVersion}));
    }

    public static String getEJBVersion(String platformVersion) throws IllegalArgumentException {
        for (String[] row : PlatformVersionToEJBVersionMap) {
            if (!row[0].equals(platformVersion)) continue;
            return row[1];
        }
        return SpecVersionMapper.throwException(platformVersion);
    }

    public static String getJCAVersion(String platformVersion) throws IllegalArgumentException {
        for (String[] row : PlatformVersionToJCAVersionMap) {
            if (!row[0].equals(platformVersion)) continue;
            return row[1];
        }
        return SpecVersionMapper.throwException(platformVersion);
    }

    public static String getWebAppVersion(String platformVersion) throws IllegalArgumentException {
        for (String[] row : PlatformVersionToWebAppVersionMap) {
            if (!row[0].equals(platformVersion)) continue;
            return row[1];
        }
        return SpecVersionMapper.throwException(platformVersion);
    }

    public static String getAppClientVersion(String platformVersion) throws IllegalArgumentException {
        for (String[] row : PlatformVersionToAppClientVersionMap) {
            if (!row[0].equals(platformVersion)) continue;
            return row[1];
        }
        return SpecVersionMapper.throwException(platformVersion);
    }

    public static String getWebServiceVersion(String platformVersion) throws IllegalArgumentException {
        for (String[] row : PlatformVersionToWebServiceVersionMap) {
            if (!row[0].equals(platformVersion)) continue;
            return row[1];
        }
        return SpecVersionMapper.throwException(platformVersion);
    }

    public static String getWebServiceClientVersion(String platformVersion) {
        for (String[] row : PlatformVersionToWebServiceClientVersionMap) {
            if (!row[0].equals(platformVersion)) continue;
            return row[1];
        }
        return SpecVersionMapper.throwException(platformVersion);
    }
}

