/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.stdapis;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.APIRepository;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

public class ConnectorClosureCompiler
extends ClosureCompilerImpl {
    private static Logger logger = Logger.getLogger("apiscan.stdapis");
    private static final String myClassName = "ConnectorClosureCompiler";
    private String specVersion;

    public ConnectorClosureCompiler(String specVersion, ClassFileLoader cfl) {
        super(cfl);
        logger.entering(myClassName, "init<>", specVersion);
        this.specVersion = specVersion;
        this.addStandardAPIs();
    }

    protected void addStandardAPIs() {
        String apiName = "connector_" + this.specVersion;
        Collection<String> classes = APIRepository.Instance().getClassesFor(apiName);
        Iterator<String> i = classes.iterator();
        while (i.hasNext()) {
            this.addExcludedClass(i.next());
        }
        Collection<String> pkgs = APIRepository.Instance().getPackagesFor(apiName);
        Iterator<String> i2 = pkgs.iterator();
        while (i2.hasNext()) {
            this.addExcludedPackage(i2.next());
        }
        Collection<String> patterns = APIRepository.Instance().getPatternsFor(apiName);
        Iterator<String> i3 = patterns.iterator();
        while (i3.hasNext()) {
            this.addExcludedPattern(i3.next());
        }
    }
}

