/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;

public class CheckResourceAdapterClass
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String resourceAdapterClass = descriptor.getResourceAdapterClass();
        if (resourceAdapterClass.equals("")) {
            if (descriptor.getInBoundDefined()) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "resourceadapter-class cannot be empty if the resource adapter provides inbound communication"));
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.resourceadapter.notApp", "resourceadapter-class is not specified."));
            }
            return result;
        }
        Context context = this.getVerifierContext();
        ClassLoader jcl = context.getRarClassLoader();
        Class<?> implClass = null;
        try {
            implClass = Class.forName(resourceAdapterClass, false, this.getVerifierContext().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CheckResourceAdapter.nonexist", "Error: The class [ {0} ] as defined under resourceadapter-class in the deployment descriptor does not exist", new Object[]{resourceAdapterClass}));
            return result;
        }
        if (!CheckResourceAdapterClass.isImplementorOf(implClass, "javax.resource.spi.ResourceAdapter")) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: resourceadapter-class [ {0} ] does not implement javax.resource.spi.ResourceAdapter", new Object[]{resourceAdapterClass}));
        } else {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: resourceadapter-class implements javax.resource.spi.ResourceAdapter"));
        }
        return result;
    }
}

