/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.IOException;

public class Console {
    public static void printPrompt(String prompt) {
        System.out.print(prompt + " ");
        System.out.flush();
    }

    public static String readLine() {
        String r = "";
        boolean done = false;
        while (!done) {
            try {
                int ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                if ((char)ch == '\r') continue;
                r = r + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return r;
    }

    public static char getKey(String prompt) {
        Console.printPrompt(prompt);
        int ch = 10;
        try {
            ch = System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (char)ch;
    }

    public static String readLine(String prompt) {
        Console.printPrompt(prompt);
        return Console.readLine();
    }

    public static int readInt(String prompt) {
        while (true) {
            Console.printPrompt(prompt);
            try {
                return Integer.valueOf(Console.readLine().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not an integer. Please try again!");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String prompt) {
        while (true) {
            Console.printPrompt(prompt);
            try {
                return Double.parseDouble(Console.readLine().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not a floating point number. Please try again!");
                continue;
            }
            break;
        }
    }
}

