/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyConfigConverter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final String OLD_JDBC_DRIVER_KEY = "jdbc.drivers";
    private static final String OLD_JDBC_DATASOURCES_KEY = "jdbc.datasources";
    private static final String OLD_JDBC_XA_DATASOURCES_KEY = "jdbc20.datasources";
    private static final String OLD_JDBC_DELIMITER = "|";
    private static final String KEY_DELIMITER = ".";
    private static final String OLD_XA_DATASOURCE_PREFIX = "xadatasource";
    private static final String OLD_XA_JNDI_NAME = "jndiname";
    private static final String OLD_XA_CLASSNAME = "classname";
    private static final String OLD_XA_DB_USER = "dbuser";
    private static final String OLD_XA_DB_PASSWORD = "dbpassword";
    private static final String OLD_PROP_INDICATOR = "prop";
    private static final boolean debug = true;
    private J2EEResourceFactory resourceFactory_;

    public static void main(String[] args) {
        if (args.length == 2) {
            String defaultPropsFilename = args[0];
            String destinationPropsFilename = args[1];
            LegacyConfigConverter conv = new LegacyConfigConverter();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Reading old jdbc properties from " + defaultPropsFilename);
                _logger.log(Level.FINE, "Destination file is " + destinationPropsFilename);
            }
            conv.convert(defaultPropsFilename, destinationPropsFilename);
        } else {
            System.out.println("Usage : <old_props_file> <new_props_file>");
            System.out.println("For example : /a/b/default.properties /a/b/resource.properties");
        }
    }

    public void convert(String oldFile, String newFile) {
        block5: {
            InputStream inputStream = null;
            try {
                File defaultPropsFile = new File(oldFile);
                FileInputStream fis = new FileInputStream(defaultPropsFile);
                inputStream = new BufferedInputStream(fis);
                Properties defaultProps = new Properties();
                defaultProps.load(inputStream);
                this.resourceFactory_ = ServerConfiguration.getJ2EEResourceFactory();
                J2EEResourceCollection resources = this.resourceFactory_.loadResourceCollection(newFile);
                this.convertJdbcDrivers(defaultProps, resources);
                this.convertJdbcResources(defaultProps, resources);
                this.convertJdbcXAResources(defaultProps, resources);
                this.resourceFactory_.storeResourceCollection(resources, newFile);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Conversion complete.  " + oldFile + " has not been changed.  Please remove any obsolete jdbc properties if it will be used as a default.properties file in j2ee");
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_legacyconfigconverter_convert", e);
                if (inputStream == null) break block5;
                try {
                    inputStream.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
            }
        }
    }

    private void convertJdbcDrivers(Properties defaultProps, J2EEResourceCollection resources) throws Exception {
        String drivers = defaultProps.getProperty(OLD_JDBC_DRIVER_KEY);
        if (drivers == null) {
            _logger.log(Level.FINE, "No Jdbc Drivers...");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(drivers, OLD_JDBC_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String nextDriverClass = tokenizer.nextToken();
            J2EEResource driver = this.resourceFactory_.createResource(5, nextDriverClass);
            resources.addResource(driver);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Adding " + driver);
        }
    }

    private void convertJdbcResources(Properties defaultProps, J2EEResourceCollection resources) throws Exception {
        String jdbcResources = defaultProps.getProperty(OLD_JDBC_DATASOURCES_KEY);
        if (jdbcResources == null) {
            _logger.log(Level.FINE, "No Jdbc Resources...");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(jdbcResources, OLD_JDBC_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String jndiName = tokenizer.nextToken();
            String url = tokenizer.nextToken();
            JdbcResource jdbcResource = (JdbcResource)this.resourceFactory_.createResource(3, jndiName);
            resources.addResource(jdbcResource);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Adding " + jdbcResource);
        }
    }

    private void convertJdbcXAResources(Properties defaultProps, J2EEResourceCollection resources) throws Exception {
        String xaResources = defaultProps.getProperty(OLD_JDBC_XA_DATASOURCES_KEY);
        if (xaResources == null) {
            _logger.log(Level.FINE, "No XA Jdbc Resources...");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(xaResources, OLD_JDBC_DELIMITER);
        int xaDriverCount = 0;
        Hashtable<String, JdbcXAResource> xaDriverResources = new Hashtable<String, JdbcXAResource>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            String xaJndiName = tokenizer.nextToken();
            JdbcXAResource jdbcXAResource = (JdbcXAResource)this.resourceFactory_.createResource(4, name);
            xaDriverResources.put(xaJndiName, jdbcXAResource);
            resources.addResource(jdbcXAResource);
            ++xaDriverCount;
        }
        for (int driverIndex = 0; driverIndex < xaDriverCount; ++driverIndex) {
            String propPrefix = "xadatasource." + driverIndex + KEY_DELIMITER;
            String xaJndiName = defaultProps.getProperty(propPrefix + OLD_XA_JNDI_NAME);
            JdbcXAResource jdbcXAResource = (JdbcXAResource)xaDriverResources.get(xaJndiName);
            String className = defaultProps.getProperty(propPrefix + OLD_XA_CLASSNAME);
            String dbuser = defaultProps.getProperty(propPrefix + OLD_XA_DB_USER);
            String dbPassword = defaultProps.getProperty(propPrefix + OLD_XA_DB_PASSWORD);
            jdbcXAResource.setClassname(className);
            this.setJdbcXAProps(defaultProps, jdbcXAResource, driverIndex);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Adding " + jdbcXAResource);
        }
    }

    private void setJdbcXAProps(Properties defaultProps, JdbcXAResource resource, int index) {
        Set<Map.Entry<Object, Object>> propSet = defaultProps.entrySet();
        String keyPrefix = "xadatasource." + index + KEY_DELIMITER + OLD_PROP_INDICATOR + KEY_DELIMITER;
        for (Map.Entry<Object, Object> next : propSet) {
            String key = (String)next.getKey();
            String value = (String)next.getValue();
            if (!key.startsWith(keyPrefix)) continue;
            int propNameIndex = key.lastIndexOf(KEY_DELIMITER);
            String propName = key.substring(propNameIndex + 1);
            ResourcePropertyImpl rs = new ResourcePropertyImpl(propName, value);
            resource.addProperty(rs);
        }
    }
}

