/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Classpath {
    public static List getClasspathAsList() {
        String cp = Classpath.getClasspathAsString();
        String ps = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(cp, ps);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static List getClasspathAsBatchCommands() {
        List from = Classpath.getClasspathAsList();
        ArrayList<String> to = new ArrayList<String>();
        boolean first = true;
        Iterator iter = from.iterator();
        while (iter.hasNext()) {
            if (first) {
                to.add("set CLASSPATH=" + iter.next());
                first = false;
                continue;
            }
            to.add("set CLASSPATH=%CLASSPATH%;" + iter.next());
        }
        return to;
    }

    public static String getClasspathAsString() {
        return System.getProperty("java.class.path");
    }

    public static List getClasspathAsSortedList() {
        List list = Classpath.getClasspathAsList();
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public static void main(String[] args) {
        Classpath.pr("******  CLASSPATH as String *******");
        Classpath.pr(Classpath.getClasspathAsString());
        Classpath.pr("******  CLASSPATH as List *******");
        Classpath.pr(Classpath.getClasspathAsList());
        Classpath.pr("******  CLASSPATH as Sorted List *******");
        Classpath.pr(Classpath.getClasspathAsSortedList());
        Classpath.pr("******  CLASSPATH as Batch Commands *******");
        Classpath.pr(Classpath.getClasspathAsBatchCommands());
    }

    private static void pr(String s) {
        System.out.println(s);
    }

    private static void pr(List c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Classpath.pr((String)iter.next());
        }
    }
}

