/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.pool;

import com.sun.enterprise.util.ApproximateClock;
import com.sun.enterprise.util.pool.ObjectFactory;
import com.sun.enterprise.util.pool.Pool;
import com.sun.enterprise.util.pool.PoolException;
import com.sun.enterprise.util.pool.PoolListener;
import com.sun.enterprise.util.pool.RequestInterruptedException;
import com.sun.enterprise.util.scheduler.PeriodicEventScheduler;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPool
implements Pool {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected boolean bDebug = false;
    protected Collection collection;
    protected ArrayList listeners;
    protected ObjectFactory factory = null;
    protected int waitCount = 0;
    protected int createdCount = 0;
    protected Object onHold = null;
    protected Object closed = null;
    protected static ApproximateClock _clock = new ApproximateClock(15000L);
    protected PeriodicEventScheduler scheduler = PeriodicEventScheduler.getInstance();

    protected AbstractPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(boolean canWait, Object param) throws InterruptedException, PoolException {
        Object object;
        if (this.closed != null) {
            throw new PoolException("Pool closed. Cannot obtain object");
        }
        Collection collection = this.collection;
        synchronized (collection) {
            block16: {
                while (true) {
                    if (this.collection.size() > 0) {
                        object = this.checkout(param);
                        if (object != null) {
                            return object;
                        }
                    } else if (this.canCreate()) {
                        ++this.createdCount;
                        break block16;
                    }
                    if (!canWait) break;
                    try {
                        ++this.waitCount;
                        this.beforeWait(param);
                        this.collection.wait();
                        this.afterNotify(param);
                        --this.waitCount;
                    }
                    catch (InterruptedException inEx) {
                        throw new RequestInterruptedException("InterruptedException", inEx);
                    }
                }
                return null;
            }
        }
        try {
            object = this.factory.create(param);
        }
        catch (PoolException poolEx) {
            Collection collection2 = this.collection;
            synchronized (collection2) {
                --this.createdCount;
            }
            throw poolEx;
        }
        this.afterCreate(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(long waitFor, Object param) throws InterruptedException, PoolException {
        Object object;
        if (this.closed != null) {
            throw new PoolException("Pool closed. Cannot obtain object");
        }
        long now = _clock.getTime();
        long timeLeft = waitFor;
        long startTime = now;
        Collection collection = this.collection;
        synchronized (collection) {
            while (true) {
                if (this.collection.size() > 0) {
                    object = this.checkout(param);
                    if (object != null) {
                        return object;
                    }
                } else if (this.canCreate()) {
                    ++this.createdCount;
                    break;
                }
                if (timeLeft > 0L) {
                    try {
                        ++this.waitCount;
                        this.beforeWait(param);
                        this.collection.wait();
                        this.afterNotify(param);
                        --this.waitCount;
                    }
                    catch (InterruptedException inEx) {
                        throw new RequestInterruptedException("InterruptedException", inEx);
                    }
                } else {
                    return null;
                }
                now = _clock.getTime();
                timeLeft = now - startTime;
                startTime = now;
            }
        }
        try {
            object = this.factory.create(param);
        }
        catch (PoolException poolEx) {
            Collection collection2 = this.collection;
            synchronized (collection2) {
                --this.createdCount;
            }
            throw poolEx;
        }
        this.afterCreate(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        Collection collection = this.collection;
        synchronized (collection) {
            if (this.closed != null && this.waitCount == 0) {
                this.destroyObject(object);
                return;
            }
            this.checkin(object);
            if (this.waitCount > 0) {
                this.collection.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        this.beforeDestroy(object);
        this.factory.destroy(object);
        Collection collection = this.collection;
        synchronized (collection) {
            --this.createdCount;
            if (this.waitCount > 0) {
                this.collection.notify();
            }
        }
    }

    protected abstract Object checkin(Object var1);

    protected abstract Object checkout(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPoolListener(PoolListener listener) {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
                this.listeners.add(listener);
                return true;
            }
            if (this.listeners.indexOf(listener) == -1) {
                this.listeners.add(listener);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePoolListener(PoolListener listener) {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            if (this.listeners == null) {
                return false;
            }
            return this.listeners.remove(listener);
        }
    }

    protected abstract boolean canCreate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(int count) {
        if (count <= 0) {
            return;
        }
        ArrayList<Object> tempList = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            try {
                tempList.add(this.factory.create(null));
                continue;
            }
            catch (PoolException poolEx) {
                // empty catch block
            }
        }
        count = tempList.size();
        Collection collection = this.collection;
        synchronized (collection) {
            for (int i = 0; i < count; ++i) {
                this.checkin(tempList.get(i));
            }
            this.createdCount += count;
        }
        _logger.log(Level.FINE, "After preload(" + count + "): Size: " + this.collection.size());
    }

    public int size() {
        return this.collection.size();
    }

    public int destroyPoolObjects() {
        return this.destroyPoolObjects(this.collection.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroyPoolObjects(int count) {
        if (count <= 0) {
            return 0;
        }
        Object[] array = this.collection.toArray();
        ArrayList<Object> arrayList = null;
        Collection collection = this.collection;
        synchronized (collection) {
            if (count > this.collection.size()) {
                count = this.collection.size();
            }
            arrayList = new ArrayList<Object>(count);
            for (int i = 0; i < count; ++i) {
                arrayList.add(this.checkout(null));
            }
            count = arrayList.size();
            this.createdCount -= count;
        }
        for (int i = 0; i < count; ++i) {
            this.factory.destroy(arrayList.get(i));
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.onClose();
        Collection collection = this.collection;
        synchronized (collection) {
            this.closed = "__Closed__";
            int diff = this.collection.size() - this.waitCount;
            this.destroyPoolObjects(diff);
        }
    }

    public boolean isClosed() {
        return this.closed != null;
    }

    public void afterCreate(Object object) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ((PoolListener)this.listeners.get(i)).afterCreate(object);
            }
        }
    }

    public void beforeDestroy(Object object) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ((PoolListener)this.listeners.get(i)).beforeDestroy(object);
            }
        }
    }

    public void beforeWait(Object object) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ((PoolListener)this.listeners.get(i)).beforeWait(object);
            }
        }
    }

    public void afterNotify(Object object) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ((PoolListener)this.listeners.get(i)).afterNotify(object);
            }
        }
    }

    public void onClose() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ((PoolListener)this.listeners.get(i)).onClose();
            }
        }
    }
}

