/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;

public class MonitorUtil {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    public static void resetMonitorStats(EmbeddedWebContainer embedded, ServerContext serverContext) {
        MonitoringRegistry monitoringRegistry = serverContext.getMonitoringRegistry();
        Engine[] engines = embedded.getEngines();
        for (int h = 0; h < engines.length; ++h) {
            Engine engine = engines[h];
            Container[] hosts = engine.findChildren();
            for (int i = 0; i < hosts.length; ++i) {
                Container nextHost = hosts[i];
                Container[] webModules = nextHost.findChildren();
                for (int j = 0; j < webModules.length; ++j) {
                    WebModuleStats stats;
                    WebModule webModule = (WebModule)webModules[j];
                    if (!webModule.hasWebXml()) continue;
                    String j2eeApp = webModule.getJ2EEApplication();
                    if ("null".equalsIgnoreCase(j2eeApp)) {
                        j2eeApp = null;
                    }
                    if ((stats = monitoringRegistry.getWebModuleStats(j2eeApp, webModule.getModuleName(), webModule.getPath(), nextHost.getName())) == null) continue;
                    try {
                        stats.reset();
                        continue;
                    }
                    catch (Throwable th) {
                        _logger.log(Level.SEVERE, "Error resetting WebModuleStats", th);
                    }
                }
            }
        }
    }
}

