/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PEAccessLogValve
extends ValveBase
implements Lifecycle,
Runnable {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static final String LOGGING_MAX_HISTORY_FILES = "com.sun.enterprise.server.logging.max_history_files";
    private static final String HTTP_HEADER_ACCEPT = "Accept";
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final String HTTP_HEADER_DATE = "Date";
    private static final String HTTP_HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String AUTH_USER_NAME = "auth-user-name";
    private static final String CLIENT_DNS = "client.dns";
    private static final String CLIENT_NAME = "client.name";
    private static final String COOKIE_VALUE = "cookie.value";
    private static final String DATE_TIME = "datetime";
    private static final String HEADER_ACCEPT = "header.accept";
    private static final String HEADER_ANY = "header.";
    private static final int HEADER_ANY_LEN = "header.".length();
    private static final String HEADER_AUTH = "header.auth";
    private static final String HEADER_DATE = "header.date";
    private static final String HEADER_IF_MOD_SINCE = "header.if-mod-since";
    private static final String HEADER_USER_AGENT = "header.user-agent";
    private static final String HEADER_REFERER = "header.referer";
    private static final String HTTP_METHOD = "http-method";
    private static final String HTTP_URI = "http-uri";
    private static final String HTTP_VERSION = "http-version";
    private static final String QUERY_STR = "query-str";
    private static final String REFERER = "referer";
    private static final String REQUEST = "request";
    private static final String RESPONSE_LENGTH = "response.length";
    private static final String STATUS = "status";
    private static final String USER_AGENT = "user.agent";
    private static final String VS_ID = "vs.id";
    private String directory = "logs";
    protected static final String info = "com.sun.enterprise.web.PEAccessLogValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String pattern = null;
    private String prefix = "";
    private boolean rotatable;
    private StringManager sm = StringManager.getManager("com.sun.enterprise.web");
    private boolean started = false;
    private String suffix = "";
    private boolean removeLeadingDotFromSuffix = false;
    private String dotLessSuffix = null;
    private SimpleDateFormat dateFormatter = null;
    private SimpleDateFormat dayFormatter = null;
    private SimpleDateFormat monthFormatter = null;
    private SimpleDateFormat yearFormatter = null;
    private SimpleDateFormat timeFormatter = null;
    private String timeZone = null;
    private Date currentDate = null;
    private String space = " ";
    private boolean resolveHosts = false;
    private long lastAccessLogCreationTime = 0L;
    private String condition = null;
    private String fileDateFormat = null;
    protected FileChannel fileChannel;
    FileOutputStream fos;
    private int writeInterval;
    private int rotationInterval;
    private Thread writerThread = null;
    private boolean threadDone = false;
    private CharBuffer charBuffer;
    public int chunkSize = 0;
    protected int bufferSize = 524288;
    private int expandedBufferSize;
    protected boolean flushRealTime = true;
    private boolean addDateStampToFirstAccessLogFile;
    private LinkedList<String> patternComponents;
    private File logFile;
    private int maxHistoryFiles;
    private boolean deleteAllHistoryFiles;
    private LinkedList<File> historyFiles;

    public int getWriterInterval() {
        return this.writeInterval;
    }

    public void setWriterInterval(int t) {
        if (t > 0) {
            this.flushRealTime = false;
        }
        this.writeInterval = t;
    }

    public int geRotationInterval() {
        return this.rotationInterval;
    }

    public void setRotationInterval(int t) {
        this.rotationInterval = t;
    }

    public void setBufferSize(int size) {
        if (size > 0) {
            this.flushRealTime = false;
        }
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setAddDateStampToFirstAccessLogFile(boolean add) {
        this.addDateStampToFirstAccessLogFile = add;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String p) {
        this.pattern = p;
        this.patternComponents = this.parsePattern();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String p) {
        this.prefix = p;
        if (this.prefix != null && this.suffix != null && this.prefix.endsWith(".") && this.suffix.startsWith(".")) {
            this.removeLeadingDotFromSuffix = true;
            this.dotLessSuffix = this.suffix.substring(1);
        } else {
            this.removeLeadingDotFromSuffix = false;
        }
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String s) {
        this.suffix = s;
        if (this.prefix != null && this.suffix != null && this.prefix.endsWith(".") && this.suffix.startsWith(".")) {
            this.removeLeadingDotFromSuffix = true;
            this.dotLessSuffix = this.suffix.substring(1);
        } else {
            this.removeLeadingDotFromSuffix = false;
        }
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        return 1;
    }

    @Override
    public synchronized void postInvoke(Request request, Response response) {
        boolean flushBuffer;
        if (this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
            return;
        }
        int lastPosition = this.charBuffer.position();
        if (this.charBuffer.position() == this.charBuffer.limit()) {
            this.charBuffer.limit(this.charBuffer.capacity());
        }
        boolean bl = flushBuffer = !this.charBuffer.hasRemaining();
        if (this.chunkSize + this.charBuffer.position() > this.charBuffer.limit()) {
            flushBuffer = true;
        }
        if (!flushBuffer) {
            try {
                this.createLogEntry(request, response, this.patternComponents);
                this.chunkSize = this.charBuffer.position() - lastPosition;
            }
            catch (BufferOverflowException ex) {
                flushBuffer = true;
                this.charBuffer.position(lastPosition);
            }
        }
        if (flushBuffer || this.flushRealTime || this.charBuffer.position() - lastPosition > this.bufferSize) {
            this.log();
        }
        if (flushBuffer) {
            boolean expand = true;
            while (expand) {
                try {
                    this.createLogEntry(request, response, this.patternComponents);
                    expand = false;
                    this.log();
                }
                catch (BufferOverflowException ex) {
                    if (!this.flushRealTime) {
                        _logger.log(Level.WARNING, "peaccesslogvalve.bufferSizeTooSmall", new Object[]{Integer.toString(this.expandedBufferSize)});
                    }
                    this.expandedBufferSize *= 2;
                    this.charBuffer = CharBuffer.allocate(this.expandedBufferSize);
                }
            }
        }
    }

    private void createLogEntry(Request request, Response response, LinkedList<String> patternComponents) {
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        for (int i = 0; i < patternComponents.size(); ++i) {
            String pc = patternComponents.get(i);
            if (AUTH_USER_NAME.equals(pc)) {
                this.appendAuthUserName(this.charBuffer, hreq);
            } else if (CLIENT_DNS.equals(pc)) {
                this.appendClientDNS(this.charBuffer, req);
            } else if (CLIENT_NAME.equals(pc)) {
                this.appendClientName(this.charBuffer, req);
            } else if (COOKIE_VALUE.equals(pc)) {
                this.appendCookieValue(this.charBuffer, hreq);
            } else if (DATE_TIME.equals(pc)) {
                this.appendCurrentDate(this.charBuffer);
            } else if (HEADER_ACCEPT.equals(pc)) {
                this.appendHeaderAccept(this.charBuffer, hreq);
            } else if (HEADER_AUTH.equals(pc)) {
                this.appendHeaderAuth(this.charBuffer, hreq);
            } else if (HEADER_DATE.equals(pc)) {
                this.appendHeaderDate(this.charBuffer, hreq);
            } else if (HEADER_IF_MOD_SINCE.equals(pc)) {
                this.appendHeaderIfModSince(this.charBuffer, hreq);
            } else if (HEADER_USER_AGENT.equals(pc)) {
                this.appendUserAgent(this.charBuffer, hreq);
            } else if (HEADER_REFERER.equals(pc)) {
                this.appendReferer(this.charBuffer, hreq);
            } else if (HTTP_METHOD.equals(pc)) {
                this.appendHTTPMethod(this.charBuffer, hreq);
            } else if (HTTP_URI.equals(pc)) {
                this.appendHTTPUri(this.charBuffer, hreq);
            } else if (HTTP_VERSION.equals(pc)) {
                this.appendHTTPVersion(this.charBuffer, hreq);
            } else if (QUERY_STR.equals(pc)) {
                this.appendQueryString(this.charBuffer, hreq);
            } else if (REFERER.equals(pc)) {
                this.appendReferer(this.charBuffer, hreq);
            } else if (REQUEST.equals(pc)) {
                this.appendRequestInfo(this.charBuffer, hreq);
            } else if (RESPONSE_LENGTH.equals(pc)) {
                this.appendResponseLength(this.charBuffer, response);
            } else if (STATUS.equals(pc)) {
                this.appendResponseStatus(this.charBuffer, response);
            } else if (USER_AGENT.equals(pc)) {
                this.appendUserAgent(this.charBuffer, hreq);
            } else if (VS_ID.equals(pc)) {
                this.appendVirtualServerId(this.charBuffer);
            } else if (pc.startsWith(HEADER_ANY)) {
                this.appendHeaderAny(this.charBuffer, pc.substring(HEADER_ANY_LEN), hreq);
            }
            this.charBuffer.put(this.space);
        }
        this.charBuffer.put("\n");
    }

    private LinkedList<String> parsePattern() {
        LinkedList<String> list = new LinkedList<String>();
        int from = 0;
        int end = -1;
        int index = -1;
        while ((index = this.pattern.indexOf(37, from)) >= 0) {
            String component;
            end = this.pattern.indexOf(37, index + 1);
            if (end < 0) {
                _logger.log(Level.SEVERE, "peaccesslogvalve.missingAccessLogPatternEndDelimiter", this.pattern);
            }
            if (!(AUTH_USER_NAME.equals(component = this.pattern.substring(index + 1, end)) || CLIENT_DNS.equals(component) || CLIENT_NAME.equals(component) || COOKIE_VALUE.equals(component) || DATE_TIME.equals(component) || HEADER_ACCEPT.equals(component) || HEADER_AUTH.equals(component) || HEADER_DATE.equals(component) || HEADER_IF_MOD_SINCE.equals(component) || HEADER_USER_AGENT.equals(component) || HEADER_REFERER.equals(component) || HTTP_METHOD.equals(component) || HTTP_URI.equals(component) || HTTP_VERSION.equals(component) || QUERY_STR.equals(component) || REFERER.equals(component) || REQUEST.equals(component) || RESPONSE_LENGTH.equals(component) || STATUS.equals(component) || USER_AGENT.equals(component) || VS_ID.equals(component) || component.startsWith(HEADER_ANY))) {
                _logger.log(Level.SEVERE, "peaccesslogvalve.invalidAccessLogPatternComponent", new Object[]{component, this.pattern});
            }
            list.add(component);
            from = end + 1;
        }
        return list;
    }

    private void appendClientName(CharBuffer cb, ServletRequest req) {
        cb.put("\"");
        String value = req.getRemoteHost();
        if (value == null) {
            value = "NULL-CLIENT-NAME";
        }
        cb.put(value);
        cb.put("\"");
    }

    private void appendClientDNS(CharBuffer cb, ServletRequest req) {
        cb.put("\"");
        String value = req.getRemoteAddr();
        if (value == null) {
            value = "NULL-CLIENT-DNS";
        }
        cb.put(value);
        cb.put("\"");
    }

    private void appendAuthUserName(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String user = hreq.getRemoteUser();
        if (user == null) {
            user = "NULL-AUTH-USER";
        }
        cb.put(user);
        cb.put("\"");
    }

    private void appendCurrentDate(CharBuffer cb) {
        cb.put("\"");
        Date date = this.getDate();
        cb.put(this.dayFormatter.format(date));
        cb.put('/');
        cb.put(this.lookup(this.monthFormatter.format(date)));
        cb.put('/');
        cb.put(this.yearFormatter.format(date));
        cb.put(':');
        cb.put(this.timeFormatter.format(date));
        cb.put(this.space);
        cb.put(this.timeZone);
        cb.put("\"");
    }

    private void appendRequestInfo(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        cb.put(hreq.getMethod());
        cb.put(this.space);
        cb.put(hreq.getRequestURI());
        if (hreq.getQueryString() != null) {
            cb.put('?');
            cb.put(hreq.getQueryString());
        }
        cb.put(this.space);
        cb.put(hreq.getProtocol());
        cb.put("\"");
    }

    private void appendResponseStatus(CharBuffer cb, Response response) {
        cb.put(String.valueOf(((HttpResponse)response).getStatus()));
    }

    private void appendResponseLength(CharBuffer cb, Response response) {
        cb.put("" + response.getContentCount());
    }

    private void appendUserAgent(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String ua = hreq.getHeader("user-agent");
        if (ua == null) {
            ua = "NULL-USER-AGENT";
        }
        cb.put(ua);
        cb.put("\"");
    }

    private void appendReferer(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String referer = hreq.getHeader(REFERER);
        if (referer == null) {
            referer = "NULL-REFERER";
        }
        cb.put(referer);
        cb.put("\"");
    }

    private void appendHeaderAccept(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String accept = hreq.getHeader(HTTP_HEADER_ACCEPT);
        if (accept == null) {
            accept = "NULL-HEADER-ACCEPT";
        }
        cb.put(accept);
        cb.put("\"");
    }

    private void appendHeaderAuth(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String auth = hreq.getHeader(HTTP_HEADER_AUTHORIZATION);
        if (auth == null) {
            auth = "NULL-HEADER-AUTHORIZATION";
        }
        cb.put(auth);
        cb.put("\"");
    }

    private void appendHeaderDate(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String date = hreq.getHeader(HTTP_HEADER_DATE);
        if (date == null) {
            date = "NULL-HEADER-DATE";
        }
        cb.put(date);
        cb.put("\"");
    }

    private void appendHeaderIfModSince(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String ifModSince = hreq.getHeader(HTTP_HEADER_IF_MODIFIED_SINCE);
        if (ifModSince == null) {
            ifModSince = "NULL-HEADER-IF-MODIFIED-SINCE";
        }
        cb.put(ifModSince);
        cb.put("\"");
    }

    private void appendHeaderAny(CharBuffer cb, String headerName, HttpServletRequest hreq) {
        cb.put("\"");
        String value = hreq.getHeader(headerName);
        if (value == null) {
            value = "NULL-HEADER-" + headerName.toUpperCase();
        }
        cb.put(value);
        cb.put("\"");
    }

    private void appendCookieValue(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String cookieValue = "NULL-COOKIE-VALUE";
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null && cookies.length > 0) {
            cookieValue = cookies[0].getValue();
        }
        cb.put(cookieValue);
        cb.put("\"");
    }

    private void appendHTTPMethod(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String method = hreq.getMethod();
        if (method == null) {
            method = "NULL-HTTP-METHOD";
        }
        cb.put(method);
        cb.put("\"");
    }

    private void appendHTTPUri(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String uri = hreq.getRequestURI();
        if (uri == null) {
            uri = "NULL-HTTP-URI";
        }
        cb.put(uri);
        cb.put("\"");
    }

    private void appendHTTPVersion(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String protocol = hreq.getProtocol();
        if (protocol == null) {
            protocol = "NULL-HTTP-PROTOCOL";
        }
        cb.put(protocol);
        cb.put("\"");
    }

    private void appendQueryString(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String query = hreq.getQueryString();
        if (query == null) {
            query = "NULL-QUERY";
        }
        cb.put(query);
        cb.put("\"");
    }

    private void appendVirtualServerId(CharBuffer cb) {
        String vsId = "NULL-VIRTUAL-SERVER";
        Container cont = this.getContainer();
        if (cont != null) {
            vsId = cont.getName();
        }
        cb.put(vsId);
    }

    private synchronized void close() {
        try {
            this.log();
            this.fileChannel.close();
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.lastAccessLogCreationTime > (long)(this.rotationInterval * 1000)) {
            PEAccessLogValve pEAccessLogValve = this;
            synchronized (pEAccessLogValve) {
                systime = System.currentTimeMillis();
                if (systime - this.lastAccessLogCreationTime > (long)(this.rotationInterval * 1000)) {
                    String lastDateStamp = this.dateFormatter.format(new Date(this.lastAccessLogCreationTime));
                    String newDateStamp = this.dateFormatter.format(new Date(systime));
                    this.lastAccessLogCreationTime = systime;
                    if (!lastDateStamp.equals(newDateStamp)) {
                        this.close();
                        this.open(newDateStamp, false);
                    }
                }
            }
        }
        try {
            this.charBuffer.flip();
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.charBuffer.toString().getBytes());
            while (byteBuffer.hasRemaining()) {
                this.fileChannel.write(byteBuffer);
            }
            this.charBuffer.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    private synchronized void open(String dateStamp, boolean firstAccessLogFile) {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = this.rotatable && this.addDateStampToFirstAccessLogFile ? dir.getAbsolutePath() + File.separator + this.prefix + dateStamp + this.suffix : (this.removeLeadingDotFromSuffix ? dir.getAbsolutePath() + File.separator + this.prefix + this.dotLessSuffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix);
            if (this.rotatable && !this.addDateStampToFirstAccessLogFile && !firstAccessLogFile) {
                String dateStampedPathname = dir.getAbsolutePath() + File.separator + this.prefix + dateStamp + this.suffix;
                File renameToFile = new File(dateStampedPathname);
                if (!this.logFile.renameTo(renameToFile)) {
                    _logger.log(Level.WARNING, "peaccesslogvalve.unableToRenameLogFile", new Object[]{this.logFile.toString(), dateStampedPathname});
                }
                File removeFile = null;
                if (this.deleteAllHistoryFiles) {
                    removeFile = renameToFile;
                } else if (this.historyFiles != null) {
                    this.historyFiles.addLast(renameToFile);
                    if (this.historyFiles.size() > this.maxHistoryFiles) {
                        removeFile = this.historyFiles.removeFirst();
                    }
                }
                if (removeFile != null && !removeFile.delete()) {
                    _logger.log(Level.WARNING, "peaccesslogvalve.unableToRemoveLogFile", removeFile.toString());
                }
            }
            this.logFile = new File(pathname);
            this.fos = new FileOutputStream(this.logFile, true);
            this.fileChannel = this.fos.getChannel();
        }
        catch (IOException e) {
            try {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private synchronized Date getDate() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentDate.getTime() > 5000L) {
            this.currentDate = new Date(systime);
        }
        return this.currentDate;
    }

    private String calculateTimeZoneOffset(long offset) {
        StringBuffer tz = new StringBuffer();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.deleteAllHistoryFiles = false;
        this.historyFiles = null;
        String prop = System.getProperty(LOGGING_MAX_HISTORY_FILES);
        if (prop != null) {
            this.maxHistoryFiles = 10;
            if (!"".equals(prop)) {
                try {
                    this.maxHistoryFiles = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (this.maxHistoryFiles == 0) {
                this.deleteAllHistoryFiles = true;
            } else if (this.maxHistoryFiles > 0) {
                this.historyFiles = new LinkedList();
            }
        }
        this.expandedBufferSize = this.bufferSize;
        if (this.bufferSize <= 0) {
            this.expandedBufferSize = 1;
        }
        this.charBuffer = CharBuffer.allocate(this.expandedBufferSize);
        TimeZone tz = TimeZone.getDefault();
        this.timeZone = this.calculateTimeZoneOffset(tz.getRawOffset());
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        this.dateFormatter = new SimpleDateFormat(this.fileDateFormat);
        this.dateFormatter.setTimeZone(tz);
        this.dayFormatter = new SimpleDateFormat("dd");
        this.dayFormatter.setTimeZone(tz);
        this.monthFormatter = new SimpleDateFormat("MM");
        this.monthFormatter.setTimeZone(tz);
        this.yearFormatter = new SimpleDateFormat("yyyy");
        this.yearFormatter.setTimeZone(tz);
        this.timeFormatter = new SimpleDateFormat("HH:mm:ss");
        this.timeFormatter.setTimeZone(tz);
        long systime = System.currentTimeMillis();
        this.currentDate = new Date(systime);
        this.open(this.dateFormatter.format(this.currentDate), true);
        this.lastAccessLogCreationTime = systime;
        if (!this.flushRealTime) {
            this.threadStart();
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (!this.flushRealTime) {
            this.threadStop();
        }
        this.close();
    }

    @Override
    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.log();
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.writeInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.writerThread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "AccessLogWriter";
        this.writerThread = new Thread((Runnable)this, threadName);
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    private void threadStop() {
        if (this.writerThread == null) {
            return;
        }
        this.threadDone = true;
        this.writerThread.interrupt();
        try {
            this.writerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writerThread = null;
    }
}

