/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ProxyHandler;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.common.PasswordConfReader;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.http.HSHttpListenerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.PWCConnectionQueueStats;
import com.sun.enterprise.admin.monitor.stats.PWCFileCacheStats;
import com.sun.enterprise.admin.monitor.stats.PWCKeepAliveStats;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.PWCThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.security.CipherInfo;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.reconfig.HttpListenerReconfig;
import com.sun.enterprise.web.reconfig.VirtualServerReconfig;
import com.sun.enterprise.web.stats.HTTPListenerStatsImpl;
import com.sun.enterprise.web.stats.PWCConnectionQueueStatsImpl;
import com.sun.enterprise.web.stats.PWCFileCacheStatsImpl;
import com.sun.enterprise.web.stats.PWCKeepAliveStatsImpl;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.enterprise.web.stats.PWCThreadPoolStatsImpl;
import com.sun.enterprise.web.stats.PWCVirtualServerStatsImpl;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Embedded;

public class PEWebContainer
extends WebContainer
implements MonitoringLevelListener {
    private HashMap mimeMap;
    private HashMap<String, PECoyoteConnector> connectorMap;
    private boolean installAccessLogValve = true;
    private String accessLogBufferSize = null;
    private String accessLogWriteInterval = null;
    protected int defaultRedirectPort = -1;

    protected PEWebContainer(String id, ServerContext context) {
        super(id, context);
    }

    protected void init(ServerContext context) {
        this.connectorMap = new HashMap();
        Config config = null;
        ConfigContext configContext = context.getConfigContext();
        try {
            config = ServerBeansFactory.getConfigBean(configContext);
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            Object[] params = new Object[]{};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        this.createEngine();
        HttpService httpService = config.getHttpService();
        this.configureNotSupported(httpService);
        this.createConnectors(httpService);
        this.createHosts(httpService, this.installAccessLogValve);
        this.createJKConnector();
        PEWebContainer.registerReconfigListeners();
    }

    private void createJKConnector() {
        int port = 8009;
        int defaultRedirectPort = -1;
        String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
        if (portString == null) {
            return;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            port = 8009;
        }
        PECoyoteConnector connector = (PECoyoteConnector)((Embedded)this._embedded).createConnector("0.0.0.0", port, "ajp");
        String defaultHost = "server";
        Container[] virtualServers = this._embedded.getEngines()[0].findChildren();
        for (int i = 0; i < virtualServers.length; ++i) {
            if (virtualServers[i].getName().equalsIgnoreCase("__asadmin")) continue;
            defaultHost = virtualServers[i].getName();
            int[] ports = ((VirtualServer)virtualServers[i]).findPorts();
            int[] newPorts = new int[ports.length + 1];
            System.arraycopy(ports, 0, newPorts, 0, ports.length);
            newPorts[ports.length] = port;
            ((VirtualServer)virtualServers[i]).setPorts(newPorts);
            break;
        }
        connector.setDefaultHost(defaultHost);
        connector.setDomain(this._serverContext.getDefaultDomainName());
        connector.setLogger(_logger);
        connector.setName("httpd-listener");
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + portString);
        this._embedded.addConnector(connector);
    }

    public void createConnectors(HttpService httpService) {
        HttpListener[] httpListeners = httpService.getHttpListener();
        if (httpListeners != null) {
            for (int i = 0; i < httpListeners.length; ++i) {
                this.createConnector(httpListeners[i], httpService);
            }
        }
        this.setDefaultRedirectPort(this.defaultRedirectPort);
    }

    public PECoyoteConnector createConnector(HttpListener httpListener, HttpService httpService) {
        String address;
        int port = 8080;
        this.checkHostnameUniqueness(httpListener.getId(), httpService);
        try {
            port = Integer.parseInt(httpListener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = _rb.getString("pewebcontainer.http_listener.invalid_port");
            msg = MessageFormat.format(msg, httpListener.getPort(), httpListener.getId());
            throw new IllegalArgumentException(msg);
        }
        boolean isSecure = httpListener.isSecurityEnabled();
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = httpListener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        PECoyoteConnector connector = (PECoyoteConnector)this._embedded.createConnector(address, port, isSecure);
        connector.setName(httpListener.getId());
        this.configureConnector(connector, httpListener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{new Integer(port), connector});
        }
        this._embedded.addConnector(connector);
        this.connectorMap.put(httpListener.getId(), connector);
        if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        return connector;
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getRedirectPort() != -1) continue;
                connectors[i].setRedirectPort(defaultRedirectPort);
            }
        }
    }

    protected void createEngine() {
        String engineName = "com.sun.appserv";
        Engine engine = this._embedded.createEngine();
        this._embedded.addEngine(engine);
        ((StandardEngine)engine).setName(engineName);
        if (this.isTomcatUsingDefaultDomain()) {
            ((StandardEngine)engine).setDomain(this._serverContext.getDefaultDomainName());
        } else {
            ((StandardEngine)engine).setDomain(engineName);
        }
        _logger.log(Level.FINE, "Creating Engine " + engineName);
    }

    public void createHost(com.sun.enterprise.config.serverbeans.VirtualServer vse, ConfigContext configContext, boolean enableMonitoring) throws ConfigException {
        Config config = ServerBeansFactory.getConfigBean(configContext);
        VirtualServer vs = this.createHost(config.getHttpService(), vse, this.installAccessLogValve);
        this.loadDefaultWebModule(vs, ServerBeansFactory.getServerBean(configContext));
        if (enableMonitoring) {
            this.enableVirtualServerMonitoring(vs);
        }
    }

    protected void createHosts(HttpService httpService, boolean configureAccessLog) {
        com.sun.enterprise.config.serverbeans.VirtualServer[] vses = httpService.getVirtualServer();
        for (int j = 0; j < vses.length; ++j) {
            this.createHost(httpService, vses[j], configureAccessLog);
        }
    }

    protected VirtualServer createHost(HttpService httpService, com.sun.enterprise.config.serverbeans.VirtualServer vse, boolean configureAccessLog) {
        Engine[] engines = this._embedded.getEngines();
        String docroot = null;
        MimeMap mm = null;
        String vs_id = vse.getId();
        ElementProperty element = vse.getElementPropertyByName("docroot");
        if (element != null) {
            docroot = element.getValue();
        }
        this.validateDocroot(docroot, vs_id, vse.getDefaultWebModule());
        VirtualServer vs = this.createVS(vs_id, vse, docroot, vse.getLogFile(), mm, httpService.getHttpProtocol());
        ElementProperty cacheProp = vse.getElementPropertyByName("setCacheControl");
        if (cacheProp != null) {
            this.configureCacheControl(cacheProp.getValue(), vs);
        }
        if (configureAccessLog) {
            this.setAccessLog(vs, vs_id, vse, httpService);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Created virtual server " + vs_id);
        }
        this.configureHost(vs, httpService);
        engines[0].addChild(vs);
        return vs;
    }

    protected void configureCacheControl(String cacheControl, VirtualServer vs) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList(cacheControl, ",")) != null && !values.isEmpty()) {
            String[] cacheControls = new String[values.size()];
            vs.setCacheControls(values.toArray(cacheControls));
        }
    }

    protected boolean validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot != null) {
            boolean isValid = new File(docroot).exists();
            if (!isValid && defaultWebModule == null) {
                String msg = _rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                msg = MessageFormat.format(msg, vs_id, docroot);
                throw new IllegalArgumentException(msg);
            }
            if (!isValid) {
                _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
            }
        } else if (defaultWebModule == null) {
            String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
            msg = MessageFormat.format(msg, vs_id);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    protected void configureHost(VirtualServer vs, HttpService httpService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        this.configureHostAlias(vs);
        List listeners = StringUtils.parseStringList(vsBean.getHttpListeners(), ",");
        if (listeners == null) {
            return;
        }
        HttpListener[] httpListeners = new HttpListener[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            httpListeners[i] = httpService.getHttpListenerById((String)listeners.get(i));
        }
        this.configureHostListener(vs, httpListeners);
    }

    protected void configureHostAlias(VirtualServer vs) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        List hosts = StringUtils.parseStringList(vsBean.getHosts(), ",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost.localdomain")) continue;
            vs.addAlias(alias);
        }
    }

    protected void configureHostListener(VirtualServer vs, HttpListener[] httpListeners) {
        int[] ports = new int[httpListeners.length];
        int j = 0;
        for (int i = 0; i < httpListeners.length; ++i) {
            String listener = httpListeners[i].getId();
            PECoyoteConnector conn = this.connectorMap.get(listener);
            ports[j++] = conn.getPort();
            if (httpListeners[i].isEnabled() || !vs.getName().equalsIgnoreCase("__asadmin")) continue;
            throw new IllegalArgumentException("http-listener __asadmin enabled property cannot be modified");
        }
        vs.setPorts(ports);
    }

    private final void configureNotSupported(HttpService httpService) {
        if (!_logger.isLoggable(Level.FINE)) {
            return;
        }
        if (httpService.getHttpFileCache() != null) {
            HttpListener[] httpListeners;
            if (httpService.getHttpFileCache().getHashInitSize() != null) {
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.hash-init-size");
            }
            for (HttpListener httpListener : httpListeners = httpService.getHttpListener()) {
                if (httpListener.getFamily() != null) {
                    _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.family");
                }
                if (httpListener.getAttributeValue("blocking-enabled") != null) {
                    _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.blocking-enabled");
                }
                if (httpListener.getExternalPort() == null) continue;
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.external-port");
            }
        }
        if (httpService.getHttpProtocol() != null) {
            if (httpService.getHttpProtocol().getVersion() != null) {
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.version");
            }
            if (httpService.getHttpProtocol().getAttributeValue("ssl-enabled") != null) {
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.ssl-enabled");
            }
        }
    }

    public static WebContainer createInstance(ServerContext context) {
        webContainer = new PEWebContainer(new String("0"), context);
        _logger.log(Level.FINE, "Creating new instance of PEWebContainer.");
        ((PEWebContainer)webContainer).init(context);
        _logger.log(Level.FINE, "Initialization of PEWebContainer.");
        return webContainer;
    }

    public void startInstance() throws ServerLifecycleException {
        _logger.log(Level.INFO, "pewebcontainer.start");
        try {
            super.start();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.startError");
            throw new ServerLifecycleException(msg, ex);
        }
        this.enableVirtualServerMonitoring();
        this.enableHttpMonitoring();
    }

    public void stopInstance() throws ServerLifecycleException {
        _logger.log(Level.INFO, "pewebcontainer.stop");
        try {
            super.stop();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.stopError");
            throw new ServerLifecycleException(msg, ex);
        }
    }

    public static PEWebContainer getPEWebContainer() {
        return (PEWebContainer)webContainer;
    }

    protected void setAccessLog(StandardHost vs, String vsId, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService) {
        AccessLog accessLogConfig = httpService.getAccessLog();
        String accessLog = "access";
        if (vsBean.getElementPropertyByName("accesslog") != null) {
            accessLog = vsBean.getElementPropertyByName("accesslog").getValue();
        } else if (vsBean.getHttpAccessLog() != null) {
            accessLog = vsBean.getHttpAccessLog().getLogDirectory();
        }
        if (accessLog == null) {
            return;
        }
        File dir = new File(accessLog);
        if (!dir.isAbsolute()) {
            String logRoot = this.domain.getLogRoot();
            dir = logRoot != null ? new File(logRoot, accessLog) : new File(this.instance.getInstancesRoot(), accessLog);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Setting accesslog directory for virtual server '" + vsId + "' to " + dir.getAbsolutePath());
        }
        WebContainerFeatureFactory fac = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
        PEAccessLogValve accessLogValve = new PEAccessLogValve();
        accessLogValve.setDirectory(dir.getAbsolutePath());
        accessLogValve.setPrefix(vsId + fac.getDefaultAccessLogPrefix());
        accessLogValve.setPattern("common");
        HttpProtocol httpProtocol = httpService.getHttpProtocol();
        if (httpProtocol != null) {
            accessLogValve.setResolveHosts(httpProtocol.isDnsLookupEnabled());
        } else {
            accessLogValve.setResolveHosts(false);
        }
        String format = null;
        format = accessLogConfig != null ? accessLogConfig.getFormat() : AccessLog.getDefaultFormat();
        accessLogValve.setPattern(format);
        if (accessLogConfig != null) {
            accessLogValve.setRotatable(accessLogConfig.isRotationEnabled());
        } else {
            accessLogValve.setRotatable(Boolean.valueOf(AccessLog.getDefaultRotationEnabled()));
        }
        int rotationInterval = 0;
        if (accessLogConfig != null) {
            String s = accessLogConfig.getRotationIntervalInMinutes();
            rotationInterval = Integer.parseInt(s) * 60;
        } else if (vsBean.getElementPropertyByName("accessLogWriteInterval") != null || this.accessLogWriteInterval != null) {
            if (vsBean.getElementPropertyByName("accessLogWriteInterval") != null) {
                this.accessLogWriteInterval = vsBean.getElementPropertyByName("accessLogWriteInterval").getValue();
            }
            if (this.accessLogWriteInterval != null) {
                rotationInterval = Integer.parseInt(this.accessLogWriteInterval);
            }
        } else {
            rotationInterval = fac.getDefaultRotationIntervalInMinutes() * 60;
        }
        accessLogValve.setRotationInterval(rotationInterval);
        String acWriteInterval = this.accessLogWriteInterval;
        if (vsBean.getElementPropertyByName("accessLogWriteInterval") != null) {
            acWriteInterval = vsBean.getElementPropertyByName("accessLogWriteInterval").getValue();
        }
        String acBufferSize = this.accessLogBufferSize;
        if (vsBean.getElementPropertyByName("accessLogBufferSize") != null) {
            acBufferSize = vsBean.getElementPropertyByName("accessLogBufferSize").getValue();
        }
        if (acBufferSize != null) {
            try {
                accessLogValve.setBufferSize(Integer.parseInt(acBufferSize));
            }
            catch (NumberFormatException ex) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_accessLog_bufferSize", acBufferSize);
            }
        }
        if (acWriteInterval != null) {
            try {
                accessLogValve.setWriterInterval(Integer.parseInt(acWriteInterval));
            }
            catch (NumberFormatException ex) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_accessLog_writerInterval", acWriteInterval);
            }
        }
        String rotationDateStamp = null;
        rotationDateStamp = accessLogConfig != null ? accessLogConfig.getRotationSuffix() : fac.getDefaultAccessLogDateStampPattern();
        if ("%YYYY;%MM;%DD;-%hh;h%mm;m%ss;s".equals(rotationDateStamp)) {
            rotationDateStamp = "yyyyMMdd-HH'h'mm'm'ss's'";
        }
        accessLogValve.setFileDateFormat(rotationDateStamp);
        accessLogValve.setSuffix(fac.getDefaultAccessLogSuffix());
        accessLogValve.setAddDateStampToFirstAccessLogFile(fac.getAddDateStampToFirstAccessLogFile());
        vs.addValve(accessLogValve);
    }

    private void configureConnector(PECoyoteConnector connector, HttpListener httpListener, boolean isSecure, HttpService httpService) {
        ElementProperty prop;
        String redirectPort;
        this.configureConnectionPool(connector, httpService.getConnectionPool());
        WebContainerFeatureFactory wcFeatureFactory = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
        String sslImplementationName = wcFeatureFactory.getSSLImplementationName();
        if (sslImplementationName != null) {
            connector.setProperty("sSLImplementation", sslImplementationName);
        }
        connector.setDomain(this._serverContext.getDefaultDomainName());
        connector.setLogger(_logger);
        this.configureSSL(connector, httpListener);
        this.configureKeepAlive(connector, httpService.getKeepAlive());
        this.configureHttpProtocol(connector, httpService.getHttpProtocol());
        this.configureRequestProcessing(httpService.getRequestProcessing(), connector);
        this.configureFileCache(connector, httpService.getHttpFileCache());
        connector.setDefaultHost(httpListener.getDefaultVirtualServer());
        connector.setXpoweredBy(httpListener.isXpoweredBy());
        connector.setIsEnabled(httpListener.isEnabled());
        connector.setWebAppRootPath(this.getModulesRoot());
        String serverName = httpListener.getServerName();
        if (serverName != null && serverName.length() > 0) {
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring("http://".length());
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring("https://".length());
            }
            int index = serverName.indexOf(58);
            if (index != -1) {
                connector.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        connector.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, "pewebcontainer.invalid_proxy_port", new Object[]{serverPort, httpListener.getId()});
                    }
                }
            } else {
                connector.setProxyName(serverName);
            }
        }
        if ((redirectPort = httpListener.getRedirectPort()) != null && !redirectPort.equals("")) {
            try {
                connector.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, httpListener.getId(), Integer.toString(connector.getRedirectPort())});
            }
        } else {
            connector.setRedirectPort(-1);
        }
        String acceptorThreads = httpListener.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                connector.setSelectorReadThreadsCount(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(connector.getMaxProcessors())});
            }
        }
        if (isSecure) {
            String ksFile = System.getProperty("javax.net.ssl.keyStore");
            if (ksFile != null) {
                connector.setKeystoreFile(ksFile);
            }
            String ksPasswd = null;
            try {
                ksPasswd = PasswordConfReader.getKeyStorePassword();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (ksPasswd == null) {
                ksPasswd = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (ksPasswd != null) {
                try {
                    connector.setKeystorePass(ksPasswd);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "pewebcontainer.http_listener_keystore_password_exception", e);
                }
            }
        }
        if ((prop = httpListener.getElementPropertyByName("chunkingDisabled")) == null) {
            prop = httpListener.getElementPropertyByName("chunking-disabled");
        }
        if (prop != null) {
            connector.setChunkingDisabled(ConfigBean.toBoolean(prop.getValue()));
        }
        this.configureHttpServiceProperties(httpService, connector);
        this.configureHttpListenerProperties(httpListener, connector);
    }

    public void configureHttpListenerProperties(HttpListener httpListener, PECoyoteConnector connector) {
        ElementProperty[] httpListenerProps = httpListener.getElementProperty();
        if (httpListenerProps != null) {
            for (int i = 0; i < httpListenerProps.length; ++i) {
                String propValue;
                String propName = httpListenerProps[i].getName();
                if (this.configureHttpListenerProperty(propName, propValue = httpListenerProps[i].getValue(), connector)) continue;
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
            }
        }
    }

    protected boolean configureHttpListenerProperty(String propName, String propValue, PECoyoteConnector connector) {
        if ("bufferSize".equals(propName)) {
            connector.setBufferSize(Integer.parseInt(propValue));
            return true;
        }
        if ("recycle-objects".equals(propName)) {
            connector.setRecycleObjects(ConfigBean.toBoolean(propValue));
            return true;
        }
        if ("reader-threads".equals(propName)) {
            connector.setMaxReadWorkerThreads(Integer.parseInt(propValue));
            return true;
        }
        if ("acceptor-queue-length".equals(propName)) {
            connector.setMinAcceptQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-queue-length".equals(propName)) {
            connector.setMinReadQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("use-nio-direct-bytebuffer".equals(propName)) {
            connector.setUseDirectByteBuffer(ConfigBean.toBoolean(propValue));
            return true;
        }
        if ("maxKeepAliveRequests".equals(propName)) {
            connector.setMaxKeepAliveRequests(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-selectors".equals(propName)) {
            connector.setSelectorReadThreadsCount(Integer.parseInt(propValue));
            return true;
        }
        if ("authPassthroughEnabled".equals(propName)) {
            connector.setAuthPassthroughEnabled(ConfigBean.toBoolean(propValue));
            return true;
        }
        if ("proxyHandler".equals(propName)) {
            this.setProxyHandler(connector, propValue);
            return true;
        }
        if ("uriEncoding".equals(propName)) {
            connector.setURIEncoding(propValue);
            return true;
        }
        return false;
    }

    public void configureHttpServiceProperties(HttpService httpService, PECoyoteConnector connector) {
        ElementProperty[] httpServiceProps = httpService.getElementProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        if (httpServiceProps != null) {
            for (int i = 0; i < httpServiceProps.length; ++i) {
                String propValue;
                String propName = httpServiceProps[i].getName();
                if (this.configureHttpListenerProperty(propName, propValue = httpServiceProps[i].getValue(), connector)) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBean.toBoolean(propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBean.toBoolean(propValue));
                    continue;
                }
                if ("accessLoggingEnabled".equals(propName)) {
                    this.installAccessLogValve = ConfigBean.toBoolean(propValue);
                    continue;
                }
                if ("accessLogWriteInterval".equals(propName)) {
                    this.accessLogWriteInterval = propValue;
                    continue;
                }
                if ("accessLogBufferSize".equals(propName)) {
                    this.accessLogBufferSize = propValue;
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBean.toBoolean(propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSSLSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSSL3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSSLSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    this.setProxyHandler(connector, propValue);
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProps[i].getName());
            }
        }
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuffer enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuffer();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuffer();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        if (ci != null) {
            jsseCipher = ci.getCipherName();
        }
        return jsseCipher;
    }

    private void enableHttpMonitoring() {
        String msg;
        HttpService httpService;
        ServerContext sc = this.getServerContext();
        ConfigContext cc = sc.getConfigContext();
        MonitoringRegistry mReg = sc.getMonitoringRegistry();
        try {
            httpService = ServerBeansFactory.getHttpServiceBean(cc);
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "Unable to find HttpServiceBean in config", ce);
            return;
        }
        try {
            mReg.registerPWCKeepAliveStats((PWCKeepAliveStats)new PWCKeepAliveStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCKeepAliveStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        try {
            mReg.registerPWCFileCacheStats((PWCFileCacheStats)new PWCFileCacheStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCFileCacheStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        try {
            mReg.registerPWCThreadPoolStats((PWCThreadPoolStats)new PWCThreadPoolStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCThreadPoolStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        try {
            mReg.registerPWCConnectionQueueStats((PWCConnectionQueueStats)new PWCConnectionQueueStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCConnectionQueueStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        com.sun.enterprise.config.serverbeans.VirtualServer[] vs = httpService.getVirtualServer();
        for (int i = 0; i < vs.length; ++i) {
            String vsId = vs[i].getId();
            if (vsId.equalsIgnoreCase("__asadmin")) continue;
            VirtualServer virtualServer = (VirtualServer)this.getEngines()[0].findChild(vsId);
            if (virtualServer == null) {
                _logger.log(Level.WARNING, "Invalid virtual-server: " + vsId);
                continue;
            }
            List listeners = StringUtils.parseStringList(vs[i].getHttpListeners(), ",");
            if (listeners == null) continue;
            ListIterator iter = listeners.listIterator();
            while (iter.hasNext()) {
                HttpListener currentListener = httpService.getHttpListenerById(iter.next().toString());
                if (currentListener == null) continue;
                this.enableHttpListenerMonitoring(virtualServer, Integer.parseInt(currentListener.getPort()), currentListener.getId());
            }
        }
    }

    protected void enableHttpListenerMonitoring(VirtualServer virtualServer, int port, String httpListenerId) {
        PWCRequestStatsImpl pwcRequestStatsImpl = virtualServer.getPWCRequestStatsImpl();
        if (pwcRequestStatsImpl == null) {
            pwcRequestStatsImpl = new PWCRequestStatsImpl(this.getServerContext().getDefaultDomainName());
            virtualServer.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        }
        MonitoringRegistry mReg = this.getServerContext().getMonitoringRegistry();
        String vsId = virtualServer.getID();
        HTTPListenerStatsImpl httpStats = this.isTomcatUsingDefaultDomain() ? new HTTPListenerStatsImpl(this.getServerContext().getDefaultDomainName(), port) : new HTTPListenerStatsImpl(vsId, port);
        try {
            mReg.registerHttpListenerStats((HTTPListenerStats)httpStats, httpListenerId, vsId, null);
            pwcRequestStatsImpl.addHttpListenerStats(httpStats);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "HTTPListenerStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int i;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        com.sun.enterprise.config.serverbeans.VirtualServer[] vses = httpService.getVirtualServer();
        if (vses == null) {
            return;
        }
        block0: for (i = 0; i < vses.length; ++i) {
            List vsListeners = StringUtils.parseStringList(vses[i].getHttpListeners(), ",");
            for (int j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals((String)vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vses[i]);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List hosts = StringUtils.parseStringList(vs.getHosts(), ",");
            for (int j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = (String)hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List otherHosts = StringUtils.parseStringList(otherVs.getHosts(), ",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals((String)otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    protected void loadAllJ2EEApplicationWebModules() {
    }

    public static WebContainer getInstance() {
        return webContainer;
    }

    private void enableVirtualServerMonitoring() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                VirtualServer vs = (VirtualServer)hostArray[i];
                this.enableVirtualServerMonitoring(vs);
            }
        }
    }

    private void enableVirtualServerMonitoring(VirtualServer vs) {
        ServerContext sc = this.getServerContext();
        ConfigContext cc = sc.getConfigContext();
        MonitoringRegistry monitoringRegistry = sc.getMonitoringRegistry();
        PWCVirtualServerStatsImpl vsStats = new PWCVirtualServerStatsImpl(vs);
        try {
            monitoringRegistry.registerPWCVirtualServerStats((PWCVirtualServerStats)vsStats, vs.getID(), null);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Unable to register PWCVirtualServerStats for " + vs.getID(), e);
        }
        PWCRequestStatsImpl pwcRequestStatsImpl = new PWCRequestStatsImpl(sc.getDefaultDomainName());
        vs.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        try {
            monitoringRegistry.registerPWCRequestStats((PWCRequestStats)pwcRequestStatsImpl, vs.getID(), null);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCRequestStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    private void configureSSL(PECoyoteConnector connector, HttpListener httpListener) {
        String ciphers;
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig == null) {
            return;
        }
        if (sslConfig.isClientAuthEnabled()) {
            connector.setClientAuth(true);
        }
        StringBuffer sslProtocolsBuf = new StringBuffer();
        boolean needComma = false;
        if (sslConfig.isSsl2Enabled()) {
            sslProtocolsBuf.append("SSLv2");
            needComma = true;
        }
        if (sslConfig.isSsl3Enabled()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            } else {
                needComma = true;
            }
            sslProtocolsBuf.append("SSLv3");
        }
        if (sslConfig.isTlsEnabled()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            }
            sslProtocolsBuf.append("TLSv1");
        }
        if (sslConfig.isSsl3Enabled() || sslConfig.isTlsEnabled()) {
            sslProtocolsBuf.append(", SSLv2Hello");
        }
        if (sslProtocolsBuf.length() == 0) {
            _logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
        } else {
            connector.setSslProtocols(sslProtocolsBuf.toString());
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            connector.setKeyAlias(sslConfig.getCertNickname());
        }
        if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
            String jsseCiphers = this.getJSSECiphers(ciphers);
            if (jsseCiphers == null) {
                _logger.log(Level.WARNING, "pewebcontainer.all_ciphers_disabled", httpListener.getId());
            } else {
                connector.setCiphers(jsseCiphers);
            }
        }
    }

    private void configureKeepAlive(PECoyoteConnector connector, KeepAlive keepAlive) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        int threadCount = 1;
        if (keepAlive != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(keepAlive.getTimeoutInSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, keepAlive.getTimeoutInSeconds(), Integer.toString(timeoutInSeconds));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(keepAlive.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, keepAlive.getMaxConnections(), Integer.toString(maxConnections));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                threadCount = Integer.parseInt(keepAlive.getThreadCount());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveThreadCount");
                msg = MessageFormat.format(msg, keepAlive.getThreadCount(), Integer.toString(threadCount));
                _logger.log(Level.WARNING, msg, ex);
            }
        }
        connector.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        connector.setMaxKeepAliveRequests(maxConnections);
        connector.setKeepAliveThreadCount(threadCount);
    }

    private void configureConnectionPool(PECoyoteConnector connector, ConnectionPool cp) {
        String msg;
        if (cp == null) {
            return;
        }
        try {
            int queueSizeInBytes = Integer.parseInt(cp.getQueueSizeInBytes());
            if (queueSizeInBytes <= -1) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidQueueSizeInBytes", new Object[]{cp.getQueueSizeInBytes(), Integer.toString(connector.getQueueSizeInBytes())});
            } else {
                connector.setQueueSizeInBytes(queueSizeInBytes);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidQueueSizeInBytes");
            Object[] objectArray = new Object[2];
            objectArray[0] = cp.getDefaultQueueSizeInBytes();
            objectArray[1] = Integer.toString(connector.getQueueSizeInBytes());
            msg = MessageFormat.format(msg, objectArray);
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int ssBackLog = Integer.parseInt(cp.getMaxPendingCount());
            if (ssBackLog <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxPendingCount", new Object[]{cp.getMaxPendingCount(), Integer.toString(connector.getSocketServerBacklog())});
            } else {
                connector.setSocketServerBacklog(ssBackLog);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxPendingCount");
            msg = MessageFormat.format(msg, cp.getMaxPendingCount(), Integer.toString(connector.getSocketServerBacklog()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int bufferSize = Integer.parseInt(cp.getReceiveBufferSizeInBytes());
            if (bufferSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidBufferSize", new Object[]{cp.getReceiveBufferSizeInBytes(), Integer.toString(connector.getBufferSize())});
            } else {
                connector.setBufferSize(bufferSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidBufferSize");
            msg = MessageFormat.format(msg, cp.getReceiveBufferSizeInBytes(), Integer.toString(connector.getBufferSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int maxHttpHeaderSize = Integer.parseInt(cp.getSendBufferSizeInBytes());
            if (maxHttpHeaderSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxHttpHeaderSize", new Object[]{cp.getSendBufferSizeInBytes(), Integer.toString(connector.getMaxHttpHeaderSize())});
            } else {
                connector.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxHttpHeaderSize");
            msg = MessageFormat.format(msg, cp.getSendBufferSizeInBytes(), Integer.toString(connector.getMaxHttpHeaderSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
    }

    public static void registerReconfigListeners() {
        AdminEventListenerRegistry.addEventListener(HSVirtualServerEvent.eventType, new VirtualServerReconfig());
        AdminEventListenerRegistry.addEventListener(HSHttpListenerEvent.eventType, new HttpListenerReconfig());
    }

    public void deleteHost(HttpService httpService) throws LifecycleException {
        int i;
        Engine[] engines = this._embedded.getEngines();
        com.sun.enterprise.config.serverbeans.VirtualServer[] vses = httpService.getVirtualServer();
        Container[] virtualServers = engines[0].findChildren();
        block0: for (i = 0; i < virtualServers.length; ++i) {
            for (int j = 0; j < vses.length; ++j) {
                if (!virtualServers[i].getName().equals(vses[j].getId())) continue;
                virtualServers[i] = null;
                continue block0;
            }
        }
        for (i = 0; i < virtualServers.length; ++i) {
            VirtualServer virtualServer = (VirtualServer)virtualServers[i];
            if (virtualServer == null) continue;
            if (virtualServer.getID().equals("__asadmin")) {
                throw new LifecycleException("Cannot delete admin virtual-server.");
            }
            Container[] webModules = virtualServer.findChildren();
            for (int j = 0; j < webModules.length; ++j) {
                this.unloadWebModule(webModules[j].getName(), webModules[j].getName(), virtualServer.getID(), null);
            }
            virtualServer.stop();
            engines[0].removeChild(virtualServer);
        }
    }

    public void updateHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, Server serverBean) throws LifecycleException {
        Engine[] engines = this._embedded.getEngines();
        VirtualServer virtualServer = (VirtualServer)engines[0].findChild(vsBean.getId());
        this._embedded.setLogFile(virtualServer, vsBean.getLogFile());
        this.configureVirtualServerState(virtualServer, vsBean);
        virtualServer.clearAliases();
        this.configureHostAlias(virtualServer);
        List listeners = StringUtils.parseStringList(vsBean.getHttpListeners(), ",");
        if (listeners != null) {
            HttpListener[] httpListeners = new HttpListener[listeners.size()];
            for (int i = 0; i < listeners.size(); ++i) {
                httpListeners[i] = httpService.getHttpListenerById((String)listeners.get(i));
            }
            this.configureHostListener(virtualServer, httpListeners);
            Connector[] connectors = this._embedded.findConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                PECoyoteConnector connector = (PECoyoteConnector)connectors[i];
                if (connector.isAvailable()) continue;
                connector.start();
                this.enableHttpListenerMonitoring(virtualServer, connector.getPort(), connector.getName());
            }
        }
        String defaultWebModule = virtualServer.getDefaultWebModuleID();
        String configWebModule = vsBean.getDefaultWebModule();
        if (configWebModule == null) {
            configWebModule = "";
        }
        if (defaultWebModule == null || !defaultWebModule.equals(configWebModule)) {
            if (defaultWebModule != null) {
                this.unloadWebModule("", "", virtualServer.getID(), null);
            }
            virtualServer.setBean(vsBean);
            if (configWebModule != "") {
                this.loadDefaultWebModule(virtualServer, serverBean);
            } else {
                WebModuleConfig wmc = virtualServer.createSystemDefaultWebModuleIfNecessary();
                if (wmc != null) {
                    this.loadStandaloneWebModule(virtualServer, wmc);
                }
            }
        }
    }

    public void updateHostProperties(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String name, String value, HttpService httpService) {
        Engine[] engines = this._embedded.getEngines();
        VirtualServer vs = (VirtualServer)engines[0].findChild(vsBean.getId());
        if ("docroot".equals(name)) {
            boolean isValid = this.validateDocroot(value, vsBean.getId(), vsBean.getDefaultWebModule());
            if (isValid) {
                vs.setAppBase(value);
            }
        } else if ("setCacheControl".equals(name)) {
            this.configureCacheControl(value, vs);
        } else if ("accesslog".equals(name)) {
            this.setAccessLog(vs, vsBean.getId(), vsBean, httpService);
        } else if ("allowRemoteHost".equals(name) || "denyRemoteHost".equals(name)) {
            this.configureRemoteHostFilterValve(vs, vsBean, httpService.getHttpProtocol());
        } else if ("allowRemoteAddress".equals(name) || "denyRemoteAddress".equals(name)) {
            this.configureRemoteAddressFilterValve(vs, vsBean);
        }
    }

    public void updateConnectorProperty(HttpListener httpListener, String propName, String propValue) throws LifecycleException {
        PECoyoteConnector connector = this.connectorMap.get(httpListener.getId());
        this.configureHttpListenerProperty(propName, propValue, connector);
    }

    public void updateConnector(HttpListener httpListener, HttpService httpService) throws LifecycleException {
        PECoyoteConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector == null) {
            throw new LifecycleException("Invalid http-listener:" + httpListener.getId());
        }
        int previousPort = connector.getPort();
        this._embedded.removeConnector(connector);
        this.connectorMap.remove(httpListener.getId());
        connector = this.createConnector(httpListener, httpService);
        String virtualServerName = httpListener.getDefaultVirtualServer();
        VirtualServer virtualServer = (VirtualServer)this._embedded.getEngines()[0].findChild(virtualServerName);
        int[] ports = virtualServer.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i] != previousPort) continue;
            ports[i] = connector.getPort();
        }
        virtualServer.setPorts(ports);
        connector.start();
    }

    public void deleteConnector(HttpService httpService) throws LifecycleException {
        int i;
        HttpListener[] httpListeners = httpService.getHttpListener();
        Connector[] connectors = (Connector[])this._embedded.findConnectors().clone();
        block0: for (i = 0; i < connectors.length; ++i) {
            for (int j = 0; j < httpListeners.length; ++j) {
                HttpListener httpListener = httpListeners[j];
                if (((PECoyoteConnector)connectors[i]).getPort() != Integer.parseInt(httpListener.getPort())) continue;
                connectors[i] = null;
                continue block0;
            }
        }
        for (i = 0; i < connectors.length; ++i) {
            if (connectors[i] == null) continue;
            this._embedded.removeConnector((PECoyoteConnector)connectors[i]);
        }
    }

    private void configureHttpProtocol(PECoyoteConnector connector, HttpProtocol httpProtocol) {
        if (httpProtocol == null) {
            return;
        }
        connector.setEnableLookups(httpProtocol.isDnsLookupEnabled());
        connector.setForcedResponseType(httpProtocol.getForcedResponseType());
        connector.setDefaultResponseType(httpProtocol.getDefaultResponseType());
    }

    private void configureFileCache(PECoyoteConnector connector, HttpFileCache httpFileCache) {
        if (httpFileCache == null) {
            return;
        }
        connector.setFileCacheEnabled(httpFileCache.isGloballyEnabled());
        connector.setLargeFileCacheEnabled(Boolean.parseBoolean(httpFileCache.getFileCachingEnabled()));
        connector.setSecondsMaxAge(Integer.parseInt(httpFileCache.getMaxAgeInSeconds()));
        connector.setMaxCacheEntries(Integer.parseInt(httpFileCache.getMaxFilesCount()));
        connector.setMinEntrySize(Integer.parseInt(httpFileCache.getSmallFileSizeLimitInBytes()));
        connector.setMaxEntrySize(Integer.parseInt(httpFileCache.getMediumFileSizeLimitInBytes()));
        connector.setMaxLargeCacheSize(Integer.parseInt(httpFileCache.getMediumFileSpaceInBytes()));
        connector.setMaxSmallCacheSize(Integer.parseInt(httpFileCache.getSmallFileSpaceInBytes()));
    }

    protected void configureRequestProcessing(HttpService httpService) {
        RequestProcessing rp = httpService.getRequestProcessing();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            this.configureRequestProcessing(rp, (PECoyoteConnector)connectors[i]);
        }
    }

    protected void configureRequestProcessing(RequestProcessing rp, PECoyoteConnector connector) {
        if (rp == null) {
            return;
        }
        try {
            connector.setMaxProcessors(Integer.parseInt(rp.getThreadCount()));
            connector.setMinProcessors(Integer.parseInt(rp.getInitialThreadCount()));
            connector.setProcessorWorkerThreadsTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            connector.setProcessorWorkerThreadsIncrement(Integer.parseInt(rp.getThreadIncrement()));
            connector.setMaxHttpHeaderSize(Integer.parseInt(rp.getHeaderBufferLengthInBytes()));
        }
        catch (NumberFormatException ex) {
            _logger.log(Level.WARNING, " Invalid request-processing attribute", ex);
        }
    }

    private void setProxyHandler(PECoyoteConnector connector, String className) {
        Object handler = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = _rb.getString("pewebcontainer.proxyHandlerClassLoadError");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, "pewebcontainer.proxyHandlerClassInvalid", className);
            } else {
                connector.setProxyHandler(handler);
            }
        }
    }
}

