/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.SessionPurgeCapable;

public class SessionPurgeUtil {
    protected EmbeddedWebContainer _embedded = null;
    private WebContainer webContainer = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    public SessionPurgeUtil() {
    }

    public SessionPurgeUtil(EmbeddedWebContainer embedded) {
        this._embedded = embedded;
    }

    public String getApplicationId(Context ctx) {
        WebModule wm = (WebModule)ctx;
        return wm.getID();
    }

    public String getApplicationName(Context ctx) {
        return ctx.getName();
    }

    public String getJ2EEApplicationName(Context ctx) {
        return ((StandardContext)ctx).getJ2EEApplication();
    }

    public void purgeSessionsForContext(Context ctx) {
        Manager mgr = ctx.getManager();
        _logger.finest("SessionPurgeUtil: mgr = " + mgr);
        _logger.finest("SessionPurgeUtil: mgr SessionPurgeCapable: " + (mgr instanceof SessionPurgeCapable));
        if (mgr instanceof SessionPurgeCapable) {
            ((SessionPurgeCapable)((Object)mgr)).clearSessions();
            ((SessionPurgeCapable)((Object)mgr)).clearStore();
        }
    }

    public void purgeSessionsForApp(String appName) {
        _logger.finest("IN SessionPurgeUtil:purgeSessionsForApp" + appName);
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        String webAppName = this.getApplicationName(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        _logger.finest("webAppName = " + webAppName + ", appName = " + appName);
                        if (!webAppName.equals(appName)) continue;
                        _logger.finest("found our manager:" + nextManager.getClass().getName());
                        if (!(nextManager instanceof SessionPurgeCapable)) continue;
                        ((SessionPurgeCapable)((Object)nextManager)).clearSessions();
                        ((SessionPurgeCapable)((Object)nextManager)).clearStore();
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }

    public void closeCachedConnectionForApp(String appName) {
        _logger.finest("IN SessionPurgeUtil:closeCachedConnectionForApp" + appName);
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        String webAppName = this.getApplicationName(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        _logger.finest("webAppName = " + webAppName + ", appName = " + appName);
                        if (!webAppName.equals(appName)) continue;
                        _logger.finest("found our manager:" + nextManager.getClass().getName());
                        if (!(nextManager instanceof ShutdownCleanupCapable)) continue;
                        ShutdownCleanupCapable nextOne = (ShutdownCleanupCapable)((Object)nextManager);
                        nextOne.doCloseCachedConnection();
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }
}

