/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.ara;

import com.sun.enterprise.web.ara.RulesExecutor;
import com.sun.enterprise.web.ara.TaskWrapper;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedTask
extends TaskWrapper
implements TaskListener {
    public static final int ISOLATED_TASK = 4;
    protected StreamAlgorithm algorithm;
    protected RulesExecutor rulesExecutor;
    protected ArrayList<TaskListener> listeners = new ArrayList();
    protected int initialBytePosition;
    protected int initialByteLimit;
    protected TaskEvent<IsolatedTask> taskEvent = new TaskEvent();
    private static ConcurrentHashMap<SelectionKey, Pipeline> cacheKey = new ConcurrentHashMap();

    public IsolatedTask() {
        this.taskEvent.attach(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTask() throws IOException {
        ReadTask readTask = (ReadTask)this.wrappedTask;
        Pipeline pipeline = cacheKey.get(readTask.getSelectionKey());
        if (pipeline != null) {
            readTask.setPipeline(pipeline);
            readTask.execute();
            return;
        }
        ByteBuffer byteBuffer = readTask.getByteBuffer();
        try {
            SocketChannel socketChannel = (SocketChannel)readTask.getSelectionKey().channel();
            Socket socket = socketChannel.socket();
            socketChannel.read(byteBuffer);
            int position = byteBuffer.position();
            int limit = byteBuffer.limit();
            boolean execute = true;
            if (this.algorithm.parse(byteBuffer)) {
                execute = this.rulesExecutor.execute(this);
            }
            if (execute) {
                readTask.setBytesAvailable(true);
                byteBuffer.limit(limit);
                byteBuffer.position(position);
                if (this.rulesExecutor.isCachingAllowed()) {
                    cacheKey.put(readTask.getSelectionKey(), readTask.getPipeline());
                }
                readTask.addTaskListener(this);
                readTask.execute();
            }
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "IsolatedTask logic exception.", ex);
        }
        finally {
            this.fireTaskEvent(this.taskEvent);
        }
    }

    public void setRulesExecutor(RulesExecutor rulesExecutor) {
        this.rulesExecutor = rulesExecutor;
    }

    public void setAlgorithm(StreamAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public IsolatedTask wrap(Task task) {
        this.wrappedTask = task;
        return this;
    }

    @Override
    public void execute() {
        this.run();
    }

    @Override
    public void run() {
        try {
            this.doTask();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addTaskListener(TaskListener task) {
        this.listeners.add(task);
    }

    @Override
    public void removeTaskListener(TaskListener task) {
        this.listeners.remove(task);
    }

    @Override
    public void clearTaskListeners() {
        this.listeners.clear();
    }

    protected void fireTaskEvent(TaskEvent<?> event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskEvent(event);
        }
    }

    @Override
    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2) {
            cacheKey.remove(event.attachement());
        }
    }

    @Override
    public int getType() {
        return 4;
    }
}

