/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.HtmlHelper;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.WorkerThread;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class LinkedListPipeline
extends LinkedList
implements Pipeline {
    protected int waitingThreads = 0;
    protected int maxThreads = 20;
    protected int minThreads = 5;
    protected int minSpareThreads = 2;
    protected int port = 8080;
    protected int threadCount = 0;
    protected String name;
    protected int priority = 5;
    protected boolean isStarted = false;
    protected WorkerThread[] workerThreads;
    protected int maxQueueSizeInBytes = -1;
    protected int threadsIncrement = 1;
    protected int threadsTimeout = 30;
    protected PipelineStatistic pipelineStat;

    public LinkedListPipeline() {
    }

    public LinkedListPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        this.maxThreads = maxThreads;
        this.port = port;
        this.name = name;
        this.minThreads = minThreads;
        this.priority = priority;
        if (minThreads < this.minSpareThreads) {
            this.minSpareThreads = minThreads;
        }
    }

    public LinkedListPipeline(int maxThreads, int minThreads, String name, int port) {
        this(maxThreads, minThreads, name, port, 5);
    }

    public void initPipeline() {
        if (this.minThreads > this.maxThreads) {
            this.minThreads = this.maxThreads;
        }
        this.workerThreads = new WorkerThread[this.maxThreads];
        this.increaseWorkerThread(this.minThreads, false);
    }

    public void startPipeline() {
        if (!this.isStarted) {
            for (int i = 0; i < this.minThreads; ++i) {
                this.workerThreads[i].start();
            }
            this.isStarted = true;
        }
    }

    public void stopPipeline() {
        if (this.isStarted) {
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].terminate();
            }
            this.isStarted = false;
        }
    }

    protected void increaseWorkerThread(int increment, boolean startThread) {
        int currentCount = this.threadCount;
        int increaseCount = this.threadCount + increment;
        for (int i = currentCount; i < increaseCount; ++i) {
            WorkerThread workerThread = new WorkerThread(this, this.name + "WorkerThread-" + this.port + "-" + i);
            workerThread.setPriority(this.priority);
            if (startThread) {
                workerThread.start();
            }
            this.workerThreads[i] = workerThread;
            ++this.threadCount;
        }
    }

    public boolean interruptThread(long threadID) {
        ThreadGroup threadGroup = this.workerThreads[0].getThreadGroup();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || thread.getId() != threadID || Thread.State.RUNNABLE == thread.getState()) continue;
            try {
                thread.interrupt();
                return true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void addTask(Task task) {
        boolean rejected = false;
        int queueSize = this.size();
        if (this.maxQueueSizeInBytes != -1 && this.maxQueueSizeInBytes < queueSize) {
            task.cancelTask("Maximum Connections Reached: " + this.maxQueueSizeInBytes + " -- Retry later", HtmlHelper.OK);
            task.getSelectorThread().returnTask(task);
            return;
        }
        this.addLast(task);
        this.notify();
        if (this.threadCount < this.maxThreads && this.waitingThreads < queueSize) {
            int left = this.maxThreads - this.threadCount;
            if (this.threadsIncrement > left) {
                this.threadsIncrement = left;
            }
            this.increaseWorkerThread(this.threadsIncrement, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Task getTask() {
        if (this.isEmpty()) {
            try {
                ++this.waitingThreads;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            --this.waitingThreads;
        }
        try {
            Task e = (Task)this.removeFirst();
            return e;
        }
        catch (NoSuchElementException e) {
            Task task = null;
            return task;
        }
        finally {
            if (this.pipelineStat != null) {
                this.pipelineStat.gather(this.size());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() - this.waitingThreads <= 0;
    }

    public int getWaitingThread() {
        return this.waitingThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCurrentThreadCount() {
        return this.threadCount;
    }

    public int getCurrentThreadsBusy() {
        return this.threadCount - this.waitingThreads;
    }

    public int getMaxSpareThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public String toString() {
        return "name: " + this.name + " maxThreads: " + this.maxThreads + " minThreads:" + this.minThreads;
    }

    public void setThreadsIncrement(int threadsIncrement) {
        this.threadsIncrement = threadsIncrement;
    }

    public void setThreadsTimeout(int threadsTimeout) {
        this.threadsTimeout = threadsTimeout;
    }

    public int getTaskQueuedCount() {
        return this.size();
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytesCount) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytesCount;
    }

    public int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }
}

