/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.async;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class DefaultAsyncExecutor
implements AsyncExecutor {
    private static final String ASYNC_FILTER = "com.sun.enterprise.web.connector.grizzly.asyncFilters";
    private AsyncProcessorTask asyncProcessorTask;
    private ProcessorTask processorTask;
    private static AsyncFilter[] sharedAsyncFilters = null;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private boolean invokeFilter = true;

    public DefaultAsyncExecutor() {
        this.init();
    }

    private void init() {
        if (sharedAsyncFilters != null) {
            for (AsyncFilter o : sharedAsyncFilters) {
                this.asyncFilters.add(o);
            }
        }
    }

    public boolean preExecute() throws Exception {
        this.processorTask = this.asyncProcessorTask.getProcessorTask();
        this.processorTask.preProcess();
        this.processorTask.parseRequest();
        return true;
    }

    public boolean interrupt() throws Exception {
        if (this.asyncFilters == null || this.asyncFilters.size() == 0) {
            this.processorTask.invokeAdapter();
            return true;
        }
        this.processorTask.getAsyncHandler().addToInterruptedQueue(this.asyncProcessorTask);
        return this.invokeFilters();
    }

    private boolean invokeFilters() {
        AsyncFilter asf;
        boolean continueExec = true;
        Iterator<AsyncFilter> i$ = this.asyncFilters.iterator();
        while (i$.hasNext() && (continueExec = (asf = i$.next()).doFilter(this))) {
        }
        return continueExec;
    }

    public boolean postExecute() throws Exception {
        this.processorTask.postResponse();
        this.processorTask.postProcess();
        this.processorTask.terminateProcess();
        this.processorTask = null;
        return false;
    }

    public void setAsyncProcessorTask(AsyncProcessorTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    public AsyncProcessorTask getAsyncProcessorTask() {
        return this.asyncProcessorTask;
    }

    protected static void loadFilters() {
        if (System.getProperty(ASYNC_FILTER) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(ASYNC_FILTER), ",");
            sharedAsyncFilters = new AsyncFilter[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                AsyncFilter asf = DefaultAsyncExecutor.loadInstance(st.nextToken());
                if (asf == null) continue;
                DefaultAsyncExecutor.sharedAsyncFilters[i++] = asf;
            }
        }
    }

    private static AsyncFilter loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property);
            return (AsyncFilter)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            SelectorThread.logger().log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            SelectorThread.logger().log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            SelectorThread.logger().log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }

    static {
        DefaultAsyncExecutor.loadFilters();
    }
}

