/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.jauth.callback.CertStoreCallback;
import com.sun.enterprise.security.jauth.callback.PasswordValidationCallback;
import com.sun.enterprise.security.jauth.callback.PrivateKeyCallback;
import com.sun.enterprise.security.jauth.callback.SecretKeyCallback;
import com.sun.enterprise.security.jauth.callback.TrustStoreCallback;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import java.io.IOException;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class AppclientWSSCallbackHandler
extends WSSCallbackHandler {
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static WSSCallbackHandler INSTANCE = null;

    private AppclientWSSCallbackHandler() {
    }

    static WSSCallbackHandler newInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AppclientWSSCallbackHandler();
        }
        return INSTANCE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        boolean processedSomeAppclientCallbacks = false;
        for (int i = 0; i < callbacks.length; ++i) {
            if (!this.isSupportedCallback(callbacks[i])) {
                _logger.log(Level.FINE, "wss-container-auth: UnsupportedCallback : " + callbacks[i].getClass().getName());
                throw new UnsupportedCallbackException(callbacks[i]);
            }
            if (!processedSomeAppclientCallbacks && (callbacks[i] instanceof NameCallback || callbacks[i] instanceof PasswordCallback || callbacks[i] instanceof ChoiceCallback)) {
                String loginName = System.getProperty(LOGIN_NAME);
                CallbackHandler callbackHandler = AppContainer.getCallbackHandler();
                if (loginName != null) {
                    String password = System.getProperty(LOGIN_PASSWORD);
                    for (int j = 0; j < callbacks.length; ++j) {
                        if (callbacks[j] instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callbacks[j];
                            nc.setName(loginName);
                            continue;
                        }
                        if (!(callbacks[j] instanceof PasswordCallback)) continue;
                        PasswordCallback pc = (PasswordCallback)callbacks[j];
                        if (password != null) {
                            pc.setPassword(password.toCharArray());
                            continue;
                        }
                        callbackHandler.handle(callbacks);
                    }
                } else {
                    callbackHandler.handle(callbacks);
                }
                processedSomeAppclientCallbacks = true;
                break;
            }
            this.processCallback(callbacks[i]);
        }
    }

    boolean isSupportedCallback(Callback callback) {
        boolean supported = false;
        supported = callback instanceof NameCallback ? true : (callback instanceof PasswordCallback ? true : (callback instanceof ChoiceCallback ? true : (callback instanceof CertStoreCallback ? true : (callback instanceof PasswordValidationCallback ? true : (callback instanceof SecretKeyCallback ? true : (callback instanceof PrivateKeyCallback ? true : callback instanceof TrustStoreCallback))))));
        return supported;
    }
}

