/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAXWSRuntimeEpiRegistry {
    private static JAXWSRuntimeEpiRegistry registry = null;
    private Map store;
    Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static StringManager localStrings = StringManager.getManager(JAXWSRuntimeEpiRegistry.class);

    private JAXWSRuntimeEpiRegistry() {
        this.store = new HashMap();
    }

    public static JAXWSRuntimeEpiRegistry getInstance() {
        if (registry == null) {
            registry = new JAXWSRuntimeEpiRegistry();
        }
        return registry;
    }

    public void addRuntimeEndpointInfo(String contextRoot, String urlPattern, RuntimeEndpointInfo info) {
        ContextRuntimeEndpointInfo contextRtInfo;
        if (contextRoot == null) {
            contextRoot = "";
        }
        if ((contextRtInfo = (ContextRuntimeEndpointInfo)this.store.get(contextRoot)) == null) {
            contextRtInfo = new ContextRuntimeEndpointInfo(contextRoot);
        }
        contextRtInfo.addRuntimeEndpointInfo(urlPattern, info);
        this.store.put(contextRoot, contextRtInfo);
    }

    public RuntimeEndpointInfo getRuntimeEndpointInfo(String contextRoot, String path, String urlPattern) {
        ContextRuntimeEndpointInfo serviceInfo = (ContextRuntimeEndpointInfo)this.store.get(contextRoot);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getRuntimeEndpointInfo(path, urlPattern);
    }

    public void removeRuntimeInfo(String contextRoot) {
        ContextRuntimeEndpointInfo serviceInfo;
        if (contextRoot == null) {
            contextRoot = "";
        }
        if ((serviceInfo = (ContextRuntimeEndpointInfo)this.store.get(contextRoot)) == null) {
            return;
        }
        this.store.remove(contextRoot);
    }

    class ContextRuntimeEndpointInfo {
        String contextRoot;
        Map fixedUrlPatternEndpoints;
        List<RuntimeEndpointInfo> pathUrlPatternEndpoints;

        ContextRuntimeEndpointInfo(String contextRoot) {
            this.contextRoot = contextRoot;
            this.fixedUrlPatternEndpoints = new HashMap();
            this.pathUrlPatternEndpoints = new ArrayList<RuntimeEndpointInfo>();
        }

        void addRuntimeEndpointInfo(String urlPattern, RuntimeEndpointInfo info) {
            if (urlPattern.indexOf("*.") != -1) {
                JAXWSRuntimeEpiRegistry.this.logger.log(Level.SEVERE, localStrings.getString("enterprise.webservice.implicitMappingNotSupported"));
            } else if (urlPattern.endsWith("/*")) {
                this.pathUrlPatternEndpoints.add(info);
            } else {
                if (this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
                    JAXWSRuntimeEpiRegistry.this.logger.log(Level.SEVERE, localStrings.getString("enterprise.webservice.duplicateService", new Object[]{urlPattern}));
                }
                this.fixedUrlPatternEndpoints.put(urlPattern, info);
            }
        }

        RuntimeEndpointInfo getRuntimeEndpointInfo(String path, String urlPattern) {
            RuntimeEndpointInfo result = (RuntimeEndpointInfo)this.fixedUrlPatternEndpoints.get(path);
            if (result == null) {
                for (RuntimeEndpointInfo candidate : this.pathUrlPatternEndpoints) {
                    if (!path.startsWith(this.getValidPathForEndpoint(urlPattern))) continue;
                    result = candidate;
                    break;
                }
            }
            return result;
        }

        private String getValidPathForEndpoint(String s) {
            if (s.endsWith("/*")) {
                return s.substring(0, s.length() - 2);
            }
            return s;
        }
    }
}

