/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.ServiceEngineRtObjectFactory;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.ClientTransportFactory;
import com.sun.xml.rpc.spi.runtime.StubBase;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;

public class ServiceEngineUtil {
    public static String JBI_ENABLED = "jbi-enabled";
    private static final String SE_DISABLE_PROPERTY = "com.sun.enterprise.jbi.se.disable";
    private static String seDisablePropertyValue = null;
    private static boolean seEnabledFlag = true;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system");

    public static boolean isServiceJBIEnabled(ServiceReferenceDescriptor desc) {
        if (ServiceEngineUtil.isServiceEngineEnabled()) {
            Set portsInfo = desc.getPortsInfo();
            for (ServiceRefPortInfo portDesc : portsInfo) {
                if (!ServiceEngineUtil.isPortJbiEnabled(portDesc)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setJBITransportFactory(ServiceReferenceDescriptor serviceRef, Object stubObj, Class sei) {
        if (ServiceEngineUtil.isServiceEngineEnabled()) {
            ServiceRefPortInfo portInfo = ServiceEngineUtil.getPortInfo(sei, serviceRef);
            boolean jbiEnabledFlag = ServiceEngineUtil.isPortJbiEnabled(portInfo);
            ServiceEngineUtil.setJBITransportFactory(portInfo, stubObj, jbiEnabledFlag);
        } else {
            logger.log(Level.FINE, "Java EE Service Engine's functionality is disabled");
        }
    }

    public static void setJBITransportFactory(ServiceRefPortInfo portInfo, Object stubObj, boolean jbiEnabled) {
        if (ServiceEngineUtil.isServiceEngineEnabled()) {
            ServiceReferenceDescriptor serviceRef = portInfo.getServiceReference();
            if (serviceRef != null && stubObj != null && ServiceEngineUtil.isServiceEngineEnabled() && jbiEnabled) {
                if (serviceRef.getMappingFileUri() == null) {
                    ServiceEngineUtil.setTransportFactory((com.sun.xml.ws.spi.runtime.StubBase)stubObj, portInfo);
                } else {
                    ServiceEngineUtil.setTransportFactory((StubBase)stubObj, portInfo);
                }
            }
        } else {
            logger.log(Level.FINE, "Java EE Service Engine's functionality is disabled");
        }
    }

    public static boolean isServiceEngineEnabled() {
        if (seDisablePropertyValue == null) {
            seDisablePropertyValue = System.getProperty(SE_DISABLE_PROPERTY);
            logger.log(Level.FINE, SE_DISABLE_PROPERTY, " value is " + seDisablePropertyValue);
            if (seDisablePropertyValue != null) {
                seEnabledFlag = "false".equals(seDisablePropertyValue);
            }
        }
        return seEnabledFlag;
    }

    private static ServiceRefPortInfo getPortInfo(Class sei, ServiceReferenceDescriptor serviceRef) {
        if (serviceRef != null) {
            if (sei == null) {
                try {
                    sei = Class.forName(serviceRef.getServiceInterface());
                }
                catch (Throwable cnfe) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Error during setting of transport factory" + cnfe.getMessage());
                    }
                    return null;
                }
            }
            return serviceRef.getPortInfo(sei.getName());
        }
        return null;
    }

    private static boolean isPortJbiEnabled(Class sei, ServiceReferenceDescriptor serviceRef) {
        if (serviceRef != null) {
            if (sei == null) {
                try {
                    sei = Class.forName(serviceRef.getServiceInterface());
                }
                catch (Throwable cnfe) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Error during setting of transport factory" + cnfe.getMessage());
                    }
                    return false;
                }
            }
            return ServiceEngineUtil.isPortJbiEnabled(serviceRef.getPortInfo(sei.getName()));
        }
        return false;
    }

    private static boolean isPortJbiEnabled(ServiceRefPortInfo portInfo) {
        if (portInfo != null) {
            String value = portInfo.getStubPropertyValue(JBI_ENABLED);
            logger.log(Level.FINEST, "JBI_ENABLED flag value is : " + value);
            return "true".equals(value);
        }
        return false;
    }

    private static void setTransportFactory(com.sun.xml.ws.spi.runtime.StubBase stubObj, ServiceRefPortInfo portInfo) {
        block3: {
            BindingProvider bindingProvider = (BindingProvider)stubObj;
            Map requestContext = bindingProvider.getRequestContext();
            String obj = (String)requestContext.get("com.sun.xml.ws.server.OneWayOperation");
            boolean oneWay = Boolean.valueOf(obj);
            try {
                com.sun.xml.ws.spi.runtime.ClientTransportFactory factory = (com.sun.xml.ws.spi.runtime.ClientTransportFactory)ServiceEngineRtObjectFactory.getInstance().getFacade().getTransportFactory(portInfo, true, oneWay);
                if (factory == null) {
                    return;
                }
                logger.log(Level.FINE, "Before setting setTransportFactory to NMR");
                stubObj._setTransportFactory(factory);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Error during setting of transport factory" + e.getMessage());
            }
        }
    }

    private static void setTransportFactory(StubBase stubObj, ServiceRefPortInfo portInfo) {
        block3: {
            try {
                ClientTransportFactory factory = (ClientTransportFactory)ServiceEngineRtObjectFactory.getInstance().getFacade().getTransportFactory(portInfo, false, true);
                if (factory == null) {
                    return;
                }
                logger.log(Level.FINE, "Before setting setTransportFactory to NMR");
                stubObj._setTransportFactory(factory);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Error during setting of transport factory" + e.getMessage());
            }
        }
    }
}

