/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.monitoring;

import com.sun.enterprise.webservice.monitoring.EndpointImpl;
import com.sun.enterprise.webservice.monitoring.EndpointType;
import com.sun.enterprise.webservice.monitoring.HttpRequestInfoImpl;
import com.sun.enterprise.webservice.monitoring.MessageListener;
import com.sun.enterprise.webservice.monitoring.MessageTrace;
import com.sun.enterprise.webservice.monitoring.MessageTraceImpl;
import com.sun.enterprise.webservice.monitoring.TransportInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.xml.ws.spi.runtime.MessageContext;
import com.sun.xml.ws.spi.runtime.SOAPMessageContext;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import javax.servlet.http.HttpServletRequest;

public class JAXWSEndpointImpl
extends EndpointImpl
implements SystemHandlerDelegate {
    SystemHandlerDelegate parent = null;

    JAXWSEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }

    public boolean processRequest(MessageContext ctxt) throws Exception {
        boolean status = true;
        if (!(ctxt instanceof SOAPMessageContext)) {
            return status;
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)ctxt;
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (this.parent != null) {
                status = this.parent.processRequest(ctxt);
            }
            if (!this.listeners.isEmpty() || wsEngine.hasGlobalMessageListener()) {
                String messageID = (String)messageContext.get((Object)"MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
                    HttpRequestInfoImpl info = new HttpRequestInfoImpl(httpReq);
                    wsEngine.processRequest(messageID, messageContext, (TransportInfo)info);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl request = new MessageTraceImpl();
                    request.setEndpoint(this);
                    request.setMessageContext(messageContext);
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
                    request.setTransportInfo(new HttpRequestInfoImpl(httpReq));
                    messageContext.put((Object)"MONITORING_REQUEST_MESSAGE_TRACE", (Object)request);
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.warning("Exception while tracing request : " + e.getMessage());
            throw e;
        }
        return status;
    }

    public void processResponse(MessageContext ctxt) throws Exception {
        if (!(ctxt instanceof SOAPMessageContext)) {
            return;
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)ctxt;
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (wsEngine.hasGlobalMessageListener() || !this.listeners.isEmpty()) {
                String messageID = (String)messageContext.get((Object)"MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    wsEngine.processResponse(messageID, messageContext);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl response = new MessageTraceImpl();
                    response.setEndpoint(this);
                    response.setMessageContext(messageContext);
                    for (MessageListener listener : this.listeners) {
                        listener.invocationProcessed((MessageTrace)messageContext.get((Object)"MONITORING_REQUEST_MESSAGE_TRACE"), response);
                    }
                }
            }
            if (this.parent != null) {
                this.parent.processResponse(ctxt);
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.warning("Exception while tracing response : " + e.getMessage());
            throw e;
        }
    }

    public void preInvokeEndpointHook(MessageContext messageContext) {
        if (this.parent != null) {
            this.parent.preInvokeEndpointHook(messageContext);
        }
    }

    public void setParent(SystemHandlerDelegate parent) {
        this.parent = parent;
    }
}

