/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.spi;

import com.sun.enterprise.webservice.ServiceCreationListenerImpl;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.spi.ServiceDelegateCreationListener;
import com.sun.enterprise.webservice.spi.ServiceDelegateFactory;
import com.sun.enterprise.webservice.spi.ServiceDelegateImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.ws.spi.ServiceDelegate;

public class DefaultServiceDelegateFactory
implements ServiceDelegateFactory {
    static ServiceDelegateFactory factory;
    ArrayList<ServiceDelegateCreationListener> listeners = new ArrayList();

    public static void setFactory(ServiceDelegateFactory f) {
        factory = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDelegateFactory getFactory() {
        if (factory != null) return factory;
        Class<DefaultServiceDelegateFactory> clazz = DefaultServiceDelegateFactory.class;
        synchronized (DefaultServiceDelegateFactory.class) {
            if (factory != null) return factory;
            factory = new DefaultServiceDelegateFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    protected DefaultServiceDelegateFactory() {
        this.addListener(ServiceCreationListenerImpl.getDefaultListener());
    }

    public ServiceDelegate create(ServiceDelegate delegate) {
        ServiceDelegateImpl ourServiceDelegate = new ServiceDelegateImpl(delegate);
        this.serviceCreated(ourServiceDelegate);
        return ourServiceDelegate;
    }

    public void addListener(ServiceDelegateCreationListener listener) {
        this.listeners.add(listener);
    }

    private void serviceCreated(ServiceDelegateImpl delegate) {
        for (ServiceDelegateCreationListener listener : this.listeners) {
            try {
                listener.serviceCreated(delegate);
            }
            catch (Throwable t) {
                WsUtil.getDefaultLogger().severe("Exception " + t.getMessage() + " in serviceDelegateCreationListener : " + listener);
                WsUtil.getDefaultLogger().log(Level.FINE, t.getMessage(), t);
            }
        }
    }
}

